/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.file.FileUtil;
import icy.main.Icy;
import icy.system.thread.ThreadUtil;
import java.io.File;
import javax.swing.JFileChooser;

public class OpenDialog {
    public static String chooseFile(String title, String defaultDir, String defaultName, String extension) {
        OpenDialogRunner runner = new OpenDialogRunner(title, defaultDir, defaultName, extension);
        if (Icy.getMainInterface().isHeadLess()) {
            return null;
        }
        ThreadUtil.invokeNow(runner);
        return runner.result;
    }

    public static String chooseFile(String title, String defaultDir, String defaultName) {
        return OpenDialog.chooseFile(title, defaultDir, defaultName, null);
    }

    public static String chooseFile(String defaultDir, String defaultName) {
        return OpenDialog.chooseFile("Load file...", defaultDir, defaultName);
    }

    public static String chooseFile() {
        return OpenDialog.chooseFile(null, null);
    }

    private static class OpenDialogRunner
    implements Runnable {
        private final String title;
        private final String defaultDir;
        private final String defaultName;
        private final String extension;
        private JFileChooser dialog;
        String result;

        public OpenDialogRunner(String title, String defaultDir, String defaultName, String extension) {
            this.title = title;
            this.defaultDir = defaultDir;
            this.defaultName = defaultName;
            this.extension = extension;
        }

        @Override
        public void run() {
            int returnVal;
            this.result = null;
            String defaultFileName = this.defaultName != null && this.extension != null ? FileUtil.setExtension(this.defaultName, this.extension) : this.defaultName;
            if (this.dialog == null) {
                this.dialog = new JFileChooser();
            }
            this.dialog.setDialogTitle(this.title);
            if (this.defaultDir != null) {
                this.dialog.setCurrentDirectory(new File(this.defaultDir));
            }
            if (defaultFileName != null) {
                this.dialog.setSelectedFile(new File(defaultFileName));
            }
            if ((returnVal = this.dialog.showOpenDialog(null)) != 0) {
                return;
            }
            File f = this.dialog.getSelectedFile();
            if (!f.exists()) {
                return;
            }
            this.result = f.getAbsolutePath();
        }
    }
}

