/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.viewer;

import icy.gui.viewer.Viewer;
import icy.sequence.DimensionId;

public class ViewerEvent {
    private final Viewer source;
    private final ViewerEventType type;
    private final DimensionId dim;

    public ViewerEvent(Viewer source, ViewerEventType type, DimensionId dim) {
        this.source = source;
        this.type = type;
        this.dim = dim;
    }

    public ViewerEvent(Viewer source, ViewerEventType type) {
        this(source, type, DimensionId.NULL);
    }

    public Viewer getSource() {
        return this.source;
    }

    public ViewerEventType getType() {
        return this.type;
    }

    public DimensionId getDim() {
        return this.dim;
    }

    public int hashCode() {
        return this.source.hashCode() ^ this.type.hashCode() ^ this.dim.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ViewerEvent) {
            ViewerEvent e = (ViewerEvent)obj;
            return e.getSource() == this.source && e.getType() == this.type && e.getDim() == this.dim;
        }
        return super.equals(obj);
    }

    public static enum ViewerEventType {
        POSITION_CHANGED,
        CANVAS_CHANGED,
        LUT_CHANGED;

    }
}

