/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.math.ArrayMath;
import java.util.Arrays;

public class HungarianAlgorithm {
    final int numRow;
    final int numCol;
    final int k;
    final double[][] costs;
    final int[] rowsStar;
    final int[] colsStar;
    final int[] rowsPrime;
    final boolean[] rowsCovered;
    final boolean[] colsCovered;
    final int[] colsUnStar;
    final int[] rowsDoStar;
    int step;
    boolean done;

    public HungarianAlgorithm(double[][] values) {
        int r;
        int initialNumCol = values[0].length;
        this.numRow = values.length;
        this.numCol = Math.max(initialNumCol, this.numRow);
        this.k = Math.min(this.numRow, this.numCol);
        this.costs = new double[this.numRow][this.numCol];
        double max = values[0][0];
        if (initialNumCol < this.numRow) {
            r = 0;
            while (r < values.length) {
                double v = ArrayMath.max(values[r]);
                if (v > max) {
                    max = v;
                }
                ++r;
            }
        }
        r = 0;
        while (r < values.length) {
            double[] rowValues = values[r];
            double[] rowCosts = this.costs[r];
            int c = 0;
            while (c < rowValues.length) {
                rowCosts[c] = rowValues[c];
                ++c;
            }
            while (c < this.numCol) {
                rowCosts[c] = max;
                ++c;
            }
            ++r;
        }
        this.rowsStar = new int[this.numRow];
        this.colsStar = new int[this.numCol];
        this.rowsPrime = new int[this.numRow];
        this.rowsCovered = new boolean[this.numRow];
        this.colsCovered = new boolean[this.numCol];
        this.colsUnStar = new int[this.numCol];
        this.rowsDoStar = new int[this.numRow];
        Arrays.fill(this.rowsPrime, -1);
    }

    public int[] resolve() {
        this.initialReduce();
        this.done = false;
        this.step = 2;
        while (!this.done) {
            switch (this.step) {
                case 2: {
                    this.updateStar();
                    break;
                }
                case 3: {
                    this.doColCover();
                    break;
                }
                case 4: {
                    this.doPrime();
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    this.reduce();
                }
            }
        }
        return this.rowsStar;
    }

    private void initialReduce() {
        int r = 0;
        while (r < this.numRow) {
            double[] rowCosts = this.costs[r];
            double min = ArrayMath.min(rowCosts);
            int c = 0;
            while (c < this.numCol) {
                int n = c++;
                rowCosts[n] = rowCosts[n] - min;
            }
            ++r;
        }
    }

    private void updateStar() {
        Arrays.fill(this.rowsStar, -1);
        Arrays.fill(this.colsStar, -1);
        int r = 0;
        while (r < this.numRow) {
            this.updateRowStar(r);
            ++r;
        }
        this.step = 3;
    }

    private void updateRowStar(int r) {
        double[] rowCosts = this.costs[r];
        int c = 0;
        while (c < this.numCol) {
            if (this.colsStar[c] == -1 && rowCosts[c] == 0.0) {
                this.rowsStar[r] = c;
                this.colsStar[c] = r;
                return;
            }
            ++c;
        }
    }

    private void doColCover() {
        Arrays.fill(this.colsCovered, false);
        int numColCovered = 0;
        int c = 0;
        while (c < this.numCol) {
            if (this.colsStar[c] != -1) {
                this.colsCovered[c] = true;
                ++numColCovered;
            }
            ++c;
        }
        if (numColCovered == this.k) {
            this.done = true;
        } else {
            this.step = 4;
        }
    }

    private void doPrime() {
        int c = 0;
        while (c < this.numCol) {
            if (!this.colsCovered[c] && this.doPrimCol(c)) {
                return;
            }
            ++c;
        }
        this.step = 6;
    }

    private boolean doPrimCol(int c) {
        int r = 0;
        while (r < this.numRow) {
            if (!this.rowsCovered[r] && this.costs[r][c] == 0.0) {
                this.rowsPrime[r] = c;
                int starCol = this.rowsStar[r];
                if (starCol == -1) {
                    this.convertPrimeToStar(r, c);
                    return true;
                }
                this.rowsCovered[r] = true;
                this.colsCovered[starCol] = false;
                if (starCol < c && this.doPrimCol(starCol)) {
                    return true;
                }
            }
            ++r;
        }
        return false;
    }

    private void convertPrimeToStar(int r, int c) {
        int nb = 0;
        int primeCol = c;
        int starRow = this.colsStar[primeCol];
        while (starRow != -1) {
            this.colsUnStar[nb] = primeCol;
            this.rowsDoStar[nb] = starRow;
            ++nb;
            primeCol = this.rowsPrime[starRow];
            starRow = this.colsStar[primeCol];
        }
        int i = 0;
        while (i < nb) {
            int startCol = this.colsUnStar[i];
            this.rowsStar[this.colsStar[startCol]] = -1;
            this.colsStar[startCol] = -1;
            ++i;
        }
        i = 0;
        while (i < nb) {
            int primeRow = this.rowsDoStar[i];
            int pc = this.rowsPrime[primeRow];
            this.colsStar[pc] = primeRow;
            this.rowsStar[primeRow] = pc;
            ++i;
        }
        this.colsStar[c] = r;
        this.rowsStar[r] = c;
        Arrays.fill(this.rowsPrime, -1);
        Arrays.fill(this.rowsCovered, false);
        Arrays.fill(this.colsCovered, false);
        this.step = 3;
    }

    private void reduce() {
        int c;
        double[] rowCosts;
        double min = Double.MAX_VALUE;
        int r = 0;
        while (r < this.numRow) {
            if (!this.rowsCovered[r]) {
                rowCosts = this.costs[r];
                c = 0;
                while (c < this.numCol) {
                    double v;
                    if (!this.colsCovered[c] && (v = rowCosts[c]) < min) {
                        min = v;
                    }
                    ++c;
                }
            }
            ++r;
        }
        r = 0;
        while (r < this.numRow) {
            rowCosts = this.costs[r];
            if (this.rowsCovered[r]) {
                c = 0;
                while (c < this.numCol) {
                    if (this.colsCovered[c]) {
                        int n = c;
                        rowCosts[n] = rowCosts[n] + min;
                    }
                    ++c;
                }
            } else {
                c = 0;
                while (c < this.numCol) {
                    if (!this.colsCovered[c]) {
                        int n = c;
                        rowCosts[n] = rowCosts[n] - min;
                    }
                    ++c;
                }
            }
            ++r;
        }
        this.step = 4;
    }
}

