/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.sequence.Sequence;
import icy.type.collection.array.DynamicArray;
import icy.type.point.Point3D;
import icy.type.rectangle.Rectangle3D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class BooleanMask3D
implements Cloneable {
    public Rectangle3D.Integer bounds;
    public final TreeMap<Integer, BooleanMask2D> mask;

    private static BooleanMask2D doUnion2D(BooleanMask2D m1, BooleanMask2D m2) throws InterruptedException {
        if (m1 == null) {
            if (m2 != null) {
                return (BooleanMask2D)m2.clone();
            }
            return null;
        }
        if (m2 == null) {
            return (BooleanMask2D)m1.clone();
        }
        return BooleanMask2D.getUnion(m1, m2);
    }

    private static BooleanMask2D doIntersection2D(BooleanMask2D m1, BooleanMask2D m2) throws InterruptedException {
        if (m1 == null || m2 == null) {
            return null;
        }
        return BooleanMask2D.getIntersection(m1, m2);
    }

    private static BooleanMask2D doExclusiveUnion2D(BooleanMask2D m1, BooleanMask2D m2) throws InterruptedException {
        if (m1 == null) {
            if (m2 != null) {
                return (BooleanMask2D)m2.clone();
            }
            return null;
        }
        if (m2 == null) {
            return (BooleanMask2D)m1.clone();
        }
        return BooleanMask2D.getExclusiveUnion(m1, m2);
    }

    private static BooleanMask2D doSubtraction2D(BooleanMask2D m1, BooleanMask2D m2) throws InterruptedException {
        if (m1 == null) {
            return null;
        }
        if (m2 == null) {
            return (BooleanMask2D)m1.clone();
        }
        return BooleanMask2D.getSubtraction(m1, m2);
    }

    public static BooleanMask3D getUnion(BooleanMask3D mask1, BooleanMask3D mask2) throws InterruptedException {
        if (mask1 == null && mask2 == null) {
            return new BooleanMask3D();
        }
        if (mask1 == null || mask1.isEmpty()) {
            return (BooleanMask3D)mask2.clone();
        }
        if (mask2 == null || mask2.isEmpty()) {
            return (BooleanMask3D)mask1.clone();
        }
        Rectangle3D.Integer bounds = (Rectangle3D.Integer)mask1.bounds.createUnion(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask2D[] mask;
            if (bounds.sizeZ == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeZ != Integer.MAX_VALUE || mask2.bounds.sizeZ != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite Z dimension ROI with a finite Z dimension ROI");
                }
                mask = new BooleanMask2D[1];
                BooleanMask2D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask2D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask3D.doUnion2D(m2d1, m2d2);
            } else {
                mask = new BooleanMask2D[bounds.sizeZ];
                int z = 0;
                while (z < bounds.sizeZ) {
                    BooleanMask2D m2d1 = mask1.getMask2D(z + bounds.z);
                    BooleanMask2D m2d2 = mask2.getMask2D(z + bounds.z);
                    mask[z] = BooleanMask3D.doUnion2D(m2d1, m2d2);
                    ++z;
                }
            }
            return new BooleanMask3D(bounds, mask);
        }
        return new BooleanMask3D();
    }

    public static BooleanMask3D getIntersection(BooleanMask3D mask1, BooleanMask3D mask2) throws InterruptedException {
        if (mask1 == null || mask2 == null) {
            return new BooleanMask3D();
        }
        Rectangle3D.Integer bounds = (Rectangle3D.Integer)mask1.bounds.createIntersection(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask2D[] mask;
            if (bounds.sizeZ == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeZ != Integer.MAX_VALUE || mask2.bounds.sizeZ != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite Z dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask2D[1];
                BooleanMask2D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask2D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask3D.doIntersection2D(m2d1, m2d2);
            } else {
                mask = new BooleanMask2D[bounds.sizeZ];
                int z = 0;
                while (z < bounds.sizeZ) {
                    BooleanMask2D m2d1 = mask1.getMask2D(z + bounds.z);
                    BooleanMask2D m2d2 = mask2.getMask2D(z + bounds.z);
                    mask[z] = BooleanMask3D.doIntersection2D(m2d1, m2d2);
                    ++z;
                }
            }
            return new BooleanMask3D(bounds, mask);
        }
        return new BooleanMask3D();
    }

    public static BooleanMask3D getExclusiveUnion(BooleanMask3D mask1, BooleanMask3D mask2) throws InterruptedException {
        if (mask1 == null && mask2 == null) {
            return new BooleanMask3D();
        }
        if (mask1 == null || mask1.isEmpty()) {
            return (BooleanMask3D)mask2.clone();
        }
        if (mask2 == null || mask2.isEmpty()) {
            return (BooleanMask3D)mask1.clone();
        }
        Rectangle3D.Integer bounds = (Rectangle3D.Integer)mask1.bounds.createUnion(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask2D[] mask;
            if (bounds.sizeZ == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeZ != Integer.MAX_VALUE || mask2.bounds.sizeZ != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite Z dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask2D[1];
                BooleanMask2D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask2D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask3D.doExclusiveUnion2D(m2d1, m2d2);
            } else {
                mask = new BooleanMask2D[bounds.sizeZ];
                int z = 0;
                while (z < bounds.sizeZ) {
                    BooleanMask2D m2d1 = mask1.getMask2D(z + bounds.z);
                    BooleanMask2D m2d2 = mask2.getMask2D(z + bounds.z);
                    mask[z] = BooleanMask3D.doExclusiveUnion2D(m2d1, m2d2);
                    ++z;
                }
            }
            return new BooleanMask3D(bounds, mask);
        }
        return new BooleanMask3D();
    }

    public static BooleanMask3D getSubtraction(BooleanMask3D mask1, BooleanMask3D mask2) throws InterruptedException {
        if (mask1 == null) {
            return new BooleanMask3D();
        }
        if (mask2 == null) {
            return (BooleanMask3D)mask1.clone();
        }
        Rectangle3D.Integer bounds = (Rectangle3D.Integer)mask1.bounds.createIntersection(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask2D[] mask;
            if (bounds.sizeZ == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeZ != Integer.MAX_VALUE || mask2.bounds.sizeZ != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite Z dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask2D[1];
                BooleanMask2D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask2D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask3D.doSubtraction2D(m2d1, m2d2);
            } else {
                mask = new BooleanMask2D[bounds.sizeZ];
                int z = 0;
                while (z < bounds.sizeZ) {
                    BooleanMask2D m2d1 = mask1.getMask2D(z + bounds.z);
                    BooleanMask2D m2d2 = mask2.getMask2D(z + bounds.z);
                    mask[z] = BooleanMask3D.doSubtraction2D(m2d1, m2d2);
                    ++z;
                }
            }
            return new BooleanMask3D(bounds, mask);
        }
        return (BooleanMask3D)mask1.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanMask3D upscale(BooleanMask3D mask) throws InterruptedException {
        TreeMap<Integer, BooleanMask2D> srcMask = mask.mask;
        TreeMap<Integer, BooleanMask2D> resMask = new TreeMap<Integer, BooleanMask2D>();
        BooleanMask3D booleanMask3D = mask;
        synchronized (booleanMask3D) {
            int minZ = srcMask.firstKey();
            int maxZ = srcMask.lastKey();
            if (minZ == maxZ && mask.bounds.sizeZ == Integer.MAX_VALUE) {
                resMask.put(Integer.MIN_VALUE, srcMask.firstEntry().getValue().upscale());
            } else {
                for (Map.Entry<Integer, BooleanMask2D> entry : srcMask.entrySet()) {
                    int key = entry.getKey();
                    BooleanMask2D bm = entry.getValue().upscale();
                    resMask.put(key * 2 + 0, bm);
                    resMask.put(key * 2 + 1, (BooleanMask2D)bm.clone());
                }
            }
        }
        return new BooleanMask3D(resMask);
    }

    protected static BooleanMask2D mergeForDownscale(TreeMap<Integer, BooleanMask2D> masks, int destZ, int nbPointForTrue) throws InterruptedException {
        byte[] maskValues2;
        byte[] maskValues1;
        Rectangle bounds;
        BooleanMask2D bm1 = masks.get(destZ * 2 + 0);
        BooleanMask2D bm2 = masks.get(destZ * 2 + 1);
        if (bm1 == null) {
            if (bm2 == null) {
                return null;
            }
            bounds = new Rectangle(bm2.bounds);
        } else {
            bounds = bm2 == null ? new Rectangle(bm1.bounds) : bm1.bounds.union(bm2.bounds);
        }
        int resW = bounds.width / 2;
        int resH = bounds.height / 2;
        if (bm1 != null) {
            bm1.moveBounds(bounds);
            maskValues1 = BooleanMask2D.getDownscaleValues(bm1);
        } else {
            maskValues1 = new byte[resW * resH];
        }
        if (bm2 != null) {
            bm2.moveBounds(bounds);
            maskValues2 = BooleanMask2D.getDownscaleValues(bm2);
        } else {
            maskValues2 = new byte[resW * resH];
        }
        int validPt = Math.min(Math.max(nbPointForTrue, 1), 8);
        boolean[] resMask = new boolean[resW * resH];
        int i = 0;
        while (i < resMask.length) {
            resMask[i] = maskValues1[i] + maskValues2[i] >= validPt;
            ++i;
        }
        return new BooleanMask2D(new Rectangle(bounds.x / 2, bounds.y / 2, resW, resH), resMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanMask3D downscale(BooleanMask3D mask, int nbPointForTrue) throws InterruptedException {
        TreeMap<Integer, BooleanMask2D> srcMask = mask.mask;
        TreeMap<Integer, BooleanMask2D> resMask = new TreeMap<Integer, BooleanMask2D>();
        BooleanMask3D booleanMask3D = mask;
        synchronized (booleanMask3D) {
            int minZ = srcMask.firstKey();
            int maxZ = srcMask.lastKey();
            if (minZ == maxZ && mask.bounds.sizeZ == Integer.MAX_VALUE) {
                resMask.put(Integer.MIN_VALUE, BooleanMask3D.mergeForDownscale(srcMask, -1, nbPointForTrue));
            } else {
                int z = minZ;
                while (z < maxZ) {
                    int destZ = z / 2;
                    resMask.put(destZ, BooleanMask3D.mergeForDownscale(srcMask, destZ, nbPointForTrue));
                    z += 2;
                }
            }
        }
        return new BooleanMask3D(resMask);
    }

    public static BooleanMask3D downscale(BooleanMask3D mask) throws InterruptedException {
        return BooleanMask3D.downscale(mask, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanMask3D upscale2D(BooleanMask3D mask) throws InterruptedException {
        TreeMap<Integer, BooleanMask2D> srcMask = mask.mask;
        TreeMap<Integer, BooleanMask2D> resMask = new TreeMap<Integer, BooleanMask2D>();
        BooleanMask3D booleanMask3D = mask;
        synchronized (booleanMask3D) {
            int minZ = srcMask.firstKey();
            int maxZ = srcMask.lastKey();
            if (minZ == maxZ && mask.bounds.sizeZ == Integer.MAX_VALUE) {
                resMask.put(Integer.MIN_VALUE, srcMask.firstEntry().getValue().upscale());
            } else {
                for (Map.Entry<Integer, BooleanMask2D> entry : srcMask.entrySet()) {
                    resMask.put(entry.getKey(), entry.getValue().upscale());
                }
            }
        }
        return new BooleanMask3D(resMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanMask3D downscale2D(BooleanMask3D mask, int nbPointForTrue) throws InterruptedException {
        TreeMap<Integer, BooleanMask2D> srcMask = mask.mask;
        TreeMap<Integer, BooleanMask2D> resMask = new TreeMap<Integer, BooleanMask2D>();
        BooleanMask3D booleanMask3D = mask;
        synchronized (booleanMask3D) {
            int minZ = srcMask.firstKey();
            int maxZ = srcMask.lastKey();
            if (minZ == maxZ && mask.bounds.sizeZ == Integer.MAX_VALUE) {
                resMask.put(Integer.MIN_VALUE, srcMask.firstEntry().getValue().downscale(nbPointForTrue));
            } else {
                for (Map.Entry<Integer, BooleanMask2D> entry : srcMask.entrySet()) {
                    resMask.put(entry.getKey(), entry.getValue().downscale(nbPointForTrue));
                }
            }
        }
        return new BooleanMask3D(resMask);
    }

    public static BooleanMask3D downscale2D(BooleanMask3D mask) throws InterruptedException {
        return BooleanMask3D.downscale2D(mask, 2);
    }

    public BooleanMask3D(Rectangle3D.Integer bounds, TreeMap<Integer, BooleanMask2D> mask) {
        this.mask = mask;
        this.bounds = bounds;
    }

    public BooleanMask3D(TreeMap<Integer, BooleanMask2D> mask) {
        this(new Rectangle3D.Integer(), mask);
        this.bounds = this.getOptimizedBounds(false);
    }

    public BooleanMask3D(Rectangle3D.Integer bounds, BooleanMask2D[] mask) {
        this.bounds = bounds;
        this.mask = new TreeMap();
        if (bounds.sizeZ == Integer.MAX_VALUE) {
            this.mask.put(Integer.MIN_VALUE, mask[0]);
        } else {
            int z = 0;
            while (z < bounds.sizeZ) {
                if (mask[z] != null) {
                    this.mask.put(bounds.z + z, mask[z]);
                }
                ++z;
            }
        }
    }

    public BooleanMask3D(Point3D.Integer[] points) {
        this.mask = new TreeMap();
        if (points == null || points.length == 0) {
            this.bounds = new Rectangle3D.Integer();
        } else {
            Point3D.Integer pt;
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            Point3D.Integer[] integerArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                pt = integerArray[n2];
                int x = pt.x;
                int y = pt.y;
                int z = pt.z;
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (z < minZ) {
                    minZ = z;
                }
                if (z > maxZ) {
                    maxZ = z;
                }
                ++n2;
            }
            this.bounds = new Rectangle3D.Integer(minX, minY, minZ, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
            integerArray = points;
            n = points.length;
            n2 = 0;
            while (n2 < n) {
                pt = integerArray[n2];
                BooleanMask2D m = this.mask.get(pt.z);
                if (m == null) {
                    m = new BooleanMask2D(new Rectangle(minX, minY, this.bounds.sizeX, this.bounds.sizeY), new boolean[this.bounds.sizeX * this.bounds.sizeY]);
                    this.mask.put(pt.z, m);
                }
                m.mask[(pt.y - minY) * this.bounds.sizeX + (pt.x - minX)] = true;
                ++n2;
            }
            for (BooleanMask2D m : this.mask.values()) {
                m.optimizeBounds();
            }
        }
    }

    public BooleanMask3D(Point3D[] points) {
        this.mask = new TreeMap();
        if (points == null || points.length == 0) {
            this.bounds = new Rectangle3D.Integer();
        } else {
            Point3D pt;
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            Point3D[] point3DArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                pt = point3DArray[n2];
                int x = (int)pt.getX();
                int y = (int)pt.getY();
                int z = (int)pt.getZ();
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (z < minZ) {
                    minZ = z;
                }
                if (z > maxZ) {
                    maxZ = z;
                }
                ++n2;
            }
            this.bounds = new Rectangle3D.Integer(minX, minY, minZ, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
            point3DArray = points;
            n = points.length;
            n2 = 0;
            while (n2 < n) {
                pt = point3DArray[n2];
                BooleanMask2D m = this.mask.get((int)pt.getZ());
                if (m == null) {
                    m = new BooleanMask2D(new Rectangle(minX, minY, this.bounds.sizeX, this.bounds.sizeY), new boolean[this.bounds.sizeX * this.bounds.sizeY]);
                    this.mask.put((int)pt.getZ(), m);
                }
                m.mask[((int)pt.getY() - minY) * this.bounds.sizeX + ((int)pt.getX() - minX)] = true;
                ++n2;
            }
            for (BooleanMask2D m : this.mask.values()) {
                m.optimizeBounds();
            }
        }
    }

    public BooleanMask3D() {
        this(new Rectangle3D.Integer(), new BooleanMask2D[0]);
    }

    public BooleanMask2D getMask2D(int z) {
        if (this.bounds.sizeZ == Integer.MAX_VALUE) {
            return this.mask.firstEntry().getValue();
        }
        return this.mask.get(z);
    }

    public boolean isEmpty() {
        return this.bounds.isEmpty();
    }

    public boolean contains(int x, int y, int z) {
        BooleanMask2D m2d;
        if (this.bounds.contains(x, y, z) && (m2d = this.getMask2D(z)) != null) {
            return m2d.contains(x, y);
        }
        return false;
    }

    public boolean contains(BooleanMask2D booleanMask, int z) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask2D mask2d = this.getMask2D(z);
        if (mask2d != null) {
            return mask2d.contains(booleanMask);
        }
        return false;
    }

    public boolean contains(BooleanMask3D booleanMask) {
        int offZ;
        if (this.isEmpty()) {
            return false;
        }
        int sizeZ = booleanMask.bounds.sizeZ;
        if (sizeZ == Integer.MAX_VALUE) {
            if (this.bounds.sizeZ != Integer.MAX_VALUE) {
                return false;
            }
            return booleanMask.mask.firstEntry().getValue().contains(this.mask.firstEntry().getValue());
        }
        if (this.bounds.sizeZ != Integer.MAX_VALUE && !this.bounds.contains(booleanMask.bounds)) {
            return false;
        }
        int z = offZ = booleanMask.bounds.z;
        while (z < offZ + sizeZ) {
            if (!this.contains(booleanMask.getMask2D(z), z)) {
                return false;
            }
            ++z;
        }
        return true;
    }

    public boolean intersects(BooleanMask2D booleanMask, int z) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask2D mask2d = this.getMask2D(z);
        if (mask2d != null) {
            return mask2d.intersects(booleanMask);
        }
        return false;
    }

    public boolean intersects(BooleanMask3D booleanMask) {
        int offZ;
        if (this.isEmpty()) {
            return false;
        }
        int sizeZ = booleanMask.bounds.sizeZ;
        if (sizeZ == Integer.MAX_VALUE) {
            BooleanMask2D mask2d = booleanMask.mask.firstEntry().getValue();
            for (BooleanMask2D m : this.mask.values()) {
                if (!m.intersects(mask2d)) continue;
                return true;
            }
            return false;
        }
        if (this.bounds.sizeZ == Integer.MAX_VALUE) {
            BooleanMask2D mask2d = this.mask.firstEntry().getValue();
            for (BooleanMask2D m : booleanMask.mask.values()) {
                if (!m.intersects(mask2d)) continue;
                return true;
            }
            return false;
        }
        if (!this.bounds.intersects(booleanMask.bounds)) {
            return false;
        }
        int z = offZ = booleanMask.bounds.z;
        while (z < offZ + sizeZ) {
            if (this.intersects(booleanMask.getMask2D(z), z)) {
                return true;
            }
            ++z;
        }
        return false;
    }

    public Rectangle3D.Integer getOptimizedBounds(boolean compute2DBounds) {
        Rectangle3D.Integer result = new Rectangle3D.Integer();
        if (this.mask.isEmpty()) {
            return result;
        }
        Rectangle bounds2D = null;
        for (BooleanMask2D m2d : this.mask.values()) {
            Rectangle optB2d = compute2DBounds ? m2d.getOptimizedBounds() : new Rectangle(m2d.bounds);
            if (optB2d.isEmpty()) continue;
            if (bounds2D == null) {
                bounds2D = optB2d;
                continue;
            }
            bounds2D.add(optB2d);
        }
        if (bounds2D == null || bounds2D.isEmpty()) {
            return result;
        }
        int minZ = this.mask.firstKey();
        int maxZ = this.mask.lastKey();
        result.setX(bounds2D.x);
        result.setY(bounds2D.y);
        result.setSizeX(bounds2D.width);
        result.setSizeY(bounds2D.height);
        if (minZ == maxZ && (minZ == Integer.MIN_VALUE || this.bounds.sizeZ == Integer.MAX_VALUE)) {
            result.setZ(-2.147483648E9);
            result.setSizeZ(2.147483647E9);
        } else {
            result.setZ(minZ);
            result.setSizeZ(maxZ - minZ + 1);
        }
        return result;
    }

    public Rectangle3D.Integer getOptimizedBounds() {
        return this.getOptimizedBounds(true);
    }

    public void optimizeBounds() {
        for (BooleanMask2D m : this.mask.values()) {
            m.optimizeBounds();
        }
        this.moveBounds(this.getOptimizedBounds(false));
    }

    public void moveBounds(Rectangle3D.Integer value) {
        if (!this.bounds.equals(value)) {
            if (value.isEmpty()) {
                this.bounds = new Rectangle3D.Integer();
                this.mask.clear();
                return;
            }
            Rectangle bounds2D = new Rectangle(value.x, value.y, value.sizeX, value.sizeY);
            if (this.bounds.sizeZ == Integer.MAX_VALUE) {
                BooleanMask2D m2d = this.mask.firstEntry().getValue();
                m2d.moveBounds(bounds2D);
                if (value.sizeZ != Integer.MAX_VALUE) {
                    this.mask.clear();
                    int z = 0;
                    while (z <= value.sizeZ) {
                        this.mask.put(z + value.z, (BooleanMask2D)m2d.clone());
                        ++z;
                    }
                }
            } else if (value.sizeZ == Integer.MAX_VALUE) {
                BooleanMask2D mask2D = this.getMask2D(value.z);
                if (mask2D == null && !this.mask.isEmpty()) {
                    mask2D = this.mask.firstEntry().getValue();
                }
                this.mask.clear();
                if (mask2D != null) {
                    this.mask.put(Integer.MIN_VALUE, mask2D);
                }
            } else {
                BooleanMask2D[] newMask = new BooleanMask2D[value.sizeZ];
                int z = 0;
                while (z < value.sizeZ) {
                    BooleanMask2D mask2D = this.getMask2D(value.z + z);
                    if (mask2D != null) {
                        mask2D.moveBounds(bounds2D);
                    }
                    newMask[z] = mask2D;
                    ++z;
                }
                this.mask.clear();
                z = 0;
                while (z < value.sizeZ) {
                    this.mask.put(value.z + z, newMask[z]);
                    ++z;
                }
            }
            this.bounds = value;
        }
    }

    public BooleanMask3D upscale() throws InterruptedException {
        return BooleanMask3D.upscale(this);
    }

    public BooleanMask3D downscale(int nbPointForTrue) throws InterruptedException {
        return BooleanMask3D.downscale(this, nbPointForTrue);
    }

    public BooleanMask3D downscale() throws InterruptedException {
        return BooleanMask3D.downscale(this);
    }

    public BooleanMask3D upscale2D() throws InterruptedException {
        return BooleanMask3D.upscale2D(this);
    }

    public BooleanMask3D downscale2D(int nbPointForTrue) throws InterruptedException {
        return BooleanMask3D.downscale2D(this, nbPointForTrue);
    }

    public BooleanMask3D downscale2D() throws InterruptedException {
        return BooleanMask3D.downscale2D(this);
    }

    public static int[] toInt3D(int[] source2D, int z) {
        int[] result = new int[source2D.length * 3 / 2];
        int pt = 0;
        int i = 0;
        while (i < source2D.length) {
            result[pt++] = source2D[i + 0];
            result[pt++] = source2D[i + 1];
            result[pt++] = z;
            i += 2;
        }
        return result;
    }

    public int getNumberOfPoints() throws InterruptedException {
        int result = 0;
        for (BooleanMask2D mask2d : this.mask.values()) {
            if (Thread.interrupted()) {
                throw new InterruptedException("BooleanMask.getNumberOfPoints() computation interrupted !");
            }
            result += mask2d.getNumberOfPoints();
        }
        return result;
    }

    public Point3D.Integer[] getPoints() throws InterruptedException {
        return Point3D.Integer.toPoint3D(this.getPointsAsIntArray());
    }

    public int[] getPointsAsIntArray() throws InterruptedException {
        DynamicArray.Int result = new DynamicArray.Int(8);
        for (Map.Entry<Integer, BooleanMask2D> entry : this.mask.entrySet()) {
            if (Thread.interrupted()) {
                throw new InterruptedException("BooleanMask.getPointsAsIntArray() computation interrupted !");
            }
            result.add(BooleanMask3D.toInt3D(entry.getValue().getPointsAsIntArray(), entry.getKey()));
        }
        return result.asArray();
    }

    public Point3D.Integer[] getContourPoints() throws InterruptedException {
        return Point3D.Integer.toPoint3D(this.getContourPointsAsIntArray());
    }

    public int[] getContourPointsAsIntArray() throws InterruptedException {
        DynamicArray.Int result = new DynamicArray.Int(8);
        if (this.mask.size() <= 2) {
            for (Map.Entry<Integer, BooleanMask2D> entry : this.mask.entrySet()) {
                result.add(BooleanMask3D.toInt3D(entry.getValue().getPointsAsIntArray(), entry.getKey()));
            }
        } else {
            Map.Entry<Integer, BooleanMask2D> firstEntry = this.mask.firstEntry();
            Map.Entry<Integer, BooleanMask2D> lastEntry = this.mask.lastEntry();
            Integer firstKey = firstEntry.getKey();
            Integer lastKey = lastEntry.getKey();
            result.add(BooleanMask3D.toInt3D(firstEntry.getValue().getPointsAsIntArray(), firstKey));
            for (Map.Entry entry : this.mask.subMap(firstKey, false, lastKey, false).entrySet()) {
                result.add(BooleanMask3D.toInt3D(((BooleanMask2D)entry.getValue()).getContourPointsAsIntArray(), (Integer)entry.getKey()));
            }
            result.add(BooleanMask3D.toInt3D(lastEntry.getValue().getPointsAsIntArray(), lastKey));
        }
        return result.asArray();
    }

    public double getContourLength() throws InterruptedException {
        double result = 0.0;
        int[] edge = this.getContourPointsAsIntArray();
        double sideEdges = 0.0;
        double cornerEdges = 0.0;
        int i = 0;
        while (i < edge.length) {
            int x = edge[i + 0];
            int y = edge[i + 1];
            int z = edge[i + 2];
            BooleanMask2D mask2D = this.getMask2D(z);
            boolean leftConnected = mask2D.contains(x - 1, y);
            boolean rightConnected = mask2D.contains(x + 1, y);
            boolean topConnected = mask2D.contains(x, y - 1);
            boolean bottomConnected = mask2D.contains(x + 1, y + 1);
            mask2D = this.getMask2D(z - 1);
            boolean southConnected = mask2D != null && mask2D.contains(x, y);
            mask2D = this.getMask2D(z + 1);
            boolean northConnected = mask2D != null && mask2D.contains(x, y);
            int connection = 0;
            if (leftConnected) {
                ++connection;
            }
            if (rightConnected) {
                ++connection;
            }
            if (topConnected) {
                ++connection;
            }
            if (bottomConnected) {
                ++connection;
            }
            if (southConnected) {
                ++connection;
            }
            if (northConnected) {
                ++connection;
            }
            switch (connection) {
                default: {
                    cornerEdges += 1.0;
                    result += Math.sqrt(3.0);
                    break;
                }
                case 4: {
                    if (leftConnected && rightConnected && topConnected && bottomConnected) {
                        sideEdges += 2.0;
                        result += 2.0;
                        break;
                    }
                    if (leftConnected && rightConnected && northConnected && southConnected) {
                        sideEdges += 2.0;
                        result += 2.0;
                        break;
                    }
                    if (topConnected && bottomConnected && northConnected && southConnected) {
                        sideEdges += 2.0;
                        result += 2.0;
                        break;
                    }
                    cornerEdges += 1.0;
                    result += Math.sqrt(2.0);
                    break;
                }
                case 5: {
                    sideEdges += 1.0;
                    result += 1.0;
                }
                case 6: 
            }
            i += 3;
        }
        double overShoot = Math.min(sideEdges / 10.0, cornerEdges);
        return result - overShoot;
    }

    public Object clone() {
        BooleanMask3D result = new BooleanMask3D();
        result.bounds = new Rectangle3D.Integer(this.bounds);
        for (Map.Entry<Integer, BooleanMask2D> entry : this.mask.entrySet()) {
            result.mask.put(entry.getKey(), (BooleanMask2D)entry.getValue().clone());
        }
        return result;
    }

    public List<BooleanMask3D> getComponents() throws InterruptedException {
        int width = this.bounds.sizeX;
        int height = this.bounds.sizeY;
        int slice = width * height;
        int depth = this.bounds.sizeZ;
        HashMap<Integer, ConnectedComponent> ccs = new HashMap<Integer, ConnectedComponent>();
        HashMap<Integer, ROI3DArea> roiMap = new HashMap<Integer, ROI3DArea>();
        int[] neighborLabels = new int[13];
        int nbNeighbors = 0;
        Sequence labelSequence = new Sequence();
        boolean virtual = false;
        int[] _labelsAbove = null;
        int highestKnownLabel = 0;
        int z = 0;
        while (z < depth) {
            int[] _labelsHere;
            try {
                _labelsHere = new int[slice];
            }
            catch (OutOfMemoryError error) {
                if (!virtual) {
                    labelSequence.setVolatile(true);
                    virtual = true;
                    _labelsHere = new int[slice];
                }
                throw error;
            }
            BooleanMask2D inputData = this.getMask2D(z);
            int y = 0;
            int maskY = this.bounds.y;
            int inOffset = 0;
            while (y < height) {
                if (Thread.currentThread().isInterrupted()) {
                    return new ArrayList<BooleanMask3D>();
                }
                int x = 0;
                int maskX = this.bounds.x;
                while (x < width) {
                    boolean currentImageValue = inputData.contains(maskX, maskY);
                    if (currentImageValue) {
                        int north;
                        if (z == 0) {
                            if (y == 0) {
                                if (x != 0) {
                                    neighborLabels[0] = _labelsHere[inOffset - 1];
                                    nbNeighbors = 1;
                                }
                            } else {
                                north = inOffset - width;
                                if (x == 0) {
                                    neighborLabels[0] = _labelsHere[north];
                                    neighborLabels[1] = _labelsHere[north + 1];
                                    nbNeighbors = 2;
                                } else if (x == width - 1) {
                                    neighborLabels[0] = _labelsHere[north - 1];
                                    neighborLabels[1] = _labelsHere[north];
                                    neighborLabels[2] = _labelsHere[inOffset - 1];
                                    nbNeighbors = 3;
                                } else {
                                    neighborLabels[0] = _labelsHere[north - 1];
                                    neighborLabels[1] = _labelsHere[north];
                                    neighborLabels[2] = _labelsHere[north + 1];
                                    neighborLabels[3] = _labelsHere[inOffset - 1];
                                    nbNeighbors = 4;
                                }
                            }
                        } else if (y == 0) {
                            int south = inOffset + width;
                            if (x == 0) {
                                neighborLabels[0] = _labelsAbove[inOffset];
                                neighborLabels[1] = _labelsAbove[inOffset + 1];
                                neighborLabels[2] = _labelsAbove[south];
                                neighborLabels[3] = _labelsAbove[south + 1];
                                nbNeighbors = 4;
                            } else if (x == width - 1) {
                                neighborLabels[0] = _labelsAbove[inOffset - 1];
                                neighborLabels[1] = _labelsAbove[inOffset];
                                neighborLabels[2] = _labelsAbove[south - 1];
                                neighborLabels[3] = _labelsAbove[south];
                                neighborLabels[4] = _labelsHere[inOffset - 1];
                                nbNeighbors = 5;
                            } else {
                                neighborLabels[0] = _labelsAbove[inOffset - 1];
                                neighborLabels[1] = _labelsAbove[inOffset];
                                neighborLabels[2] = _labelsAbove[inOffset + 1];
                                neighborLabels[3] = _labelsAbove[south - 1];
                                neighborLabels[4] = _labelsAbove[south];
                                neighborLabels[5] = _labelsAbove[south + 1];
                                neighborLabels[6] = _labelsHere[inOffset - 1];
                                nbNeighbors = 7;
                            }
                        } else if (y == height - 1) {
                            north = inOffset - width;
                            if (x == 0) {
                                neighborLabels[0] = _labelsAbove[north];
                                neighborLabels[1] = _labelsAbove[north + 1];
                                neighborLabels[2] = _labelsAbove[inOffset];
                                neighborLabels[3] = _labelsAbove[inOffset + 1];
                                neighborLabels[4] = _labelsHere[north];
                                neighborLabels[5] = _labelsHere[north + 1];
                                nbNeighbors = 6;
                            } else if (x == width - 1) {
                                neighborLabels[0] = _labelsAbove[north - 1];
                                neighborLabels[1] = _labelsAbove[north];
                                neighborLabels[2] = _labelsAbove[inOffset - 1];
                                neighborLabels[3] = _labelsAbove[inOffset];
                                neighborLabels[4] = _labelsHere[north - 1];
                                neighborLabels[5] = _labelsHere[north];
                                neighborLabels[6] = _labelsHere[inOffset - 1];
                                nbNeighbors = 7;
                            } else {
                                neighborLabels[0] = _labelsAbove[north - 1];
                                neighborLabels[1] = _labelsAbove[north];
                                neighborLabels[2] = _labelsAbove[north + 1];
                                neighborLabels[3] = _labelsAbove[inOffset - 1];
                                neighborLabels[4] = _labelsAbove[inOffset];
                                neighborLabels[5] = _labelsAbove[inOffset + 1];
                                neighborLabels[6] = _labelsHere[north - 1];
                                neighborLabels[7] = _labelsHere[north];
                                neighborLabels[8] = _labelsHere[north + 1];
                                neighborLabels[9] = _labelsHere[inOffset - 1];
                                nbNeighbors = 10;
                            }
                        } else {
                            int west;
                            int northwest;
                            north = inOffset - width;
                            int south = inOffset + width;
                            if (x == 0) {
                                neighborLabels[0] = _labelsAbove[north];
                                neighborLabels[1] = _labelsAbove[north + 1];
                                neighborLabels[2] = _labelsAbove[inOffset];
                                neighborLabels[3] = _labelsAbove[inOffset + 1];
                                neighborLabels[4] = _labelsAbove[south];
                                neighborLabels[5] = _labelsAbove[south + 1];
                                neighborLabels[6] = _labelsHere[north];
                                neighborLabels[7] = _labelsHere[north + 1];
                                nbNeighbors = 8;
                            } else if (x == width - 1) {
                                northwest = north - 1;
                                west = inOffset - 1;
                                neighborLabels[0] = _labelsAbove[northwest];
                                neighborLabels[1] = _labelsAbove[north];
                                neighborLabels[2] = _labelsAbove[west];
                                neighborLabels[3] = _labelsAbove[inOffset];
                                neighborLabels[4] = _labelsAbove[south - 1];
                                neighborLabels[5] = _labelsAbove[south];
                                neighborLabels[6] = _labelsHere[northwest];
                                neighborLabels[7] = _labelsHere[north];
                                neighborLabels[8] = _labelsHere[west];
                                nbNeighbors = 9;
                            } else {
                                northwest = north - 1;
                                west = inOffset - 1;
                                int northeast = north + 1;
                                int southwest = south - 1;
                                int southeast = south + 1;
                                neighborLabels[0] = _labelsAbove[northwest];
                                neighborLabels[1] = _labelsAbove[north];
                                neighborLabels[2] = _labelsAbove[northeast];
                                neighborLabels[3] = _labelsAbove[west];
                                neighborLabels[4] = _labelsAbove[inOffset];
                                neighborLabels[5] = _labelsAbove[inOffset + 1];
                                neighborLabels[6] = _labelsAbove[southwest];
                                neighborLabels[7] = _labelsAbove[south];
                                neighborLabels[8] = _labelsAbove[southeast];
                                neighborLabels[9] = _labelsHere[northwest];
                                neighborLabels[10] = _labelsHere[north];
                                neighborLabels[11] = _labelsHere[northeast];
                                neighborLabels[12] = _labelsHere[west];
                                nbNeighbors = 13;
                            }
                        }
                        int currentLabel = Integer.MAX_VALUE;
                        int i = 0;
                        while (i < nbNeighbors) {
                            int neighborLabel = neighborLabels[i];
                            if (neighborLabel != 0 && currentImageValue && neighborLabel < currentLabel) {
                                currentLabel = neighborLabel;
                            }
                            ++i;
                        }
                        if (currentLabel == Integer.MAX_VALUE) {
                            currentLabel = ++highestKnownLabel;
                            ccs.put(currentLabel, new ConnectedComponent(currentLabel));
                        } else {
                            ConnectedComponent currentCC = (ConnectedComponent)ccs.get(currentLabel);
                            int currentTargetLabel = currentCC.getTargetLabel();
                            int i2 = 0;
                            while (i2 < nbNeighbors) {
                                ConnectedComponent neighborCC;
                                int neighborTargetLabel;
                                int neighborLabel = neighborLabels[i2];
                                if (neighborLabel != 0 && (neighborTargetLabel = (neighborCC = (ConnectedComponent)ccs.get(neighborLabel)).getTargetLabel()) != currentTargetLabel && currentImageValue) {
                                    if (neighborTargetLabel > currentTargetLabel) {
                                        ((ConnectedComponent)ccs.get((Object)Integer.valueOf((int)neighborTargetLabel))).targetComponent = (ConnectedComponent)ccs.get(currentTargetLabel);
                                    } else {
                                        ((ConnectedComponent)ccs.get((Object)Integer.valueOf((int)currentTargetLabel))).targetComponent = (ConnectedComponent)ccs.get(neighborTargetLabel);
                                    }
                                }
                                ++i2;
                            }
                        }
                        if (currentLabel != 0) {
                            _labelsHere[inOffset] = currentLabel;
                        }
                    }
                    ++x;
                    ++maskX;
                    ++inOffset;
                }
                ++y;
                ++maskY;
            }
            IcyBufferedImage img = new IcyBufferedImage(width, height, (Object)_labelsHere);
            if (virtual) {
                img.setVolatile(true);
            }
            labelSequence.setImage(0, z, (BufferedImage)img);
            _labelsAbove = _labelsHere;
            ++z;
        }
        if (Thread.currentThread().isInterrupted()) {
            return new ArrayList<BooleanMask3D>();
        }
        int finalLabel = 0;
        int currentLabel = highestKnownLabel;
        while (currentLabel > 0) {
            ConnectedComponent currentCC = (ConnectedComponent)ccs.get(currentLabel);
            if (currentCC.targetLabel >= currentLabel) {
                currentCC.targetLabel = ++finalLabel;
            } else {
                currentCC.targetComponent = (ConnectedComponent)ccs.get(currentCC.targetLabel);
            }
            --currentLabel;
        }
        int z2 = 0;
        int zMask = 0;
        block8: while (z2 < depth) {
            int[] _labelsHere = (int[])labelSequence.getDataXY(0, z2, 0);
            int j = 0;
            int jMask = this.bounds.y;
            int offset = 0;
            while (j < height) {
                if (Thread.currentThread().isInterrupted()) break block8;
                int i = 0;
                int iMask = this.bounds.x;
                while (i < width) {
                    int targetLabel = _labelsHere[offset];
                    if (targetLabel != 0) {
                        if (!roiMap.containsKey(targetLabel = ((ConnectedComponent)ccs.get(targetLabel)).getTargetLabel())) {
                            ROI3DArea roi3D = new ROI3DArea();
                            roi3D.setName("" + targetLabel);
                            roiMap.put(targetLabel, roi3D);
                        }
                        ((ROI3DArea)roiMap.get(targetLabel)).addPoint(iMask, jMask, zMask);
                    }
                    ++i;
                    ++iMask;
                    ++offset;
                }
                ++j;
                ++jMask;
            }
            ++z2;
            ++zMask;
        }
        ArrayList<BooleanMask3D> result = new ArrayList<BooleanMask3D>();
        for (ROI3DArea roi : roiMap.values()) {
            result.add(roi.getBooleanMask(true));
        }
        return result;
    }

    private static class ConnectedComponent {
        int targetLabel;
        ConnectedComponent targetComponent;

        ConnectedComponent(int label) {
            this.targetLabel = label;
        }

        int getTargetLabel() {
            return this.targetComponent == null ? this.targetLabel : this.targetComponent.getTargetLabel();
        }
    }
}

