/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.sequence.Sequence;
import icy.sequence.VolumetricImageCursor;
import java.util.concurrent.atomic.AtomicBoolean;

public class SequenceCursor {
    private Sequence seq;
    private VolumetricImageCursor[] volumeCursors;
    private AtomicBoolean sequenceChanged;
    private int currentT;
    private VolumetricImageCursor currentCursor;

    public SequenceCursor(Sequence seq) {
        this.seq = seq;
        this.volumeCursors = new VolumetricImageCursor[seq.getSizeT()];
        this.sequenceChanged = new AtomicBoolean();
        this.currentT = -1;
    }

    public double get(int x, int y, int z, int t, int c) throws IndexOutOfBoundsException, RuntimeException {
        return this.getVolumeCursor(t).get(x, y, z, c);
    }

    public synchronized void set(int x, int y, int z, int t, int c, double val) throws IndexOutOfBoundsException, RuntimeException {
        this.getVolumeCursor(t).set(x, y, z, c, val);
        this.sequenceChanged.set(true);
    }

    public synchronized void setSafe(int x, int y, int z, int t, int c, double val) throws IndexOutOfBoundsException, RuntimeException {
        this.getVolumeCursor(t).setSafe(x, y, z, c, val);
        this.sequenceChanged.set(true);
    }

    private synchronized VolumetricImageCursor getVolumeCursor(int t) throws IndexOutOfBoundsException {
        if (this.currentT != t) {
            if (this.volumeCursors[t] == null) {
                this.volumeCursors[t] = new VolumetricImageCursor(this.seq, t);
            }
            this.currentCursor = this.volumeCursors[t];
            this.currentT = t;
        }
        return this.currentCursor;
    }

    public synchronized void commitChanges() {
        if (this.sequenceChanged.get()) {
            int i = 0;
            while (i < this.volumeCursors.length) {
                if (this.volumeCursors[i] != null) {
                    this.volumeCursors[i].commitChanges();
                }
                ++i;
            }
            this.sequenceChanged.set(false);
        }
    }

    public String toString() {
        return "last T=" + this.currentT + " " + this.currentCursor != null ? this.currentCursor.toString() : "";
    }
}

