/*
 * Decompiled with CFR 0.152.
 */
package icy.type.collection.array;

import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.Array2DUtil;

public class Array3DUtil {
    public static int getTotalLength(byte[][][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array2DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static int getTotalLength(short[][][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array2DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static int getTotalLength(int[][][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array2DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static int getTotalLength(long[][][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array2DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static int getTotalLength(float[][][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array2DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static int getTotalLength(double[][][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array2DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static Object[][] createArray(DataType dataType, int len) {
        switch (dataType.getJavaType()) {
            case BYTE: {
                return new byte[len][][];
            }
            case SHORT: {
                return new short[len][][];
            }
            case INT: {
                return new int[len][][];
            }
            case LONG: {
                return new int[len][][];
            }
            case FLOAT: {
                return new float[len][][];
            }
            case DOUBLE: {
                return new double[len][][];
            }
        }
        return null;
    }

    @Deprecated
    public static Object[][] createArray(int dataType, int len) {
        return Array3DUtil.createArray(DataType.getDataType(dataType), len);
    }

    public static byte[] toByteArray1D(byte[][][] in) {
        return Array3DUtil.toByteArray1D(in, null, 0);
    }

    public static short[] toShortArray1D(short[][][] in) {
        return Array3DUtil.toShortArray1D(in, null, 0);
    }

    public static int[] toIntArray1D(int[][][] in) {
        return Array3DUtil.toIntArray1D(in, null, 0);
    }

    public static float[] toFloatArray1D(float[][][] in) {
        return Array3DUtil.toFloatArray1D(in, null, 0);
    }

    public static double[] toDoubleArray1D(double[][][] in) {
        return Array3DUtil.toDoubleArray1D(in, null, 0);
    }

    public static byte[] toByteArray1D(byte[][][] in, byte[] out, int offset) {
        byte[] result = Array1DUtil.allocIfNull(out, offset + Array3DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                byte[][] s_in = in[i];
                if (s_in != null) {
                    Array2DUtil.toByteArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static short[] toShortArray1D(short[][][] in, short[] out, int offset) {
        short[] result = Array1DUtil.allocIfNull(out, offset + Array3DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                short[][] s_in = in[i];
                if (s_in != null) {
                    Array2DUtil.toShortArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static int[] toIntArray1D(int[][][] in, int[] out, int offset) {
        int[] result = Array1DUtil.allocIfNull(out, offset + Array3DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                int[][] s_in = in[i];
                if (s_in != null) {
                    Array2DUtil.toIntArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static long[] toLongArray1D(long[][][] in, long[] out, int offset) {
        long[] result = Array1DUtil.allocIfNull(out, offset + Array3DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                long[][] s_in = in[i];
                if (s_in != null) {
                    Array2DUtil.toLongArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static float[] toFloatArray1D(float[][][] in, float[] out, int offset) {
        float[] result = Array1DUtil.allocIfNull(out, offset + Array3DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                float[][] s_in = in[i];
                if (s_in != null) {
                    Array2DUtil.toFloatArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static double[] toDoubleArray1D(double[][][] in, double[] out, int offset) {
        double[] result = Array1DUtil.allocIfNull(out, offset + Array3DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                double[][] s_in = in[i];
                if (s_in != null) {
                    Array2DUtil.toDoubleArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }
}

