/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GeomUtil {
    public static Point2D getIntersection(Line2D lineA, Line2D lineB) {
        double x1 = lineA.getX1();
        double y1 = lineA.getY1();
        double x2 = lineA.getX2();
        double y2 = lineA.getY2();
        double x3 = lineB.getX1();
        double y3 = lineB.getY1();
        double x4 = lineB.getX2();
        double y4 = lineB.getY2();
        double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d != 0.0) {
            double xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
            double yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;
            return new Point2D.Double(xi, yi);
        }
        return null;
    }

    public static Point2D getIntersection(Line2D lineA, Line2D lineB, boolean limitToSegmentA, boolean limitToSegmentB) {
        Point2D result = GeomUtil.getIntersection(lineA, lineB);
        if (result == null) {
            return null;
        }
        Rectangle2D.Double rectPt = new Rectangle2D.Double(result.getX() - 0.5, result.getY() - 0.5, 1.0, 1.0);
        if (limitToSegmentA && !lineA.intersects(rectPt)) {
            return null;
        }
        if (limitToSegmentB && !lineB.intersects(rectPt)) {
            return null;
        }
        return result;
    }

    public static double getRotation(AffineTransform transform) {
        double m00 = transform.getScaleX();
        double m01 = transform.getShearX();
        double m10 = transform.getShearY();
        double m11 = transform.getScaleY();
        int ii = 0;
        while (ii < 10) {
            double o00 = m00;
            double o11 = m11;
            double o10 = m10;
            double o01 = m01;
            double det = o00 * o11 - o10 * o01;
            if (Math.abs(det) == 0.0) {
                return GeomUtil.getRotationFast(transform);
            }
            double hrdet = 0.5 / det;
            m00 = o11 * hrdet + o00 * 0.5;
            double d00 = m00 - o00;
            m10 = -o01 * hrdet + o10 * 0.5;
            double d10 = m10 - o10;
            m01 = -o10 * hrdet + o01 * 0.5;
            double d01 = m01 - o01;
            m11 = o00 * hrdet + o11 * 0.5;
            double d11 = m11 - o11;
            if (d00 * d00 + d10 * d10 + d01 * d01 + d11 * d11 < 1.0E-4) break;
            ++ii;
        }
        return Math.atan2(m01, m00);
    }

    public static double getRotationFast(AffineTransform transform) {
        double a = transform.getScaleX();
        double b = transform.getShearX();
        if (Math.abs(a) >= 0.001 && Math.abs(b) >= 0.001) {
            return Math.atan(-b / a);
        }
        double c = transform.getShearY();
        double d = transform.getScaleY();
        if (Math.abs(c) >= 0.001 && Math.abs(d) >= 0.001) {
            return Math.atan(c / d);
        }
        Point2D pp0 = transform.transform(new Point(0, 0), null);
        Point2D pp1 = transform.transform(new Point(1, 0), null);
        double dx = pp1.getX() - pp0.getX();
        double dy = pp1.getY() - pp0.getY();
        return Math.atan2(dy, dx);
    }

    public static double getScale(AffineTransform transform) {
        double a = transform.getScaleX();
        double b = transform.getShearX();
        double c = transform.getShearY();
        double d = transform.getScaleY();
        double cp = a * d - b * c;
        return cp < 0.0 ? -Math.sqrt(-cp) : Math.sqrt(cp);
    }

    public static double getScaleX(AffineTransform transform) {
        double a = transform.getScaleX();
        double c = transform.getShearY();
        return Math.sqrt(a * a + c * c);
    }

    public static double getScaleY(AffineTransform transform) {
        double b = transform.getShearX();
        double d = transform.getScaleY();
        return Math.sqrt(b * b + d * d);
    }
}

