/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.AreaXBody;
import icy.type.geom.areax.AreaXOperation;
import icy.type.geom.areax.AreaXRules;
import icy.type.geom.areax.CrossingsX;
import icy.type.geom.areax.CurveX;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;

public class AreaX
implements Shape,
Cloneable {
    public static final int RELATIONSHIP_LHS_CONTAINS = 0;
    public static final int RELATIONSHIP_RHS_CONTAINS = 1;
    public static final int RELATIONSHIP_COMPLEX = 2;
    public static final int RELATIONSHIP_NONE = 3;
    private static AreaXBody emptyBody = new AreaXBody(null, 0);
    private static AreaXRules minimalRules = new AreaXRules();
    private static Map<String, AreaXRules> rulesTable = new HashMap<String, AreaXRules>();
    private AreaXBody body;
    private List<AreaXOperation> queue = new LinkedList<AreaXOperation>();
    private AreaXRules rules = AreaX.getDefaultRules();

    private static AreaXRules getDefaultRules() {
        Object rulesObject = UIManager.get("AreaX.rules");
        if (rulesObject instanceof AreaXRules) {
            return (AreaXRules)rulesObject;
        }
        String className = (String)rulesObject;
        if (className == null) {
            className = "icy.type.geom.areax.BoundsRules";
        }
        AreaXRules rules = rulesTable.get(className);
        try {
            if (rules == null) {
                Class<?> theClass = Class.forName(className);
                Constructor<?> constructor = theClass.getConstructor(new Class[0]);
                rules = (AreaXRules)constructor.newInstance(new Object[0]);
            }
            return rules;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return minimalRules;
        }
    }

    public AreaX() {
        this.body = emptyBody;
    }

    public AreaX(AreaXBody body) {
        this.body = body;
    }

    public AreaX(Shape s) {
        if (s instanceof AreaX) {
            AreaX area = (AreaX)s;
            area.processQueue();
            this.body = area.body;
        } else {
            this.body = AreaXBody.create(s.getPathIterator(null), true);
        }
    }

    public synchronized void setRules(AreaXRules rules) {
        if (rules == null) {
            rules = minimalRules;
        }
        this.rules = rules;
    }

    public synchronized AreaXRules getRules() {
        return this.rules;
    }

    public synchronized void processQueue() {
        int queueSize = this.queue.size();
        if (queueSize == 0) {
            return;
        }
        AreaXOperation[] ops = this.queue.toArray(new AreaXOperation[queueSize]);
        this.queue.clear();
        this.body = this.rules.execute(this.body, ops);
    }

    public synchronized AreaXBody getBody() {
        this.processQueue();
        return this.body;
    }

    public synchronized void add(Shape rhs) {
        this.queue.add(new AreaXOperation(rhs, 0));
    }

    public synchronized boolean contains(Shape shape) {
        return this.getRelationship(null, shape, null) == 0;
    }

    public synchronized boolean contains(Shape shape, AffineTransform transform) {
        return this.getRelationship(null, shape, transform) == 0;
    }

    public synchronized boolean contains(AffineTransform lhsTransform, Shape shape, AffineTransform transform) {
        return this.getRelationship(lhsTransform, shape, transform) == 0;
    }

    public synchronized boolean intersects(Shape shape) {
        int r = this.getRelationship(null, shape, null);
        return r != 3;
    }

    public synchronized boolean intersects(Shape shape, AffineTransform transform) {
        int r = this.getRelationship(null, shape, transform);
        return r != 3;
    }

    public synchronized boolean intersects(AffineTransform lhsTransform, Shape shape, AffineTransform transform) {
        int r = this.getRelationship(lhsTransform, shape, transform);
        return r != 3;
    }

    public synchronized int getRelationship(AffineTransform lhsTransform, Shape shape, AffineTransform transform) {
        return this.getBody().getRelationship(lhsTransform, shape, transform);
    }

    public synchronized void executeAdd(AreaX rhs) {
        this.body = this.getBody().add(rhs.getBody());
    }

    public synchronized void subtract(Shape rhs) {
        this.queue.add(new AreaXOperation(rhs, 1));
    }

    public synchronized void executeSubtract(AreaX rhs) {
        this.body = this.getBody().subtract(rhs.getBody());
    }

    public synchronized void intersect(Shape rhs) {
        this.queue.add(new AreaXOperation(rhs, 3));
    }

    public synchronized void executeIntersect(AreaX rhs) {
        this.body = this.getBody().intersect(rhs.getBody());
    }

    public synchronized void exclusiveOr(Shape rhs) {
        this.queue.add(new AreaXOperation(rhs, 2));
    }

    public synchronized void executeExclusiveOr(AreaX rhs) {
        this.body = this.getBody().xor(rhs.getBody());
    }

    public synchronized void reset() {
        this.queue.clear();
        this.body = emptyBody;
    }

    public synchronized boolean isEmpty() {
        this.processQueue();
        return this.body.size() == 0;
    }

    public synchronized boolean isPolygonal() {
        this.processQueue();
        int a = 0;
        while (a < this.body.size()) {
            if (this.body.get(a).getOrder() > 1) {
                return false;
            }
            ++a;
        }
        return true;
    }

    public synchronized boolean isRectangular() {
        this.processQueue();
        int size = this.body.size();
        if (size == 0) {
            return true;
        }
        if (size > 3) {
            return false;
        }
        CurveX c1 = this.body.get(1);
        CurveX c2 = this.body.get(2);
        if (c1.getOrder() != 1 || c2.getOrder() != 1) {
            return false;
        }
        if (c1.getXTop() != c1.getXBot() || c2.getXTop() != c2.getXBot()) {
            return false;
        }
        return c1.getYTop() == c2.getYTop() && c1.getYBot() == c2.getYBot();
    }

    public synchronized boolean isSingular() {
        this.processQueue();
        if (this.body.size() < 3) {
            return true;
        }
        int a = 1;
        while (a < this.body.size()) {
            if (this.body.get(a).getOrder() == 0) {
                return false;
            }
            ++a;
        }
        return true;
    }

    @Override
    public synchronized Rectangle2D getBounds2D() {
        this.processQueue();
        return this.body.getBounds2D(null);
    }

    @Override
    public synchronized Rectangle getBounds() {
        this.processQueue();
        return this.body.getBounds(null);
    }

    public synchronized AreaX clone() {
        this.processQueue();
        return new AreaX(this);
    }

    public synchronized boolean equals(AreaX other) {
        return this.getBody().equals(other.getBody());
    }

    public synchronized void transform(AffineTransform t) {
        if (t == null) {
            throw new NullPointerException("transform must not be null");
        }
        this.body = this.getBody().transform(t);
    }

    public synchronized AreaX createTransformedArea(AffineTransform t) {
        AreaX a = new AreaX(this);
        a.transform(t);
        return a;
    }

    @Override
    public synchronized boolean contains(double x, double y) {
        return this.getBody().contains(x, y);
    }

    @Override
    public synchronized boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public synchronized boolean contains(double x, double y, double w, double h) {
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        this.processQueue();
        if (!this.body.boundsContains(x, y, w, h)) {
            return false;
        }
        CrossingsX c = CrossingsX.findCrossings(this.body, x, y, x + w, y + h);
        return c != null && c.covers(y, y + h);
    }

    @Override
    public synchronized boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public synchronized boolean intersects(double x, double y, double w, double h) {
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        this.processQueue();
        if (!this.body.boundsIntersects(x, y, w, h)) {
            return false;
        }
        CrossingsX c = CrossingsX.findCrossings(this.body, x, y, x + w, y + h);
        return c == null || !c.isEmpty();
    }

    @Override
    public synchronized boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public synchronized PathIterator getPathIterator(AffineTransform at) {
        this.processQueue();
        return this.body.getPathIterator(at);
    }

    @Override
    public synchronized PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }
}

