/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.AreaOpX;
import icy.type.geom.areax.AreaXIterator;
import icy.type.geom.areax.CurveList;
import icy.type.geom.areax.CurveX;
import icy.type.geom.areax.EmptyPathException;
import icy.type.geom.areax.Intersections;
import icy.type.geom.areax.Order0X;
import icy.type.geom.areax.Order1X;
import icy.type.geom.areax.Order2X;
import icy.type.geom.areax.Order3X;
import icy.type.geom.areax.ShapeBounds;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class AreaXBody
extends CurveList {
    private static AreaXBody emptyBody = new AreaXBody(null, 0);
    private Rectangle2D bounds = new Rectangle2D.Double();
    private final AreaOpX validationOperator;
    private AreaXBody validatedBody;

    private AreaXBody() {
        super(0);
        this.validationOperator = null;
    }

    public AreaXBody(AreaOpX validationOperator, int initialCapacity) {
        super(initialCapacity);
        this.validationOperator = validationOperator;
    }

    public boolean contains(double x, double y) {
        if (!this.bounds.contains(x, y)) {
            return false;
        }
        int crossings = 0;
        int size = this.size();
        int a = 0;
        while (a < size) {
            CurveX c = this.elementData[a];
            crossings += c.crossingsFor(x, y);
            ++a;
        }
        return crossings & true;
    }

    public int getRelationship(Shape rhs, AffineTransform at) {
        return this.getRelationship(null, rhs, at);
    }

    public int getRelationship(AffineTransform lhsTransform, Shape rhs, AffineTransform at) {
        PathIterator rhsi = rhs.getPathIterator(at);
        if (rhs instanceof AreaXIterator) {
            AreaXIterator axi = (AreaXIterator)((Object)rhs);
            Rectangle2D rectangle2D = axi.curves.bounds;
        }
        try {
            Rectangle2D rhsBounds = ShapeBounds.getBounds(rhs, at);
            if ((lhsTransform == null || lhsTransform.isIdentity()) && !rhsBounds.intersects(this.bounds)) {
                return 3;
            }
        }
        catch (EmptyPathException e) {
            return 3;
        }
        double[] coords = new double[6];
        int relationship = -1;
        double moveX = 0.0;
        double moveY = 0.0;
        double lastX = 0.0;
        double lastY = 0.0;
        boolean closed = false;
        AreaXIterator axi = new AreaXIterator();
        while (!rhsi.isDone()) {
            int i = rhsi.currentSegment(coords);
            if (i == 4) {
                if (lastX != moveX && lastY != moveY && this.intersectsLine(lastX, lastY, moveX, moveY, axi, lhsTransform)) {
                    return 2;
                }
                closed = true;
            }
            if (i == 0 && lastX != moveX && lastY != moveY && !closed && this.intersectsLine(lastX, lastY, moveX, moveY, axi, lhsTransform)) {
                return 2;
            }
            if (i == 0) {
                int newRelationship;
                lastX = moveX = coords[0];
                lastY = moveY = coords[1];
                boolean contains = this.contains(moveX, moveY);
                int n = newRelationship = contains ? 0 : 3;
                if (relationship == -1) {
                    relationship = newRelationship;
                } else if (relationship != newRelationship) {
                    return 2;
                }
                closed = false;
            } else if (i == 1) {
                if (this.intersectsLine(lastX, lastY, coords[0], coords[1], axi, lhsTransform)) {
                    return 2;
                }
                lastX = coords[0];
                lastY = coords[1];
            } else if (i == 2) {
                if (this.intersectsQuad(lastX, lastY, coords[0], coords[1], coords[2], coords[3], axi, lhsTransform)) {
                    return 2;
                }
                lastX = coords[2];
                lastY = coords[3];
            } else if (i == 3) {
                if (this.intersectsCubic(lastX, lastY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], axi, lhsTransform)) {
                    return 2;
                }
                lastX = coords[4];
                lastY = coords[5];
            }
            rhsi.next();
        }
        if ((moveX != lastX || moveY != lastY) && this.intersectsLine(lastX, lastY, moveX, moveY, axi, lhsTransform)) {
            return 2;
        }
        if (relationship == 3) {
            if (this.elementCount == 0) {
                return 3;
            }
            relationship = -1;
            int a = 0;
            while (a < this.elementCount) {
                if (this.elementData[a] instanceof Order0X) {
                    int newRelationship = rhs.contains(this.elementData[a].getX0(), this.elementData[a].getY0()) ? 1 : 3;
                    if (relationship == -1) {
                        relationship = newRelationship;
                    } else if (relationship != newRelationship) {
                        return 2;
                    }
                }
                ++a;
            }
        }
        return relationship;
    }

    public int getRelationship(AreaXBody rhs, AffineTransform at) {
        return this.getRelationship(null, rhs, at);
    }

    public int getRelationship(AffineTransform lhsTransform, AreaXBody rhs, AffineTransform at) {
        if (!rhs.bounds.intersects(this.bounds)) {
            return 3;
        }
        PathIterator rhsi = rhs.getPathIterator(at);
        double[] coords = new double[6];
        int relationship = -1;
        double moveX = 0.0;
        double moveY = 0.0;
        double lastX = 0.0;
        double lastY = 0.0;
        boolean closed = false;
        AreaXIterator axi = new AreaXIterator();
        while (!rhsi.isDone()) {
            int i = rhsi.currentSegment(coords);
            if (i == 4) {
                if (lastX != moveX && lastY != moveY && this.intersectsLine(lastX, lastY, moveX, moveY, axi, lhsTransform)) {
                    return 2;
                }
                closed = true;
            }
            if (i == 0 && lastX != moveX && lastY != moveY && !closed && this.intersectsLine(lastX, lastY, moveX, moveY, axi, lhsTransform)) {
                return 2;
            }
            if (i == 0) {
                int newRelationship;
                lastX = moveX = coords[0];
                lastY = moveY = coords[1];
                boolean contains = this.contains(moveX, moveY);
                int n = newRelationship = contains ? 0 : 3;
                if (relationship == -1) {
                    relationship = newRelationship;
                } else if (relationship != newRelationship) {
                    return 2;
                }
                closed = false;
            } else if (i == 1) {
                if (this.intersectsLine(lastX, lastY, coords[0], coords[1], axi, lhsTransform)) {
                    return 2;
                }
                lastX = coords[0];
                lastY = coords[1];
            } else if (i == 2) {
                if (this.intersectsQuad(lastX, lastY, coords[0], coords[1], coords[2], coords[3], axi, lhsTransform)) {
                    return 2;
                }
                lastX = coords[2];
                lastY = coords[3];
            } else if (i == 3) {
                if (this.intersectsCubic(lastX, lastY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], axi, lhsTransform)) {
                    return 2;
                }
                lastX = coords[4];
                lastY = coords[5];
            }
            rhsi.next();
        }
        if ((moveX != lastX || moveY != lastY) && this.intersectsLine(lastX, lastY, moveX, moveY, axi, lhsTransform)) {
            return 2;
        }
        if (relationship == 3) {
            if (this.elementCount == 0) {
                return 3;
            }
            relationship = -1;
            int a = 0;
            while (a < this.elementCount) {
                if (this.elementData[a] instanceof Order0X) {
                    int newRelationship = rhs.contains(this.elementData[a].getX0(), this.elementData[a].getY0()) ? 1 : 3;
                    if (relationship == -1) {
                        relationship = newRelationship;
                    } else if (relationship != newRelationship) {
                        return 2;
                    }
                }
                ++a;
            }
        }
        return relationship;
    }

    private boolean intersectsLine(double x0, double y0, double x1, double y1, AreaXIterator axi, AffineTransform axiTx) {
        axi.reset(this, axiTx);
        double lastX = 0.0;
        double lastY = 0.0;
        double moveX = 0.0;
        double moveY = 0.0;
        double[] coords = new double[6];
        while (!axi.isDone()) {
            int k = axi.currentSegment(coords);
            if (k == 4 && (lastX != moveX || lastY != moveY)) {
                k = 1;
                coords[0] = moveX;
                coords[1] = moveY;
            }
            if (k == 0) {
                moveX = lastX = coords[0];
                moveY = lastY = coords[1];
            } else if (k == 1) {
                if (Intersections.lineLine(x0, y0, x1, y1, lastX, lastY, coords[0], coords[1])) {
                    return true;
                }
                lastX = coords[0];
                lastY = coords[1];
            } else if (k == 2) {
                if (Intersections.lineQuad(x0, y0, x1, y1, lastX, lastY, coords[0], coords[1], coords[2], coords[3])) {
                    return true;
                }
                lastX = coords[2];
                lastY = coords[3];
            } else if (k == 3) {
                if (Intersections.lineCubic(x0, y0, x1, y1, lastX, lastY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5])) {
                    return true;
                }
                lastX = coords[4];
                lastY = coords[5];
            }
            axi.next();
        }
        return false;
    }

    private boolean intersectsQuad(double x0, double y0, double cx, double cy, double x1, double y1, AreaXIterator axi, AffineTransform axiTx) {
        axi.reset(this, axiTx);
        double lastX = 0.0;
        double lastY = 0.0;
        double moveX = 0.0;
        double moveY = 0.0;
        double[] coords = new double[6];
        while (!axi.isDone()) {
            int k = axi.currentSegment(coords);
            if (k == 4 && (lastX != moveX || lastY != moveY)) {
                k = 1;
                coords[0] = moveX;
                coords[1] = moveY;
            }
            if (k == 0) {
                moveX = lastX = coords[0];
                moveY = lastY = coords[1];
            } else if (k == 1) {
                if (Intersections.lineQuad(lastX, lastY, coords[0], coords[1], x0, y0, cx, cy, x1, y1)) {
                    return true;
                }
                lastX = coords[0];
                lastY = coords[1];
            } else if (k == 2) {
                if (Intersections.quadQuad(x0, y0, cx, cy, x1, y1, lastX, lastY, coords[0], coords[1], coords[2], coords[3])) {
                    return true;
                }
                lastX = coords[2];
                lastY = coords[3];
            } else if (k == 3) {
                if (Intersections.quadCubic(x0, y0, cx, cy, x1, y1, lastX, lastY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5])) {
                    return true;
                }
                lastX = coords[4];
                lastY = coords[5];
            }
            axi.next();
        }
        return false;
    }

    private boolean intersectsCubic(double x0, double y0, double cx0, double cy0, double cx1, double cy1, double x1, double y1, AreaXIterator axi, AffineTransform axiTx) {
        axi.reset(this, axiTx);
        double lastX = 0.0;
        double lastY = 0.0;
        double moveX = 0.0;
        double moveY = 0.0;
        double[] coords = new double[6];
        while (!axi.isDone()) {
            int k = axi.currentSegment(coords);
            if (k == 4 && (lastX != moveX || lastY != moveY)) {
                k = 1;
                coords[0] = moveX;
                coords[1] = moveY;
            }
            if (k == 0) {
                moveX = lastX = coords[0];
                moveY = lastY = coords[1];
            } else if (k == 1) {
                if (Intersections.lineCubic(lastX, lastY, coords[0], coords[1], x0, y0, cx0, cy0, cx1, cy1, x1, y1)) {
                    return true;
                }
                lastX = coords[0];
                lastY = coords[1];
            } else if (k == 2) {
                if (Intersections.quadCubic(lastX, lastY, coords[0], coords[1], coords[2], coords[3], x0, y0, cx0, cy0, cx1, cy1, x1, y1)) {
                    return true;
                }
                lastX = coords[2];
                lastY = coords[3];
            } else if (k == 3) {
                if (Intersections.cubicCubic(x0, y0, cx0, cy0, cx1, cy1, x1, y1, lastX, lastY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5])) {
                    return true;
                }
                lastX = coords[4];
                lastY = coords[5];
            }
            axi.next();
        }
        return false;
    }

    @Override
    protected void add(CurveX o) {
        if (this.size() == 0) {
            this.bounds.setFrame(o.getX0(), o.getY0(), 0.0, 0.0);
        }
        super.add(o);
        o.enlarge(this.bounds);
    }

    public boolean isValidated() {
        return this.validationOperator == null;
    }

    public AreaXBody validate() {
        if (this.validationOperator == null) {
            return this;
        }
        if (this.validatedBody != null) {
            return this.validatedBody;
        }
        this.validatedBody = this.validationOperator.calculate(this, emptyBody);
        return this.validatedBody;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != this) {
            return false;
        }
        AreaXBody rhs = (AreaXBody)obj;
        AreaXBody lhs = this;
        lhs = lhs.validate();
        rhs = rhs.validate();
        if (!lhs.bounds.equals(rhs.bounds)) {
            return false;
        }
        AreaXBody c = new AreaOpX.XorOp().calculate(lhs, rhs);
        return c.isEmpty();
    }

    public int hashCode() {
        int k = 0;
        k = (int)((long)k + Math.round(this.bounds.getX()));
        k = (int)((long)k + Math.round(this.bounds.getY()));
        k = (int)((long)k + Math.round(this.bounds.getWidth()));
        k = (int)((long)k + Math.round(this.bounds.getHeight()));
        return k;
    }

    public static AreaXBody create(PathIterator pi, boolean validate) {
        int windingRule = pi.getWindingRule();
        AreaOpX operator = windingRule == 0 ? new AreaOpX.EOWindOp() : new AreaOpX.NZWindOp();
        AreaXBody body = new AreaXBody(operator, 0);
        double[] coords = new double[23];
        double movx = 0.0;
        double movy = 0.0;
        double curx = 0.0;
        double cury = 0.0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    CurveX.insertLine(body, curx, cury, movx, movy);
                    curx = movx = coords[0];
                    cury = movy = coords[1];
                    CurveX.insertMove(body, movx, movy);
                    break;
                }
                case 1: {
                    double newx = coords[0];
                    double newy = coords[1];
                    CurveX.insertLine(body, curx, cury, newx, newy);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 2: {
                    double newx = coords[2];
                    double newy = coords[3];
                    CurveX.insertQuad(body, curx, cury, coords);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 3: {
                    double newx = coords[4];
                    double newy = coords[5];
                    CurveX.insertCubic(body, curx, cury, coords);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 4: {
                    CurveX.insertLine(body, curx, cury, movx, movy);
                    curx = movx;
                    cury = movy;
                }
            }
            pi.next();
        }
        CurveX.insertLine(body, curx, cury, movx, movy);
        if (validate) {
            return body.validate();
        }
        return body;
    }

    public Rectangle2D getBounds2D(Rectangle2D dest) {
        if (dest == null) {
            dest = new Rectangle2D.Double();
        }
        dest.setFrame(this.bounds);
        return dest;
    }

    public Rectangle getBounds(Rectangle dest) {
        if (dest == null) {
            dest = new Rectangle();
        }
        int x1 = (int)Math.floor(this.bounds.getMinX());
        int y1 = (int)Math.floor(this.bounds.getMinY());
        int x2 = (int)Math.ceil(this.bounds.getMaxX());
        int y2 = (int)Math.ceil(this.bounds.getMaxY());
        dest.setBounds(x1, y1, x2 - x1, y2 - y1);
        return dest;
    }

    public boolean boundsContains(double x, double y, double w, double h) {
        return this.bounds.contains(x, y, w, h);
    }

    public boolean boundsIntersects(double x, double y, double w, double h) {
        return this.bounds.intersects(x, y, w, h);
    }

    @Override
    public CurveX get(int index) {
        return super.get(index);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public int size() {
        return super.size();
    }

    public AreaXBody transform(AffineTransform t) {
        if (Math.abs(t.getShearX()) < 1.0E-7 && Math.abs(t.getShearY()) < 1.0E-7) {
            int size = this.size();
            double scaleX = t.getScaleX();
            double scaleY = t.getScaleY();
            double translateX = t.getTranslateX();
            double translateY = t.getTranslateY();
            AreaXBody newBody = new AreaXBody(this.validationOperator, size);
            boolean failed = false;
            int increasing = scaleY > 0.0 ? 1 : -1;
            int a = 0;
            while (!failed && a < size) {
                double cy0;
                double cx0;
                double y0;
                double x0;
                CurveX newCurve;
                double y02;
                CurveX curve = this.get(a);
                if (curve instanceof Order0X) {
                    double x02 = scaleX * curve.getX0() + translateX;
                    y02 = scaleY * curve.getY0() + translateY;
                    newCurve = new Order0X(x02, y02);
                } else if (curve instanceof Order1X) {
                    double x03 = scaleX * curve.getX0() + translateX;
                    y02 = scaleY * curve.getY0() + translateY;
                    double x1 = scaleX * curve.getX1() + translateX;
                    double y1 = scaleY * curve.getY1() + translateY;
                    newCurve = curve.getDirection() == increasing ? new Order1X(x03, y02, x1, y1, curve.getDirection()) : new Order1X(x1, y1, x03, y02, curve.getDirection());
                } else if (curve instanceof Order2X) {
                    Order2X quad = (Order2X)curve;
                    x0 = scaleX * curve.getX0() + translateX;
                    y0 = scaleY * curve.getY0() + translateY;
                    cx0 = scaleX * quad.getCX0() + translateX;
                    cy0 = scaleY * quad.getCY0() + translateY;
                    double x1 = scaleX * curve.getX1() + translateX;
                    double y1 = scaleY * curve.getY1() + translateY;
                    newCurve = curve.getDirection() == increasing ? new Order2X(x0, y0, cx0, cy0, x1, y1, curve.getDirection()) : new Order2X(x1, y1, cx0, cy0, x0, y0, curve.getDirection());
                } else {
                    Order3X cubic = (Order3X)curve;
                    x0 = scaleX * curve.getX0() + translateX;
                    y0 = scaleY * curve.getY0() + translateY;
                    cx0 = scaleX * cubic.getCX0() + translateX;
                    cy0 = scaleY * cubic.getCY0() + translateY;
                    double cx1 = scaleX * cubic.getCX1() + translateX;
                    double cy1 = scaleY * cubic.getCY1() + translateY;
                    double x1 = scaleX * curve.getX1() + translateX;
                    double y1 = scaleY * curve.getY1() + translateY;
                    newCurve = curve.getDirection() == increasing ? new Order3X(x0, y0, cx0, cy0, cx1, cy1, x1, y1, curve.getDirection()) : new Order3X(x1, y1, cx1, cy1, cx0, cy0, x0, y0, curve.getDirection());
                }
                if (((CurveX)newCurve).getY0() == ((CurveX)newCurve).getY1() != (curve.getY0() == curve.getY1())) {
                    failed = true;
                }
                newBody.add(newCurve);
                ++a;
            }
            if (!failed) {
                return newBody;
            }
        }
        return AreaXBody.create(this.getPathIterator(t), true);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new AreaXIterator(this, at);
    }

    public AreaXBody add(AreaXBody rhs) {
        if (this.isEmpty()) {
            return rhs;
        }
        if (rhs.isEmpty()) {
            return this;
        }
        return new AreaOpX.AddOp().calculate(this, rhs);
    }

    public AreaXBody merge(AreaXBody rhs) {
        if (this.isEmpty()) {
            return rhs;
        }
        if (rhs.isEmpty()) {
            return this;
        }
        AreaXBody newBody = new AreaXBody();
        AreaXBody lhs = this.validate();
        rhs = rhs.validate();
        int lhSize = lhs.size();
        int rhSize = rhs.size();
        newBody.ensureCapacity(lhSize + rhSize);
        int a = 0;
        while (a < lhSize) {
            newBody.add(lhs.elementData[a]);
            ++a;
        }
        a = 0;
        while (a < rhSize) {
            newBody.add(rhs.elementData[a]);
            ++a;
        }
        return newBody;
    }

    public AreaXBody merge(List<Object> rhs, int startIndex, int endIndex) {
        AreaXBody t;
        AreaXBody newBody = new AreaXBody();
        AreaXBody lhs = this.validate();
        int lhSize = lhs.size();
        int rhSize = 0;
        int a = startIndex;
        while (a <= endIndex) {
            t = (AreaXBody)rhs.get(a);
            AreaXBody t2 = t.validate();
            rhSize += t2.elementCount;
            if (t2 != t) {
                rhs.set(a, t2);
            }
            ++a;
        }
        newBody.ensureCapacity(lhSize + rhSize);
        a = 0;
        while (a < lhSize) {
            newBody.add(lhs.elementData[a]);
            ++a;
        }
        a = startIndex;
        while (a <= endIndex) {
            t = (AreaXBody)rhs.get(a);
            int b = 0;
            while (b < t.elementCount) {
                newBody.add(t.elementData[b]);
                ++b;
            }
            ++a;
        }
        return newBody;
    }

    public AreaXBody subtract(AreaXBody rhs) {
        if (this.isEmpty()) {
            return this;
        }
        if (rhs.isEmpty()) {
            return this;
        }
        return new AreaOpX.SubOp().calculate(this, rhs);
    }

    public AreaXBody intersect(AreaXBody rhs) {
        if (this.isEmpty()) {
            return this;
        }
        if (rhs.isEmpty()) {
            return rhs;
        }
        return new AreaOpX.IntOp().calculate(this, rhs);
    }

    public AreaXBody xor(AreaXBody rhs) {
        if (this.isEmpty()) {
            return rhs;
        }
        if (rhs.isEmpty()) {
            return this;
        }
        return new AreaOpX.XorOp().calculate(this, rhs);
    }
}

