/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.util.Arrays;
import java.util.Stack;

public class Intersections {
    private static Stack<double[]> doubleArrays = new Stack();
    private static double TOLERANCE = 1.0E-10;

    public static boolean lineLine(double x0a, double y0a, double x1a, double y1a, double x0b, double y0b, double x1b, double y1b) {
        if (x0a == x0b && y0a == y0b && x1a == x1b && y1a == y1b) {
            return true;
        }
        return Line2D.linesIntersect(x0a, y0a, x1a, y1a, x0b, y0b, x1b, y1b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lineQuad(double x0a, double y0a, double x1a, double y1a, double x0b, double y0b, double cxb, double cyb, double x1b, double y1b) {
        double[] array;
        Stack<double[]> stack = doubleArrays;
        synchronized (stack) {
            array = doubleArrays.size() == 0 ? new double[12] : doubleArrays.pop();
        }
        try {
            double cos;
            int polyBSize = Intersections.definePolygon(array, x0b, y0b, cxb, cyb, x1b, y1b);
            if (!Intersections.linePolygon(x0a, y0a, x1a, y1a, array, polyBSize)) {
                return false;
            }
            double theta = -Math.atan2(y1a - y0a, x1a - x0a);
            array[0] = x0b;
            array[1] = y0b;
            array[2] = cxb;
            array[3] = cyb;
            array[4] = x1b;
            array[5] = y1b;
            array[6] = x0a;
            array[7] = y0a;
            array[8] = x1a;
            array[9] = y1a;
            double sin = Math.sin(theta);
            double m00 = cos = Math.cos(theta);
            double m01 = -sin;
            double m10 = sin;
            double m11 = cos;
            int a = 0;
            while (a < 5) {
                double x = m00 * array[2 * a] + m01 * array[2 * a + 1];
                double y = m10 * array[2 * a] + m11 * array[2 * a + 1];
                array[2 * a] = x;
                array[2 * a + 1] = y;
                ++a;
            }
            x0b = array[0];
            y0b = array[1];
            cxb = array[2];
            cyb = array[3];
            x1b = array[4];
            y1b = array[5];
            x0a = array[6];
            y0a = array[7];
            x1a = array[8];
            y1a = array[9];
            double minX = x0a < x1a ? x0a : x1a;
            double maxX = x0a < x1a ? x1a : x0a;
            double ax = x0b - 2.0 * cxb + x1b;
            double bx = -2.0 * x0b + 2.0 * cxb;
            double cx = x0b;
            double ay = y0b - 2.0 * cyb + y1b;
            double by = -2.0 * y0b + 2.0 * cyb;
            double cy = y0b;
            array[2] = ay;
            array[1] = by;
            array[0] = cy - y1a;
            int results = QuadCurve2D.solveQuadratic(array);
            int a2 = 0;
            while (a2 < results) {
                double x;
                if (array[a2] >= 0.0 && array[a2] <= 1.0 && minX <= (x = (ax * array[a2] + bx) * array[a2] + cx) && x <= maxX) {
                    return true;
                }
                ++a2;
            }
            return false;
        }
        finally {
            doubleArrays.push(array);
        }
    }

    private static int add(double[] array, int size, double newValue) {
        array[size] = newValue;
        Arrays.sort(array, 0, ++size);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean quadQuad(double x0a, double y0a, double cxa, double cya, double x1a, double y1a, double x0b, double y0b, double cxb, double cyb, double x1b, double y1b) {
        double[] array2;
        double[] array1;
        if (x0a == x0b && y0a == y0b && cxa == cxb && cya == cyb && x1a == x1b && y1a == y1b) {
            return true;
        }
        Stack<double[]> stack = doubleArrays;
        synchronized (stack) {
            if (doubleArrays.size() <= 1) {
                array1 = new double[12];
                array2 = new double[12];
            } else {
                array1 = doubleArrays.pop();
                array2 = doubleArrays.pop();
            }
        }
        try {
            int polyASize = Intersections.definePolygon(array1, x0a, y0a, cxa, cya, x1a, y1a);
            int polyBSize = Intersections.definePolygon(array2, x0b, y0b, cxb, cyb, x1b, y1b);
            if (!Intersections.polygonPolygon(array1, polyASize, array2, polyBSize)) {
                return false;
            }
            double ax0 = x0a - 2.0 * cxa + x1a;
            double bx0 = -2.0 * x0a + 2.0 * cxa;
            double cx0 = x0a;
            double ay0 = y0a - 2.0 * cya + y1a;
            double by0 = -2.0 * y0a + 2.0 * cya;
            double cy0 = y0a;
            double ax1 = x0b - 2.0 * cxb + x1b;
            double bx1 = -2.0 * x0b + 2.0 * cxb;
            double cx1 = x0b;
            double ay1 = y0b - 2.0 * cyb + y1b;
            double by1 = -2.0 * y0b + 2.0 * cyb;
            double cy1 = y0b;
            int size1 = Intersections.getTimes(array1, ax0, bx0, cx0, ay0, by0, cy0);
            int size2 = Intersections.getTimes(array2, ax1, bx1, cx1, ay1, by1, cy1);
            int i1 = 0;
            while (i1 < size1 - 1) {
                int i2 = 0;
                while (i2 < size2 - 1) {
                    if (Intersections.binary_search(0.0, ax0, bx0, cx0, 0.0, ay0, by0, cy0, array1[i1], array1[i1 + 1], 0.0, ax1, bx1, cx1, 0.0, ay1, by1, cy1, array2[i2], array2[i2 + 1])) {
                        return true;
                    }
                    ++i2;
                }
                ++i1;
            }
            return false;
        }
        finally {
            doubleArrays.push(array1);
            doubleArrays.push(array2);
        }
    }

    private static int getTimes(double[] dest, double ax, double bx, double cx, double ay, double by, double cy) {
        dest[0] = 0.0;
        dest[1] = 1.0;
        int size = 2;
        double t = -bx / (2.0 * ax);
        if (t > 0.0 && t < 1.0) {
            size = Intersections.add(dest, size, t);
        }
        if ((t = -by / (2.0 * ay)) > 0.0 && t < 1.0) {
            size = Intersections.add(dest, size, t);
        }
        return size;
    }

    private static int getTimes(double[] dest, double ax, double bx, double cx, double dx, double ay, double by, double cy, double dy) {
        double t;
        dest[0] = 0.0;
        dest[1] = 1.0;
        int size = 2;
        double det = 4.0 * bx * bx - 12.0 * ax * cx;
        if (det > 0.0) {
            t = (-2.0 * bx + (det = Math.sqrt(det))) / (6.0 * ax);
            if (t > 0.0 && t < 1.0) {
                size = Intersections.add(dest, size, t);
            }
            if ((t = (-2.0 * bx - det) / (6.0 * ax)) > 0.0 && t < 1.0) {
                size = Intersections.add(dest, size, t);
            }
        } else if (det == 0.0 && (t = -2.0 * bx / (6.0 * ax)) > 0.0 && t < 1.0) {
            size = Intersections.add(dest, size, t);
        }
        if ((det = 4.0 * by * by - 12.0 * ay * cy) > 0.0) {
            t = (-2.0 * by + (det = Math.sqrt(det))) / (6.0 * ay);
            if (t > 0.0 && t < 1.0) {
                size = Intersections.add(dest, size, t);
            }
            if ((t = (-2.0 * by - det) / (6.0 * ay)) > 0.0 && t < 1.0) {
                size = Intersections.add(dest, size, t);
            }
        } else if (det == 0.0 && (t = -2.0 * by / (6.0 * ay)) > 0.0 && t < 1.0) {
            size = Intersections.add(dest, size, t);
        }
        return size;
    }

    private static boolean intersects(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double maxYB;
        double minYB;
        double maxXB;
        double minXB;
        double maxYA;
        double minYA;
        double maxXA;
        double minXA;
        if (x0 < x1) {
            minXA = x0;
            maxXA = x1;
        } else {
            minXA = x1;
            maxXA = x0;
        }
        if (y0 < y1) {
            minYA = y0;
            maxYA = y1;
        } else {
            minYA = y1;
            maxYA = y0;
        }
        if (x2 < x3) {
            minXB = x2;
            maxXB = x3;
        } else {
            minXB = x3;
            maxXB = x2;
        }
        if (y2 < y3) {
            minYB = y2;
            maxYB = y3;
        } else {
            minYB = y3;
            maxYB = y2;
        }
        return maxXA > minXB && maxYA > minYB && minXA < maxXB && minYA < maxYB;
    }

    private static boolean binary_search(double ax0, double bx0, double cx0, double dx0, double ay0, double by0, double cy0, double dy0, double startT0, double endT0, double ax1, double bx1, double cx1, double dx1, double ay1, double by1, double cy1, double dy1, double startT1, double endT1) {
        boolean intersects1;
        double midT1;
        boolean intersects2;
        double startX0 = ((ax0 * startT0 + bx0) * startT0 + cx0) * startT0 + dx0;
        double startY0 = ((ay0 * startT0 + by0) * startT0 + cy0) * startT0 + dy0;
        double endX0 = ((ax0 * endT0 + bx0) * endT0 + cx0) * endT0 + dx0;
        double endY0 = ((ay0 * endT0 + by0) * endT0 + cy0) * endT0 + dy0;
        double startX1 = ((ax1 * startT1 + bx1) * startT1 + cx1) * startT1 + dx1;
        double startY1 = ((ay1 * startT1 + by1) * startT1 + cy1) * startT1 + dy1;
        double endX1 = ((ax1 * endT1 + bx1) * endT1 + cx1) * endT1 + dx1;
        double endY1 = ((ay1 * endT1 + by1) * endT1 + cy1) * endT1 + dy1;
        boolean intersects = Intersections.intersects(startX0, startY0, endX0, endY0, startX1, startY1, endX1, endY1);
        if (!intersects) {
            return false;
        }
        while (true) {
            double midY0;
            double midX0;
            double midT0;
            boolean split1;
            double kx0 = startX0 - endX0;
            double ky0 = startY0 - endY0;
            double kx1 = startX1 - endX1;
            double ky1 = startY1 - endY1;
            if (kx0 < 0.0) {
                kx0 = -kx0;
            }
            if (ky0 < 0.0) {
                ky0 = -ky0;
            }
            if (kx1 < 0.0) {
                kx1 = -kx1;
            }
            if (ky1 < 0.0) {
                ky1 = -ky1;
            }
            boolean split0 = kx0 > TOLERANCE || ky0 > TOLERANCE;
            boolean bl = split1 = kx1 > TOLERANCE || ky1 > TOLERANCE;
            if (!split0 && !split1) {
                return true;
            }
            if (split0 && split1) {
                midT0 = (startT0 + endT0) / 2.0;
                midX0 = ((ax0 * midT0 + bx0) * midT0 + cx0) * midT0 + dx0;
                midY0 = ((ay0 * midT0 + by0) * midT0 + cy0) * midT0 + dy0;
                double midT12 = (startT1 + endT1) / 2.0;
                double midX1 = ((ax1 * midT12 + bx1) * midT12 + cx1) * midT12 + dx1;
                double midY1 = ((ay1 * midT12 + by1) * midT12 + cy1) * midT12 + dy1;
                boolean intersects12 = Intersections.intersects(startX0, startY0, midX0, midY0, startX1, startY1, midX1, midY1);
                boolean intersects22 = Intersections.intersects(midX0, midY0, endX0, endY0, startX1, startY1, midX1, midY1);
                boolean intersects3 = Intersections.intersects(startX0, startY0, midX0, midY0, midX1, midY1, endX1, endY1);
                boolean intersects4 = Intersections.intersects(midX0, midY0, endX0, endY0, midX1, midY1, endX1, endY1);
                if (intersects12 && !intersects22 && !intersects3 && !intersects4) {
                    endT0 = midT0;
                    endX0 = midX0;
                    endY0 = midY0;
                    endT1 = midT12;
                    endX1 = midX1;
                    endY1 = midY1;
                    continue;
                }
                if (!intersects12 && intersects22 && !intersects3 && !intersects4) {
                    startT0 = midT0;
                    startX0 = midX0;
                    startY0 = midY0;
                    endT1 = midT12;
                    endX1 = midX1;
                    endY1 = midY1;
                    continue;
                }
                if (!intersects12 && !intersects22 && intersects3 && !intersects4) {
                    endT0 = midT0;
                    endX0 = midX0;
                    endY0 = midY0;
                    startT1 = midT12;
                    startX1 = midX1;
                    startY1 = midY1;
                    continue;
                }
                if (!intersects12 && !intersects22 && !intersects3 && intersects4) {
                    startT0 = midT0;
                    startX0 = midX0;
                    startY0 = midY0;
                    startT1 = midT12;
                    startX1 = midX1;
                    startY1 = midY1;
                    continue;
                }
                if (intersects12 && Intersections.binary_search(ax0, bx0, cx0, dx0, ay0, by0, cy0, dy0, startT0, midT0, ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1, startT1, midT12)) {
                    return true;
                }
                if (intersects22 && Intersections.binary_search(ax0, bx0, cx0, dx0, ay0, by0, cy0, dy0, midT0, endT0, ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1, startT1, midT12)) {
                    return true;
                }
                if (intersects3 && Intersections.binary_search(ax0, bx0, cx0, dx0, ay0, by0, cy0, dy0, startT0, midT0, ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1, midT12, endT1)) {
                    return true;
                }
                return intersects4 && Intersections.binary_search(ax0, bx0, cx0, dx0, ay0, by0, cy0, dy0, midT0, endT0, ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1, midT12, endT1);
            }
            if (split0) {
                midT0 = (startT0 + endT0) / 2.0;
                midX0 = ((ax0 * midT0 + bx0) * midT0 + cx0) * midT0 + dx0;
                midY0 = ((ay0 * midT0 + by0) * midT0 + cy0) * midT0 + dy0;
                boolean intersects13 = Intersections.intersects(startX0, startY0, midX0, midY0, startX1, startY1, endX1, endY1);
                intersects2 = Intersections.intersects(midX0, midY0, endX0, endY0, startX1, startY1, endX1, endY1);
                if (intersects13 && !intersects2) {
                    endT0 = midT0;
                    endX0 = midX0;
                    endY0 = midY0;
                    continue;
                }
                if (!intersects13 && intersects2) {
                    startT0 = midT0;
                    startX0 = midX0;
                    startY0 = midY0;
                    continue;
                }
                if (intersects13 && Intersections.binary_search(ax0, bx0, cx0, dx0, ay0, by0, cy0, dy0, startT0, midT0, ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1, startT1, endT1)) {
                    return true;
                }
                return intersects2 && Intersections.binary_search(ax0, bx0, cx0, dx0, ay0, by0, cy0, dy0, midT0, endT0, ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1, startT1, endT1);
            }
            if (!split1) continue;
            midT1 = (startT1 + endT1) / 2.0;
            double midX1 = ((ax1 * midT1 + bx1) * midT1 + cx1) * midT1 + dx1;
            double midY1 = ((ay1 * midT1 + by1) * midT1 + cy1) * midT1 + dy1;
            intersects1 = Intersections.intersects(startX0, startY0, endX0, endY0, startX1, startY1, midX1, midY1);
            intersects2 = Intersections.intersects(startX0, startY0, endX0, endY0, midX1, midY1, endX1, endY1);
            if (intersects1 && !intersects2) {
                endT1 = midT1;
                endX1 = midX1;
                endY1 = midY1;
                continue;
            }
            if (intersects1 || !intersects2) break;
            startT1 = midT1;
            startX1 = midX1;
            startY1 = midY1;
        }
        if (intersects1 && Intersections.binary_search(ax0, bx0, cx0, dx0, ay0, by0, cy0, dy0, startT0, endT0, ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1, startT1, midT1)) {
            return true;
        }
        return intersects2 && Intersections.binary_search(ax0, bx0, cx0, dx0, ay0, by0, cy0, dy0, startT0, endT0, ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1, midT1, endT1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean quadCubic(double x0a, double y0a, double cxa, double cya, double x1a, double y1a, double x0b, double y0b, double cx0b, double cy0b, double cx1b, double cy1b, double x1b, double y1b) {
        double[] array2;
        double[] array1;
        Stack<double[]> stack = doubleArrays;
        synchronized (stack) {
            if (doubleArrays.size() <= 1) {
                array1 = new double[12];
                array2 = new double[12];
            } else {
                array1 = doubleArrays.pop();
                array2 = doubleArrays.pop();
            }
        }
        try {
            int polyASize = Intersections.definePolygon(array1, x0a, y0a, cxa, cya, x1a, y1a);
            int polyBSize = Intersections.definePolygon(array2, x0b, y0b, cx0b, cy0b, cx1b, cy1b, x1b, y1b);
            if (!Intersections.polygonPolygon(array1, polyASize, array2, polyBSize)) {
                return false;
            }
            double ax0 = x0a - 2.0 * cxa + x1a;
            double bx0 = -2.0 * x0a + 2.0 * cxa;
            double cx0 = x0a;
            double ay0 = y0a - 2.0 * cya + y1a;
            double by0 = -2.0 * y0a + 2.0 * cya;
            double cy0 = y0a;
            double ax1 = -x0b + 3.0 * cx0b - 3.0 * cx1b + x1b;
            double bx1 = 3.0 * x0b - 6.0 * cx0b + 3.0 * cx1b;
            double cx1 = -3.0 * x0b + 3.0 * cx0b;
            double dx1 = x0b;
            double ay1 = -y0b + 3.0 * cy0b - 3.0 * cy1b + y1b;
            double by1 = 3.0 * y0b - 6.0 * cy0b + 3.0 * cy1b;
            double cy1 = -3.0 * y0b + 3.0 * cy0b;
            double dy1 = y0b;
            int size1 = Intersections.getTimes(array1, ax0, bx0, cx0, ay0, by0, cy0);
            int size2 = Intersections.getTimes(array2, ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1);
            int i1 = 0;
            while (i1 < size1 - 1) {
                int i2 = 0;
                while (i2 < size2 - 1) {
                    if (Intersections.binary_search(0.0, ax0, bx0, cx0, 0.0, ay0, by0, cy0, array1[i1], array1[i1 + 1], ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1, array2[i2], array2[i2 + 1])) {
                        return true;
                    }
                    ++i2;
                }
                ++i1;
            }
            return false;
        }
        finally {
            doubleArrays.push(array1);
            doubleArrays.push(array2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cubicCubic(double x0a, double y0a, double cx0a, double cy0a, double cx1a, double cy1a, double x1a, double y1a, double x0b, double y0b, double cx0b, double cy0b, double cx1b, double cy1b, double x1b, double y1b) {
        double[] array2;
        double[] array1;
        if (x0a == x0b && y0a == y0b && cx0a == cx0b && cy0a == cy0b && cx1a == cx1b && cy1a == cy1b && x1a == x1b && y1a == y1b) {
            return true;
        }
        Stack<double[]> stack = doubleArrays;
        synchronized (stack) {
            if (doubleArrays.size() <= 1) {
                array1 = new double[12];
                array2 = new double[12];
            } else {
                array1 = doubleArrays.pop();
                array2 = doubleArrays.pop();
            }
        }
        try {
            int polyASize = Intersections.definePolygon(array1, x0a, y0a, cx0a, cy0a, cx1a, cy1a, x1a, y1a);
            int polyBSize = Intersections.definePolygon(array2, x0b, y0b, cx0b, cy0b, cx1b, cy1b, x1b, y1b);
            if (!Intersections.polygonPolygon(array1, polyASize, array2, polyBSize)) {
                return false;
            }
            double ax0 = -x0a + 3.0 * cx0a - 3.0 * cx1a + x1a;
            double bx0 = 3.0 * x0a - 6.0 * cx0a + 3.0 * cx1a;
            double cx0 = -3.0 * x0a + 3.0 * cx0a;
            double dx0 = x0a;
            double ay0 = -y0a + 3.0 * cy0a - 3.0 * cy1a + y1a;
            double by0 = 3.0 * y0a - 6.0 * cy0a + 3.0 * cy1a;
            double cy0 = -3.0 * y0a + 3.0 * cy0a;
            double dy0 = y0a;
            double ax1 = -x0b + 3.0 * cx0b - 3.0 * cx1b + x1b;
            double bx1 = 3.0 * x0b - 6.0 * cx0b + 3.0 * cx1b;
            double cx1 = -3.0 * x0b + 3.0 * cx0b;
            double dx1 = x0b;
            double ay1 = -y0b + 3.0 * cy0b - 3.0 * cy1b + y1b;
            double by1 = 3.0 * y0b - 6.0 * cy0b + 3.0 * cy1b;
            double cy1 = -3.0 * y0b + 3.0 * cy0b;
            double dy1 = y0b;
            int size1 = Intersections.getTimes(array1, ax0, bx0, cx0, dx0, ay0, by0, cy0, dy0);
            int size2 = Intersections.getTimes(array2, ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1);
            int i1 = 0;
            while (i1 < size1 - 1) {
                int i2 = 0;
                while (i2 < size2 - 1) {
                    if (Intersections.binary_search(ax0, bx0, cx0, dx0, ay0, by0, cy0, dy0, array1[i1], array1[i1 + 1], ax1, bx1, cx1, dx1, ay1, by1, cy1, dy1, array2[i2], array2[i2 + 1])) {
                        return true;
                    }
                    ++i2;
                }
                ++i1;
            }
            return false;
        }
        finally {
            doubleArrays.push(array1);
            doubleArrays.push(array2);
        }
    }

    private static int definePolygon(double[] array, double x0, double y0, double cx, double cy, double x1, double y1) {
        array[0] = x0;
        array[1] = y0;
        array[2] = cx;
        array[3] = cy;
        array[4] = x1;
        array[5] = y1;
        return 3;
    }

    private static int definePolygon(double[] array, double x0, double y0, double cx0, double cy0, double cx1, double cy1, double x1, double y1) {
        array[0] = x0;
        array[1] = y0;
        array[2] = cx1;
        array[3] = cy1;
        array[4] = x1;
        array[5] = y1;
        if (Intersections.polygonContains(cx0, cy0, array, 3)) {
            return 3;
        }
        array[2] = cx0;
        array[3] = cy0;
        if (Intersections.polygonContains(cx1, cy1, array, 3)) {
            return 3;
        }
        array[4] = cx1;
        array[5] = cy1;
        if (Intersections.polygonContains(x1, y1, array, 3)) {
            return 3;
        }
        array[0] = x1;
        array[1] = y1;
        if (Intersections.polygonContains(x0, y0, array, 3)) {
            return 3;
        }
        if (Line2D.relativeCCW(x0, y0, x1, y1, cx0, cy0) == Line2D.relativeCCW(x0, y0, x1, y1, cx1, cy1)) {
            if (Line2D.linesIntersect(x0, y0, cx0, cy0, cx1, cy1, x1, y1)) {
                array[0] = x0;
                array[1] = y0;
                array[2] = cx1;
                array[3] = cy1;
                array[4] = cx0;
                array[5] = cy0;
                array[6] = x1;
                array[7] = y1;
                return 4;
            }
            array[0] = x0;
            array[1] = y0;
            array[2] = cx0;
            array[3] = cy0;
            array[4] = cx1;
            array[5] = cy1;
            array[6] = x1;
            array[7] = y1;
            return 4;
        }
        array[0] = x0;
        array[1] = y0;
        array[2] = cx0;
        array[3] = cy0;
        array[4] = x1;
        array[5] = y1;
        array[6] = cx1;
        array[7] = cy1;
        return 4;
    }

    protected static boolean linePolygon(double x0, double y0, double x1, double y1, double[] coords, int coordCount) {
        int a = 0;
        while (a < coordCount) {
            int index1 = a;
            int index2 = (a + 1) % coordCount;
            if (Line2D.linesIntersect(x0, y0, x1, y1, coords[index1 * 2], coords[index1 * 2 + 1], coords[index2 * 2], coords[index2 * 2 + 1])) {
                return true;
            }
            ++a;
        }
        return Intersections.polygonContains(x0, y0, coords, coordCount);
    }

    protected static boolean polygonPolygon(double[] coords1, int coordCount1, double[] coords2, int coordCount2) {
        int a = 0;
        while (a < coordCount1) {
            int index1a = a;
            int index2a = (a + 1) % coordCount1;
            int b = 0;
            while (b < coordCount2) {
                int index1b = b;
                int index2b = (b + 1) % coordCount2;
                if (Line2D.linesIntersect(coords1[index1a * 2], coords1[index1a * 2 + 1], coords1[index2a * 2], coords1[index2a * 2 + 1], coords2[index1b * 2], coords2[index1b * 2 + 1], coords2[index2b * 2], coords2[index2b * 2 + 1])) {
                    return true;
                }
                ++b;
            }
            ++a;
        }
        double minX1 = coords1[0];
        double maxX1 = coords1[0];
        double minX2 = coords2[0];
        double maxX2 = coords2[0];
        int a2 = 0;
        while (a2 < coordCount1) {
            minX1 = Math.min(minX1, coords1[2 * a2]);
            maxX1 = Math.max(maxX1, coords1[2 * a2]);
            ++a2;
        }
        a2 = 0;
        while (a2 < coordCount2) {
            minX2 = Math.min(minX2, coords2[2 * a2]);
            maxX2 = Math.max(maxX2, coords2[2 * a2]);
            ++a2;
        }
        double width1 = maxX1 - minX1;
        double width2 = maxX2 - minX2;
        if (width1 > width2) {
            return Intersections.polygonContains(coords2[0], coords2[1], coords1, coordCount1);
        }
        if (width2 > width1) {
            return Intersections.polygonContains(coords1[0], coords1[1], coords2, coordCount2);
        }
        if (Intersections.polygonContains(coords1[0], coords1[1], coords2, coordCount2)) {
            return true;
        }
        return Intersections.polygonContains(coords2[0], coords2[1], coords1, coordCount1);
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean polygonContains(double x, double y, double[] coords, int npoints) {
        hits = 0;
        lastx = coords[2 * npoints - 2];
        lasty = coords[2 * npoints - 1];
        i = 0;
        while (i < npoints) {
            block7: {
                block10: {
                    block11: {
                        block9: {
                            block8: {
                                curx = coords[2 * i];
                                cury = coords[2 * i + 1];
                                if (cury == lasty) break block7;
                                if (!(curx < lastx)) break block8;
                                if (x >= lastx) break block7;
                                leftx = curx;
                                break block9;
                            }
                            if (x >= curx) break block7;
                            leftx = lastx;
                        }
                        if (!(cury < lasty)) break block10;
                        if (y < cury || y >= lasty) break block7;
                        if (!(x < leftx)) break block11;
                        ++hits;
                        break block7;
                    }
                    test1 = x - curx;
                    test2 = y - cury;
                    ** GOTO lbl33
                }
                if (y < lasty || y >= cury) break block7;
                if (x < leftx) {
                    ++hits;
                } else {
                    test1 = x - lastx;
                    test2 = y - lasty;
lbl33:
                    // 2 sources

                    if (test1 < test2 / (lasty - cury) * (lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
            ++i;
        }
        return (hits & true) != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lineCubic(double x0a, double y0a, double x1a, double y1a, double x0b, double y0b, double cx0b, double cy0b, double cx1b, double cy1b, double x1b, double y1b) {
        double[] array;
        Stack<double[]> stack = doubleArrays;
        synchronized (stack) {
            array = doubleArrays.size() == 0 ? new double[12] : doubleArrays.pop();
        }
        try {
            double cos;
            int polySize = Intersections.definePolygon(array, x0b, y0b, cx0b, cy0b, cx1b, cy1b, x1b, y1b);
            if (!Intersections.linePolygon(x0a, y0a, x1a, y1a, array, polySize)) {
                return false;
            }
            double theta = -Math.atan2(y1a - y0a, x1a - x0a);
            array[0] = x0b;
            array[1] = y0b;
            array[2] = cx0b;
            array[3] = cy0b;
            array[4] = cx1b;
            array[5] = cy1b;
            array[6] = x1b;
            array[7] = y1b;
            array[8] = x0a;
            array[9] = y0a;
            array[10] = x1a;
            array[11] = y1a;
            double sin = Math.sin(theta);
            double m00 = cos = Math.cos(theta);
            double m01 = -sin;
            double m10 = sin;
            double m11 = cos;
            int a = 0;
            while (a < 6) {
                double x = m00 * array[2 * a] + m01 * array[2 * a + 1];
                double y = m10 * array[2 * a] + m11 * array[2 * a + 1];
                array[2 * a] = x;
                array[2 * a + 1] = y;
                ++a;
            }
            x0b = array[0];
            y0b = array[1];
            cx0b = array[2];
            cy0b = array[3];
            cx1b = array[4];
            cy1b = array[5];
            x1b = array[6];
            y1b = array[7];
            x0a = array[8];
            y0a = array[9];
            x1a = array[10];
            y1a = array[11];
            double minX = x0a < x1a ? x0a : x1a;
            double maxX = x0a < x1a ? x1a : x0a;
            double ax = -x0b + 3.0 * cx0b - 3.0 * cx1b + x1b;
            double bx = 3.0 * x0b - 6.0 * cx0b + 3.0 * cx1b;
            double cx = -3.0 * x0b + 3.0 * cx0b;
            double dx = x0b;
            double ay = -y0b + 3.0 * cy0b - 3.0 * cy1b + y1b;
            double by = 3.0 * y0b - 6.0 * cy0b + 3.0 * cy1b;
            double cy = -3.0 * y0b + 3.0 * cy0b;
            double dy = y0b;
            array[3] = ay;
            array[2] = by;
            array[1] = cy;
            array[0] = dy - y1a;
            int results = CubicCurve2D.solveCubic(array);
            int a2 = 0;
            while (a2 < results) {
                double x;
                if (array[a2] >= 0.0 && array[a2] <= 1.0 && minX <= (x = ((ax * array[a2] + bx) * array[a2] + cx) * array[a2] + dx) && x <= maxX) {
                    return true;
                }
                ++a2;
            }
            return false;
        }
        finally {
            doubleArrays.push(array);
        }
    }
}

