/*
 * Decompiled with CFR 0.152.
 */
package icy.type.rectangle;

import icy.type.geom.Line2DUtil;
import icy.util.ShapeUtil;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Rectangle2DUtil {
    public static Line2D getIntersectionLine(Rectangle2D rectangle, Line2D line) {
        if (rectangle.intersectsLine(line)) {
            ArrayList<Point2D> result = new ArrayList<Point2D>();
            Point2D.Double topLeft = new Point2D.Double(rectangle.getMinX(), rectangle.getMinY());
            Point2D.Double topRight = new Point2D.Double(rectangle.getMaxX(), rectangle.getMinY());
            Point2D.Double bottomRight = new Point2D.Double(rectangle.getMaxX(), rectangle.getMaxY());
            Point2D.Double bottomLeft = new Point2D.Double(rectangle.getMinX(), rectangle.getMaxY());
            Point2D intersection = Line2DUtil.getIntersection(new Line2D.Double(topLeft, topRight), line, true, false);
            if (intersection != null) {
                result.add(intersection);
            }
            if ((intersection = Line2DUtil.getIntersection(new Line2D.Double(topRight, bottomRight), line, true, false)) != null) {
                result.add(intersection);
            }
            if ((intersection = Line2DUtil.getIntersection(new Line2D.Double(bottomRight, bottomLeft), line, true, false)) != null) {
                result.add(intersection);
            }
            if ((intersection = Line2DUtil.getIntersection(new Line2D.Double(bottomLeft, topLeft), line, true, false)) != null) {
                result.add(intersection);
            }
            if (result.size() >= 2) {
                return new Line2D.Double((Point2D)result.get(0), (Point2D)result.get(1));
            }
        }
        return null;
    }

    public static Rectangle2D getScaledRectangle(Rectangle2D rect, double factor, boolean centered, boolean scalePosition) {
        Rectangle2D.Double result = new Rectangle2D.Double();
        result.setFrame(rect);
        ShapeUtil.scale(result, factor, centered, scalePosition);
        return result;
    }

    public static Rectangle2D getScaledRectangle(Rectangle2D rect, double factor, boolean centered) {
        return Rectangle2DUtil.getScaledRectangle(rect, factor, centered, false);
    }
}

