/*
 * Decompiled with CFR 0.152.
 */
package icy.undo;

import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.undo.IcyUndoableEdit;
import icy.util.StringUtil;
import java.awt.Image;
import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public abstract class AbstractIcyUndoableEdit
implements IcyUndoableEdit {
    protected static final IcyIcon DEFAULT_ICON = new IcyIcon(ResourceUtil.ICON_LIGHTING, 16);
    protected Object source;
    protected boolean hasBeenDone;
    protected boolean alive;
    protected IcyIcon icon;
    protected String presentationName;
    protected boolean mergeable;

    public AbstractIcyUndoableEdit(Object source, String name, Image icon) {
        this.source = source;
        this.hasBeenDone = true;
        this.alive = true;
        this.icon = icon != null ? new IcyIcon(icon, 16) : DEFAULT_ICON;
        this.presentationName = name;
        this.mergeable = true;
    }

    public AbstractIcyUndoableEdit(Object source, String name) {
        this(source, name, null);
    }

    public AbstractIcyUndoableEdit(Object source, Image icon) {
        this(source, "", icon);
    }

    public AbstractIcyUndoableEdit(Object source) {
        this(source, "", null);
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public IcyIcon getIcon() {
        return this.icon;
    }

    @Override
    public void die() {
        this.alive = false;
        this.source = null;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.hasBeenDone = false;
    }

    @Override
    public boolean canUndo() {
        return this.alive && this.hasBeenDone;
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.hasBeenDone = true;
    }

    @Override
    public boolean canRedo() {
        return this.alive && !this.hasBeenDone;
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public final boolean isSignificant() {
        return true;
    }

    @Override
    public boolean isMergeable() {
        return this.mergeable;
    }

    public void setMergeable(boolean value) {
        this.mergeable = value;
    }

    @Override
    public String getPresentationName() {
        return this.presentationName;
    }

    @Override
    public String getUndoPresentationName() {
        String name = this.getPresentationName();
        name = !StringUtil.isEmpty(name) ? String.valueOf(UIManager.getString("AbstractUndoableEdit.undoText")) + " " + name : UIManager.getString("AbstractUndoableEdit.undoText");
        return name;
    }

    @Override
    public String getRedoPresentationName() {
        String name = this.getPresentationName();
        name = !StringUtil.isEmpty(name) ? String.valueOf(UIManager.getString("AbstractUndoableEdit.redoText")) + " " + name : UIManager.getString("AbstractUndoableEdit.redoText");
        return name;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " hasBeenDone: " + this.hasBeenDone + " alive: " + this.alive;
    }
}

