/*
 * Decompiled with CFR 0.152.
 */
package icy.vtk;

import java.awt.Color;
import vtk.vtkActor;
import vtk.vtkMapper;
import vtk.vtkPlaneSource;
import vtk.vtkPolyDataMapper;

public class VtkPlaneObject {
    private final vtkPlaneSource planeSource = new vtkPlaneSource();
    private final vtkMapper mapper;
    private final vtkActor actor;

    public VtkPlaneObject() {
        this.planeSource.SetCenter(0.0, 0.0, 0.0);
        this.planeSource.SetNormal(0.0, 1.0, 0.0);
        this.planeSource.SetXResolution(1);
        this.planeSource.SetYResolution(1);
        this.mapper = new vtkPolyDataMapper();
        this.mapper.SetInputConnection(this.planeSource.GetOutputPort());
        this.actor = new vtkActor();
        this.actor.SetPickable(1);
        this.actor.SetMapper(this.mapper);
    }

    public void release() {
        this.actor.Delete();
        this.mapper.Delete();
        this.planeSource.Delete();
    }

    public vtkActor getActor() {
        return this.actor;
    }

    public void setColor(Color color) {
        this.actor.GetProperty().SetColor((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
    }

    public double[] getCenter() {
        return this.planeSource.GetCenter();
    }

    public void setCenter(double[] value) {
        this.planeSource.SetCenter(value);
    }

    public void setCenter(double x, double y, double z) {
        this.planeSource.SetCenter(x, y, z);
    }

    public double[] getNormal() {
        return this.planeSource.GetNormal();
    }

    public void setNormal(double[] value) {
        this.planeSource.SetNormal(value);
    }

    public void setNormal(double x, double y, double z) {
        this.planeSource.SetNormal(x, y, z);
    }

    public double[] getOrigin() {
        return this.planeSource.GetOrigin();
    }

    public void setOrigin(double[] value) {
        this.planeSource.SetOrigin(value);
    }

    public void setOrigin(double x, double y, double z) {
        this.planeSource.SetOrigin(x, y, z);
    }

    public double[] getPoint1() {
        return this.planeSource.GetPoint1();
    }

    public void setPoint1(double x, double y, double z) {
        this.planeSource.SetPoint1(x, y, z);
    }

    public void setPoint1(double[] id0) {
        this.planeSource.SetPoint1(id0);
    }

    public double[] getPoint2() {
        return this.planeSource.GetPoint2();
    }

    public void setPoint2(double x, double y, double z) {
        this.planeSource.SetPoint2(x, y, z);
    }

    public void setPoint2(double[] id0) {
        this.planeSource.SetPoint2(id0);
    }

    public int getXResolution() {
        return this.planeSource.GetXResolution();
    }

    public void setXResolution(int value) {
        this.planeSource.SetXResolution(value);
    }

    public int getYResolution() {
        return this.planeSource.GetYResolution();
    }

    public void setYResolution(int value) {
        this.planeSource.SetYResolution(value);
    }

    public void setWireframeMode() {
        this.actor.GetProperty().SetRepresentationToWireframe();
    }

    public void setSurfaceMode() {
        this.actor.GetProperty().SetRepresentationToSurface();
    }

    public void setEdgeVisibile(boolean value) {
        this.actor.GetProperty().SetEdgeVisibility(value ? 1 : 0);
    }

    public void setEdgeColor(Color color) {
        this.actor.GetProperty().SetEdgeColor((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
    }
}

