/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.bioimageio.description.Axes;
import io.bioimage.modelrunner.bioimageio.description.Axis;
import io.bioimage.modelrunner.bioimageio.description.AxisV04;
import io.bioimage.modelrunner.utils.YAMLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AxesV04
implements Axes {
    private final List<Axis> axesList;
    private final String axesOrder;
    private final double[] scaleArr;
    private final int[] minArr;
    private final int[] stepArr;
    private int[] haloArr;
    private final double[] offsetArr;
    private String reference;

    protected AxesV04(Map<String, Object> tensorSpecMap, boolean isInput) {
        Object halo;
        Map shapeMap;
        this.axesOrder = (String)tensorSpecMap.get("axes");
        if (this.axesOrder == null) {
            throw new IllegalArgumentException("Model rdf.yaml Bioimage.io specs does not contain information about the axes order.");
        }
        Object shape = tensorSpecMap.get("shape");
        if (shape instanceof List) {
            int[] shapeArr = YAMLUtils.castListToIntArray((List)shape);
            this.minArr = shapeArr;
            this.stepArr = new int[shapeArr.length];
            this.offsetArr = new double[shapeArr.length];
            double[] arr = new double[shapeArr.length];
            Arrays.fill(arr, -1.0);
            this.scaleArr = arr;
        } else if (shape instanceof Map && isInput) {
            shapeMap = (Map)shape;
            Object min = shapeMap.get("min");
            if (min == null) {
                throw new IllegalArgumentException("Minimum size needs to be defined for every input.");
            }
            this.minArr = YAMLUtils.castListToIntArray((List)min);
            Object step = shapeMap.get("step");
            if (step == null) {
                throw new IllegalArgumentException("Step size needs to be defined for every input.");
            }
            this.stepArr = YAMLUtils.castListToIntArray((List)step);
            this.offsetArr = new double[this.stepArr.length];
            double[] arr = new double[this.stepArr.length];
            Arrays.fill(arr, -1.0);
            this.scaleArr = arr;
        } else if (shape instanceof Map && !isInput) {
            this.stepArr = new int[this.axesOrder.length()];
            this.minArr = new int[this.axesOrder.length()];
            shapeMap = (Map)shape;
            this.reference = (String)shapeMap.get("reference_tensor");
            if (this.reference == null) {
                throw new IllegalArgumentException("An ouput tensor needs to reference an input tensors to find out its size.");
            }
            Object scale = shapeMap.get("scale");
            if (scale == null) {
                throw new IllegalArgumentException("Output tensors need to define a scale with respect to the reference input.");
            }
            this.scaleArr = YAMLUtils.castListToDoubleArray((List)scale);
            Object offset = shapeMap.get("offset");
            if (offset == null) {
                throw new IllegalArgumentException("Output tensors need to define a scale with respect to the reference input.");
            }
            this.offsetArr = YAMLUtils.castListToDoubleArray((List)offset);
        } else {
            throw new IllegalArgumentException("Incorrect specs consfiguration for the tensors.");
        }
        this.haloArr = !isInput ? ((halo = tensorSpecMap.get("halo")) == null || !(halo instanceof List) ? new int[this.axesOrder.length()] : YAMLUtils.castListToIntArray((List)halo)) : new int[this.stepArr.length];
        this.axesList = new ArrayList<Axis>();
        for (int i = 0; i < this.axesOrder.length(); ++i) {
            AxisV04 ax = new AxisV04(this.axesOrder.split("")[i], this.minArr[i], this.stepArr[i], this.haloArr[i], this.offsetArr[i], this.scaleArr[i], this.reference);
            this.axesList.add(ax);
        }
    }

    @Override
    public String getAxesOrder() {
        return this.axesOrder;
    }

    @Override
    public List<Axis> getAxesList() {
        return this.axesList;
    }

    @Override
    public int[] getMinTileSizeArr() {
        return this.minArr;
    }

    @Override
    public int[] getTileStepArr() {
        return this.stepArr;
    }

    @Override
    public double[] getTileScaleArr() {
        return this.scaleArr;
    }

    public double[] getOffsetArr() {
        return this.offsetArr;
    }

    @Override
    public int[] getHaloArr() {
        this.haloArr = new int[this.axesList.size()];
        for (int i = 0; i < this.axesList.size(); ++i) {
            this.haloArr[i] = this.axesList.get(i).getHalo();
        }
        return this.haloArr;
    }

    @Override
    public Axis getAxis(String abreviation) {
        return this.axesList.stream().filter(ax -> ax.getAxis().equals(abreviation)).findFirst().orElse(null);
    }
}

