/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.bioimageio.description.Axes;
import io.bioimage.modelrunner.bioimageio.description.Axis;
import io.bioimage.modelrunner.bioimageio.description.AxisV05;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AxesV05
implements Axes {
    private final List<Axis> axesList;
    private final String axesOrder;
    private final double[] scaleArr;
    private final int[] minArr;
    private final int[] stepArr;
    private int[] haloArr;

    protected AxesV05(List<Object> axesList) {
        ArrayList<Axis> axesListInit = new ArrayList<Axis>();
        String order = "";
        int[] minArr = new int[axesList.size()];
        int[] stepArr = new int[axesList.size()];
        double[] scaleArr = new double[axesList.size()];
        int c = 0;
        for (Object axisObject : axesList) {
            if (!(axisObject instanceof Map)) {
                throw new IllegalArgumentException("The input argument should be a list of maps. Go to the Bioimage.io specs documentation for more info.");
            }
            AxisV05 axis = new AxisV05((Map)axisObject);
            axesListInit.add(axis);
            order = order + axis.getAxis();
            minArr[c] = axis.getMin();
            stepArr[c] = axis.getStep();
            scaleArr[c++] = axis.getScale();
        }
        this.axesList = axesListInit;
        this.axesOrder = order;
        this.scaleArr = scaleArr;
        this.minArr = minArr;
        this.stepArr = stepArr;
    }

    @Override
    public String getAxesOrder() {
        return this.axesOrder;
    }

    @Override
    public List<Axis> getAxesList() {
        return this.axesList;
    }

    @Override
    public int[] getMinTileSizeArr() {
        return this.minArr;
    }

    @Override
    public int[] getTileStepArr() {
        return this.stepArr;
    }

    @Override
    public int[] getHaloArr() {
        this.haloArr = new int[this.axesList.size()];
        for (int i = 0; i < this.axesList.size(); ++i) {
            this.haloArr[i] = this.axesList.get(i).getHalo();
        }
        return this.haloArr;
    }

    @Override
    public double[] getTileScaleArr() {
        return this.scaleArr;
    }

    @Override
    public Axis getAxis(String abreviation) {
        return this.axesList.stream().filter(ax -> ax.getAxis().equals(abreviation)).findFirst().orElse(null);
    }
}

