/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.bioimageio.description.Axis;
import io.bioimage.modelrunner.bioimageio.description.AxisSize;
import java.util.List;
import java.util.Map;

public class AxisV05
implements Axis {
    private String id;
    private String type;
    private String description = "";
    private List<String> channelNames;
    private final String abreviation;
    private boolean concat = false;
    private double scale = 1.0;
    private AxisSize size;
    protected int halo = 0;
    private Map<String, Object> originalDescription;

    protected AxisV05(Map<String, Object> map) {
        this.originalDescription = map;
        this.id = (String)map.get("id");
        this.type = (String)map.get("type");
        this.channelNames = (List)map.get("channel_names");
        if (map.get("description") != null) {
            this.description = (String)map.get("description");
        }
        if (map.get("concatenable") != null) {
            this.concat = (Boolean)map.get("concatenable");
        }
        if (map.get("scale") != null) {
            this.scale = ((Number)map.get("scale")).doubleValue();
        }
        if (map.get("halo") != null) {
            this.halo = ((Number)map.get("halo")).intValue();
        }
        this.size = new AxisSize(map.get("size"));
        if (this.id == null && this.type == null) {
            throw new IllegalArgumentException("Invalid axis configuration: Either 'type' or 'id' must be defined for each axis. Current axis definition is missing both.");
        }
        if (this.id == null && this.type.equals("space")) {
            throw new IllegalArgumentException(String.format("Invalid axis configuration: When axis type is 'spaces', an 'id' must be defined. Current configuration: type='%s', id=%s", this.type, "null"));
        }
        if ((this.id == null || this.id != "b") && this.type.equals("batch")) {
            this.abreviation = "b";
        } else if (this.id != null && this.id.equals("channel")) {
            this.abreviation = "c";
            this.size.min = this.channelNames.size();
        } else if (this.type != null && this.type.equals("channel")) {
            this.abreviation = "c";
            this.size.min = this.channelNames.size();
        } else {
            this.abreviation = this.id;
        }
    }

    @Override
    public String getAxis() {
        return this.abreviation;
    }

    @Override
    public int getMin() {
        if (this.abreviation.equals("c")) {
            return this.channelNames != null ? this.channelNames.size() : 1;
        }
        return this.size.getMin();
    }

    @Override
    public int getStep() {
        return this.size.getStep();
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public List<String> getChannelNames() {
        return this.channelNames;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isConcat() {
        return this.concat;
    }

    @Override
    public int getHalo() {
        return this.halo;
    }

    @Override
    public double getOffset() {
        return this.size.getOffset();
    }

    @Override
    public String getReferenceTensor() {
        return this.size.getReferenceTensor();
    }

    @Override
    public String getReferenceAxis() {
        return this.size.getReferenceAxis();
    }

    public Map<String, Object> getOriginalDescription() {
        return this.originalDescription;
    }
}

