/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.bioimageio.description.Author;
import io.bioimage.modelrunner.bioimageio.description.Badge;
import io.bioimage.modelrunner.bioimageio.description.Cite;
import io.bioimage.modelrunner.bioimageio.description.ExecutionConfig;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.bioimageio.description.weights.ModelWeight;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ModelDescriptor {
    protected String format_version;
    protected String name;
    protected String download_url;
    protected String timestamp;
    protected String description;
    protected String type;
    protected String git_repo;
    protected List<Author> authors;
    protected List<Author> maintainers;
    protected List<Author> packaged_by;
    protected List<Cite> cite;
    protected List<String> tags;
    protected String license;
    protected String documentation;
    protected List<Badge> badges;
    protected List<String> covers;
    protected List<TensorSpec> input_tensors;
    protected List<TensorSpec> output_tensors;
    protected ExecutionConfig config;
    protected ModelWeight weights;
    protected List<String> attachments;
    protected String version;
    protected List<String> links;
    protected static String fromLocalKey = "fromLocalRepo";
    protected static String modelPathKey = "modelPath";
    protected String modelID;
    protected String localModelPath;
    protected boolean supportBioengine = false;
    protected Map<String, Object> yamlElements;
    protected static final String TEXT_DESCRIPTION = "<html><body><h3>%s</h3><p><strong>Nickname:</strong> %s</p><p><strong>Description:</strong> %s</p><p><strong>Author(s):</strong></p>%s<p><strong>Citation:</strong></p>%s</body></html>";
    protected static final String TEXT_DESCRIPTION_LOCAL = "<html><body><h3>%s</h3><p><strong>Nickname:</strong> %s</p><p><strong>Description:</strong> %s</p><p><strong>Folder name:</strong> %s</p><p><strong>Author(s):</strong></p>%s<p><strong>Citation:</strong></p>%s</body></html>";
    public static final String STARDIST = "stardist";
    public static final String BIOIMAGEIO = "bioimage.io";
    public static final String CELLPOSE = "cellpose";

    public abstract String getNickname();

    public abstract boolean areRequirementsInstalled();

    public abstract String getModelFamily();

    protected abstract List<TensorSpec> buildInputTensors();

    protected abstract List<TensorSpec> buildOutputTensors();

    protected abstract List<String> buildAttachments();

    protected abstract void calculateTotalInputHalo();

    protected abstract String findID();

    protected abstract void addBioEngine();

    protected void buildModelDescription() {
        Set<String> yamlFields = this.yamlElements.keySet();
        String[] yamlFieldsArr = new String[yamlFields.size()];
        Arrays.sort(yamlFields.toArray(yamlFieldsArr));
        String[] stringArray = yamlFieldsArr;
        int n = stringArray.length;
        block36: for (int i = 0; i < n; ++i) {
            String field;
            switch (field = stringArray[i]) {
                case "format_version": {
                    this.format_version = (String)this.yamlElements.get(field);
                    continue block36;
                }
                case "name": {
                    this.name = (String)this.yamlElements.get(field);
                    continue block36;
                }
                case "timestamp": {
                    this.timestamp = this.yamlElements.get(field).toString();
                    continue block36;
                }
                case "description": {
                    this.description = (String)this.yamlElements.get(field);
                    continue block36;
                }
                case "id": {
                    this.modelID = (String)this.yamlElements.get(field);
                    continue block36;
                }
                case "authors": {
                    this.authors = this.buildAuthors(this.yamlElements.get(field));
                    continue block36;
                }
                case "maintainers": {
                    this.maintainers = this.buildAuthors(this.yamlElements.get(field));
                    continue block36;
                }
                case "packaged_by": {
                    this.packaged_by = this.buildAuthors(this.yamlElements.get(field));
                    continue block36;
                }
                case "tags": {
                    this.tags = ModelDescriptor.castListStrings(this.yamlElements.get(field));
                    continue block36;
                }
                case "links": {
                    this.links = ModelDescriptor.castListStrings(this.yamlElements.get(field));
                    continue block36;
                }
                case "license": {
                    this.license = (String)this.yamlElements.get(field);
                    continue block36;
                }
                case "documentation": {
                    this.documentation = (String)this.yamlElements.get(field);
                    continue block36;
                }
                case "git_repo": {
                    this.git_repo = (String)this.yamlElements.get(field);
                    continue block36;
                }
                case "type": {
                    this.type = (String)this.yamlElements.get(field);
                    continue block36;
                }
                case "covers": {
                    this.covers = ModelDescriptor.castListStrings(this.yamlElements.get(field));
                    continue block36;
                }
                case "modelPath": {
                    this.localModelPath = (String)this.yamlElements.get(field);
                    continue block36;
                }
            }
        }
        this.cite = this.buildCiteElements();
        this.input_tensors = this.buildInputTensors();
        this.output_tensors = this.buildOutputTensors();
        this.weights = this.buildWeights();
        this.config = this.buildConfig();
        this.attachments = this.buildAttachments();
        this.calculateTotalInputHalo();
        this.addBioEngine();
        if (this.localModelPath != null) {
            this.addModelPath(new File(this.localModelPath).toPath());
        }
    }

    protected List<Author> buildAuthors(Object object) {
        ArrayList<Author> authors = new ArrayList<Author>();
        if (object == null || !(object instanceof List)) {
            this.authors = authors;
            return authors;
        }
        for (Object elem : (List)object) {
            if (!(elem instanceof Map)) continue;
            Map dict = (Map)elem;
            authors.add(Author.build((String)dict.get("affiliation"), (String)dict.get("email"), (String)dict.get("github_user"), (String)dict.get("name"), (String)dict.get("orcid")));
        }
        return authors;
    }

    protected List<Cite> buildCiteElements() {
        Object citeElements = this.yamlElements.get("cite");
        ArrayList<Cite> cites = new ArrayList<Cite>();
        if (citeElements == null || !(citeElements instanceof List)) {
            this.cite = cites;
            return cites;
        }
        for (Object elem : (List)citeElements) {
            if (!(elem instanceof Map)) continue;
            Map dict = (Map)elem;
            cites.add(Cite.build((String)dict.get("text"), (String)dict.get("doi"), (String)dict.get("url")));
        }
        return cites;
    }

    protected ModelWeight buildWeights() {
        return ModelWeight.build((Map)this.yamlElements.get("weights"));
    }

    protected ExecutionConfig buildConfig() {
        return ExecutionConfig.build((Map)this.yamlElements.get("config"));
    }

    public String buildInfo() {
        String authorNames = "<ul>";
        for (Author auth : this.authors) {
            authorNames = authorNames + "<li>" + auth.getName() + "</li>";
        }
        authorNames = authorNames + "</ul>";
        String citation = "<ul>";
        if (this.cite == null) {
            this.cite = new ArrayList<Cite>();
        }
        for (Cite ci : this.cite) {
            if (ci.getUrl() != null && ci.getText() != null) {
                citation = citation + "<li><a href='" + ci.getUrl() + "'>" + ci.getText() + "</a></li>";
                continue;
            }
            if (ci.getText() == null) continue;
            citation = citation + "<li>" + ci.getText() + "</li>";
        }
        citation = citation + "</ul>";
        if (this.isModelInLocalRepo()) {
            return String.format(TEXT_DESCRIPTION_LOCAL, this.name, this.getNickname(), this.description, new File(this.localModelPath).getName(), authorNames, citation);
        }
        return String.format(TEXT_DESCRIPTION, this.name, this.getNickname(), this.description, authorNames, citation);
    }

    public String getFormatVersion() {
        return this.format_version;
    }

    public String getName() {
        return this.name;
    }

    public String getModelID() {
        return this.modelID;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public List<Cite> getCite() {
        return this.cite;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getLicense() {
        return this.license;
    }

    public String getType() {
        return this.type;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<String> getCovers() {
        return this.covers;
    }

    public List<TensorSpec> getInputTensors() {
        return this.input_tensors;
    }

    public String getGitRepo() {
        return this.git_repo;
    }

    public TensorSpec findInputTensor(String name) {
        if (this.input_tensors == null) {
            return null;
        }
        return this.input_tensors.stream().filter(t -> t.getName().equals(name)).findAny().orElse(null);
    }

    public TensorSpec findOutputTensor(String name) {
        if (this.output_tensors == null) {
            return null;
        }
        return this.output_tensors.stream().filter(t -> t.getName().equals(name)).findAny().orElse(null);
    }

    public static TensorSpec findTensorInList(String name, List<TensorSpec> tts) {
        if (tts == null) {
            return null;
        }
        return tts.stream().filter(t -> t.getName().equals(name)).findAny().orElse(null);
    }

    public List<TensorSpec> getOutputTensors() {
        return this.output_tensors;
    }

    public ExecutionConfig getConfig() {
        return this.config;
    }

    public ModelWeight getWeights() {
        return this.weights;
    }

    public List<Author> getMaintainers() {
        return this.maintainers;
    }

    public List<Author> getPackagedBy() {
        return this.packaged_by;
    }

    public List<Badge> getBadges() {
        if (this.badges == null) {
            this.badges = new ArrayList<Badge>();
        }
        return this.badges;
    }

    public List<String> getAttachments() {
        return this.attachments;
    }

    public String getRDFSource() {
        return this.getModelURL() + "rdf.yaml";
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getLinks() {
        return this.links;
    }

    public boolean isModelInLocalRepo() {
        if (this.localModelPath == null) {
            return false;
        }
        return new File(this.localModelPath).isDirectory();
    }

    public String getModelPath() {
        return this.localModelPath;
    }

    public void addModelPath(Path modelBasePath) {
        this.localModelPath = modelBasePath.toFile().getAbsolutePath();
    }

    public boolean isTilingAllowed() {
        if (this.config == null) {
            return true;
        }
        if (this.config.getDeepImageJ() == null) {
            return true;
        }
        return this.getConfig().getDeepImageJ().isAllowTiling();
    }

    public boolean isPyramidal() {
        if (this.config == null) {
            return false;
        }
        if (this.config.getDeepImageJ() == null) {
            return false;
        }
        return this.getConfig().getDeepImageJ().isPyramidalModel();
    }

    public boolean canRunOnBioengine() {
        return this.supportBioengine;
    }

    public String getModelURL() {
        if (this.download_url == null) {
            this.download_url = BioimageioRepo.getModelRdfUrl(this.modelID, this.version);
        }
        return this.download_url;
    }

    public boolean isStardist() {
        return ModelDescriptorFactory.isStardist(this.yamlElements);
    }

    public boolean isCellpose() {
        return ModelDescriptorFactory.isCellpose(this.yamlElements);
    }

    private static List<String> castListStrings(Object list) {
        List<String> out = null;
        if (list instanceof List) {
            out = new ArrayList<String>();
            out = (List)list;
        } else if (list instanceof String) {
            out = new ArrayList();
            out.add((String)list);
        }
        return out;
    }

    public String toString() {
        return "ModelDescription {formatVersion=" + this.format_version + ", name=" + this.name + ", timestamp=" + this.timestamp + ", description=" + this.description + ", authors=" + this.authors + ", cite=" + this.cite + ", gitRepo=" + this.git_repo + ", tags=" + this.tags + ", license=" + this.license + ", documentation=" + this.documentation + ", covers=" + this.covers + ", inputTensors=" + this.input_tensors + ", outputTensors=" + this.output_tensors + ", config=" + this.config + ", weights=" + this.weights + "}";
    }
}

