/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.tiling;

import java.util.Arrays;

public class PatchSpec {
    private long[] nonTiledTensorDims;
    private long[] patchInputSize;
    private int[] patchGridSize;
    private int[][] patchPaddingSize;
    private String tensorName;

    protected static PatchSpec create(String tensorName, long[] patchInputSize, int[] patchGridSize, int[][] patchPaddingSize, long[] nonTiledTensorDims) {
        PatchSpec ps = new PatchSpec();
        ps.patchInputSize = patchInputSize;
        ps.patchGridSize = patchGridSize;
        ps.patchPaddingSize = patchPaddingSize;
        ps.tensorName = tensorName;
        ps.nonTiledTensorDims = nonTiledTensorDims;
        return ps;
    }

    private PatchSpec() {
    }

    protected String getTensorName() {
        return this.tensorName;
    }

    protected long[] getNonTiledTensorDims() {
        return this.nonTiledTensorDims;
    }

    protected long[] getTileSize() {
        return this.patchInputSize;
    }

    protected int[] getTileGrid() {
        return this.patchGridSize;
    }

    protected int[][] getPadding() {
        return this.patchPaddingSize;
    }

    public String toString() {
        Object[] paddingStrArr = new String[this.patchPaddingSize[0].length];
        for (int i = 0; i < paddingStrArr.length; ++i) {
            paddingStrArr[i] = this.patchPaddingSize[0][i] + "," + this.patchPaddingSize[1][i];
        }
        StringBuilder builder = new StringBuilder();
        builder.append("PatchSpec of '" + this.tensorName + "'[patchInputSize=").append(Arrays.toString(this.patchInputSize)).append(", patchGridSize=").append(Arrays.toString(this.patchGridSize)).append(", patchPaddingSize=").append(Arrays.toString(paddingStrArr)).append("]");
        return builder.toString();
    }
}

