/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.tiling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TileInfo {
    private long[] halo;
    private String haloAxesOrder;
    private final String name;
    private final long[] imDims;
    private final long[] proposedTileDims;
    private final String imAxesOrder;
    private final String tileAxesOrder;

    private TileInfo(String tensorName, long[] imDims, String imAxesOrder, long[] proposedTileDims, String tileAxesOrder) {
        this.name = tensorName;
        this.imAxesOrder = imAxesOrder;
        this.imDims = imDims;
        this.proposedTileDims = proposedTileDims;
        this.tileAxesOrder = tileAxesOrder;
        this.halo = new long[imAxesOrder.length()];
    }

    public static TileInfo build(String tensorName, long[] imDims, String imAxesOrder, long[] proposedTileDims, String tileAxesOrder) {
        return new TileInfo(tensorName, imDims, imAxesOrder, proposedTileDims, tileAxesOrder);
    }

    public String getName() {
        return this.name;
    }

    public long[] getImageDims() {
        return this.imDims;
    }

    public long[] getTileDims() {
        return this.proposedTileDims;
    }

    public String getImageAxesOrder() {
        return this.imAxesOrder;
    }

    public String getTileAxesOrder() {
        return this.tileAxesOrder;
    }

    public long[] getHalo() {
        return this.halo;
    }

    public String getHaloAxesOrder() {
        return this.haloAxesOrder;
    }

    public void setHalo(long[] halo, String haloAxesOrder) {
        if (halo.length != haloAxesOrder.length()) {
            throw new IllegalArgumentException("The halo array and axes order should have the same length: " + Arrays.asList(new long[][]{halo}) + " (" + halo.length + ") vs " + haloAxesOrder + "(" + haloAxesOrder.length() + ").");
        }
        for (String ax : haloAxesOrder.split("")) {
            if (this.tileAxesOrder.toLowerCase().contains(ax.toLowerCase())) continue;
            throw new IllegalArgumentException("Dimension '" + ax + "' is not present in the tile axes order (" + this.tileAxesOrder + ")");
        }
        this.halo = halo;
        this.haloAxesOrder = haloAxesOrder;
    }

    public static void adaptHalos(List<TileInfo> tiles) {
        String axesOrder = "";
        ArrayList<Long> halo = new ArrayList<Long>();
        ArrayList<Long> dims = new ArrayList<Long>();
        for (TileInfo tile : tiles) {
            for (String ax : tile.haloAxesOrder.split("")) {
                if (axesOrder.indexOf(ax) != -1) continue;
                axesOrder = axesOrder + ax;
                halo.add(-1L);
                dims.add(-1L);
            }
            int c = 0;
            for (String ax : tile.haloAxesOrder.split("")) {
                int ind = axesOrder.indexOf(ax);
                int ind2 = tile.tileAxesOrder.indexOf(ax);
                if ((Long)halo.get(ind) == -1L) {
                    halo.set(ind, tile.getHalo()[c]);
                    dims.set(ind, tile.getTileDims()[ind2]);
                    continue;
                }
                Long hh = (Long)halo.get(ind);
                Long dd = (Long)dims.get(ind);
                double ratio = (double)dd.longValue() / (double)tile.getTileDims()[ind2];
                double nh = Math.floor((double)tile.getHalo()[c] * ratio);
                if (nh < (double)hh.longValue()) {
                    tile.halo[c] = (long)Math.floor((double)hh.longValue() / ratio);
                    continue;
                }
                if (!(nh > (double)hh.longValue())) continue;
                tile.halo[c] = (long)nh;
            }
        }
    }
}

