/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.download;

import io.bioimage.modelrunner.download.FileDownloader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class MultiFileDownloader {
    private final List<URL> urls;
    private final File folder;
    private final List<FileDownloader> downloaders;
    private final Thread thread;
    private final long totalSize;
    private AtomicLong progressSize = new AtomicLong(0L);
    private Consumer<Long> totalProgress;
    private Consumer<Double> partialProgress;

    public MultiFileDownloader(List<URL> urls, File folder) {
        this(urls, folder, Thread.currentThread());
    }

    public MultiFileDownloader(List<URL> urls, File folder, Thread thread) {
        this.urls = urls;
        this.folder = folder;
        this.thread = thread;
        this.downloaders = new ArrayList<FileDownloader>();
        if (folder.exists() && folder.isFile()) {
            throw new IllegalArgumentException("A file with that name already exists. Please provide a valid folder name: " + folder.getAbsolutePath());
        }
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new RuntimeException("Unable to create folder in the path: " + folder.getAbsolutePath());
        }
        long size = 0L;
        for (URL url : urls) {
            try {
                String name = FileDownloader.getFileNameFromURLString(url.toString());
                FileDownloader fd = new FileDownloader(url.toString(), new File(folder, name), false);
                size += fd.getOnlineFileSize();
                this.downloaders.add(fd);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this.totalSize = size;
    }

    public File getFolder() {
        return this.folder;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getDownloadedBytes() {
        return this.progressSize.get();
    }

    public void setTotalProgressConsumer(Consumer<Long> totalProgress) {
        this.totalProgress = totalProgress;
    }

    public void setPartialProgressConsumer(Consumer<Double> partialProgress) {
        this.partialProgress = partialProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws ExecutionException, InterruptedException {
        ExecutorService downloadExecutor = Executors.newFixedThreadPool(3);
        ScheduledExecutorService monitorExecutor = Executors.newScheduledThreadPool(1);
        ArrayList<Future<Void>> downloadFutures = new ArrayList<Future<Void>>();
        for (FileDownloader fileDownloader : this.downloaders) {
            downloadFutures.add(downloadExecutor.submit(() -> {
                fd.download(this.thread);
                return null;
            }));
        }
        monitorExecutor.scheduleAtFixedRate(() -> this.monitorTotalProgress(downloadFutures), 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            for (Future future : downloadFutures) {
                future.get();
            }
        }
        finally {
            downloadExecutor.shutdown();
            monitorExecutor.shutdown();
        }
        this.finalProgress();
    }

    private void finalProgress() {
        AtomicLong total = new AtomicLong(0L);
        for (FileDownloader fd : this.downloaders) {
            total.addAndGet(fd.getSizeDownloaded());
        }
        if (this.totalProgress != null) {
            this.totalProgress.accept(total.get());
        }
        if (this.partialProgress != null) {
            this.partialProgress.accept((double)total.get() / (double)this.totalSize);
        }
        this.progressSize = total;
    }

    private void monitorTotalProgress(List<Future<Void>> downloadFutures) {
        if (!this.thread.isAlive()) {
            downloadFutures.stream().forEach(fut -> fut.cancel(true));
            return;
        }
        AtomicLong total = new AtomicLong(0L);
        for (FileDownloader fd : this.downloaders) {
            total.addAndGet(fd.getSizeDownloaded());
        }
        if (this.totalProgress != null) {
            this.totalProgress.accept(total.get());
        }
        if (this.partialProgress != null) {
            this.partialProgress.accept((double)total.get() / (double)this.totalSize);
        }
        this.progressSize = total;
    }

    public static String addTimeStampToFileName(String str, boolean isDir) {
        int extensionPos;
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMYYYY_HHmmss");
        String dateString = sdf.format(cal.getTime());
        if (isDir) {
            return str + "_" + dateString;
        }
        int ind = str.lastIndexOf(File.separator);
        String fileName = str;
        if (ind != -1) {
            fileName = str.substring(ind + 1);
        }
        if ((extensionPos = fileName.lastIndexOf(".")) == -1) {
            return str + "_" + dateString;
        }
        String nameNoExtension = str.substring(0, extensionPos);
        String extension = str.substring(extensionPos);
        return nameNoExtension + "_" + dateString + extension;
    }
}

