/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.engine;

import io.bioimage.modelrunner.bioimageio.description.weights.ModelWeight;
import io.bioimage.modelrunner.bioimageio.description.weights.WeightFormat;
import io.bioimage.modelrunner.bioimageio.download.DownloadModel;
import io.bioimage.modelrunner.engine.EngineLoader;
import io.bioimage.modelrunner.system.PlatformDetection;
import io.bioimage.modelrunner.versionmanagement.AvailableEngines;
import io.bioimage.modelrunner.versionmanagement.DeepLearningVersion;
import io.bioimage.modelrunner.versionmanagement.InstalledEngines;
import io.bioimage.modelrunner.versionmanagement.SupportedVersions;
import io.bioimage.modelrunner.versionmanagement.VersionStringUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class EngineInfo {
    private String engine;
    private String version;
    private String versionJava;
    private boolean gpu = false;
    private boolean cpu = true;
    private String os;
    private String tfTag;
    private String tfSigDef;
    private String jarsDirectory;
    private String serverURL;
    private static final String ENGINE_ERR = "The program will not be able to load '%s %s' because another version (%s) of the same framework has already been loaded." + System.lineSeparator() + "If loading the wanted version (%s) is strictly necessary, please restart the JVM. However, if the previously loaded version (%s) can be used, " + System.lineSeparator() + "please call EngineInfo.defineCompatibleDLEngine(...) to avoid restarting.";
    private static String STATIC_JARS_DIRECTORY;
    private SupportedVersions supportedVersions;
    private static final String TENSORFLOW_ENGINE_NAME = "tensorflow";
    private static final String PYTORCH_ENGINE_NAME = "pytorch";
    private static final String ONNX_ENGINE_NAME = "onnx";
    private static final String KERAS_ENGINE_NAME = "keras";
    private static String loadedTf1Version;
    private static String loadedTf2Version;
    private static String loadedPytorchVersion;
    private static String loadedOnnxVersion;

    private EngineInfo(String engine, String version, String jarsDirectory) {
        Objects.requireNonNull(engine, "The Deep Learning engine should not be null.");
        Objects.requireNonNull(version, "The Deep Learning engine version should not be null.");
        Objects.requireNonNull(jarsDirectory, "The Jars directory should not be null.");
        this.setFramework(engine);
        this.version = version;
        this.checkEngineAreadyLoaded();
        this.jarsDirectory = jarsDirectory;
        this.os = new PlatformDetection().toString();
        this.setSupportedVersions();
        this.versionJava = this.findCorrespondingJavaVersion();
        if (this.versionJava == null) {
            throw new IllegalArgumentException("The DL framework version chosen is not supported.");
        }
    }

    private EngineInfo(String serverURL) {
        Objects.requireNonNull(serverURL, "The Deep Learning engine version should not be null.");
        this.serverURL = serverURL;
    }

    private void checkEngineAreadyLoaded() throws IllegalArgumentException {
        boolean onnxLoaded;
        String versionedEngine = this.engine + this.getMajorVersion();
        boolean bl = onnxLoaded = EngineLoader.getLoadedVersions().keySet().stream().filter(en -> en.startsWith(ONNX_ENGINE_NAME) && !en.equals(versionedEngine)).findFirst().orElse(null) != null;
        if (this.engine.equals(ONNX_ENGINE_NAME) && onnxLoaded) {
            String confV = EngineLoader.getLoadedVersions().entrySet().stream().filter(en -> ((String)en.getKey()).startsWith(ONNX_ENGINE_NAME) && !((String)en.getKey()).equals(versionedEngine)).map(en -> (String)en.getValue()).findFirst().get();
            throw new IllegalArgumentException(String.format(ENGINE_ERR, this.engine, this.version, confV, this.version, confV));
        }
        if (!versionedEngine.equals("tensorflow2") && EngineLoader.getLoadedVersions().get(versionedEngine) != null && !EngineLoader.getLoadedVersions().get(versionedEngine).equals(this.version)) {
            throw new IllegalArgumentException(String.format(ENGINE_ERR, this.engine, this.version, EngineLoader.getLoadedVersions().get(versionedEngine), this.version, EngineLoader.getLoadedVersions().get(versionedEngine)));
        }
    }

    public static EngineInfo defineBioengine(String serverURL) throws IllegalArgumentException {
        if (!DownloadModel.checkURL(serverURL)) {
            throw new IllegalArgumentException("The provided url does not exist: " + serverURL);
        }
        return new EngineInfo(serverURL);
    }

    public static EngineInfo defineDLEngine(String framework, String version, String jarsDirectory) throws IllegalArgumentException {
        List<DeepLearningVersion> vs;
        Objects.requireNonNull(framework, "DL framework cannot be null.");
        Objects.requireNonNull(version, "DL framework version cannot be null.");
        if (AvailableEngines.modelRunnerToBioimageioKeysMap().keySet().contains(framework)) {
            framework = AvailableEngines.modelRunnerToBioimageioKeysMap().get(framework);
        }
        if ((vs = InstalledEngines.checkEngineWithArgsInstalledForOS(framework, version, null, null, jarsDirectory)).size() == 0) {
            String jV = SupportedVersions.getJavaVersionForPythonVersion(framework, version);
            if (jV == null) {
                return null;
            }
            return EngineInfo.defineDLEngineWithJavaVersion(framework, jV, null, null, jarsDirectory);
        }
        boolean cpu = false;
        boolean gpu = false;
        if (vs.stream().filter(v -> v.getCPU() && v.getGPU()).collect(Collectors.toList()).size() > 0) {
            cpu = true;
            gpu = true;
        } else if (vs.stream().filter(v -> v.getCPU()).collect(Collectors.toList()).size() > 0) {
            cpu = true;
        } else {
            gpu = true;
        }
        try {
            return EngineInfo.defineDLEngine(framework, vs.get(0).getPythonVersion(), cpu, gpu, jarsDirectory);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static EngineInfo defineDLEngine(String framework, String version, boolean gpu, String jarsDirectory) throws IllegalArgumentException {
        List<DeepLearningVersion> vs;
        Objects.requireNonNull(framework, "DL framework cannot be null.");
        Objects.requireNonNull(version, "DL framework version cannot be null.");
        if (AvailableEngines.modelRunnerToBioimageioKeysMap().keySet().contains(framework)) {
            framework = AvailableEngines.modelRunnerToBioimageioKeysMap().get(framework);
        }
        if ((vs = InstalledEngines.checkEngineWithArgsInstalledForOS(framework, version, null, gpu, jarsDirectory)).size() == 0) {
            String jV = SupportedVersions.getJavaVersionForPythonVersion(framework, version);
            if (jV == null) {
                return null;
            }
            return EngineInfo.defineDLEngineWithJavaVersion(framework, jV, null, gpu, jarsDirectory);
        }
        boolean cpu = false;
        if (vs.stream().filter(v -> v.getCPU()).collect(Collectors.toList()).size() > 0) {
            cpu = true;
        }
        return EngineInfo.defineDLEngine(framework, vs.get(0).getPythonVersion(), cpu, gpu, jarsDirectory);
    }

    public static EngineInfo defineDLEngine(String framework, String version, boolean cpu, boolean gpu, String jarsDirectory) throws IllegalArgumentException {
        List<DeepLearningVersion> vvs;
        Objects.requireNonNull(framework, "DL framework cannot be null.");
        Objects.requireNonNull(version, "DL framework version cannot be null.");
        if (AvailableEngines.modelRunnerToBioimageioKeysMap().keySet().contains(framework)) {
            framework = AvailableEngines.modelRunnerToBioimageioKeysMap().get(framework);
        }
        if ((vvs = InstalledEngines.checkEngineWithArgsInstalledForOS(framework, version, cpu, gpu, jarsDirectory)).size() == 0) {
            String jV = SupportedVersions.getJavaVersionForPythonVersion(framework, version);
            if (jV == null) {
                return null;
            }
            return EngineInfo.defineDLEngineWithJavaVersion(framework, jV, cpu, gpu, jarsDirectory);
        }
        EngineInfo engineInfo = new EngineInfo(framework, vvs.get(0).getPythonVersion(), jarsDirectory);
        engineInfo.cpu = cpu;
        engineInfo.gpu = gpu;
        return engineInfo;
    }

    public static EngineInfo defineDLEngine(String framework, String version) throws IllegalArgumentException {
        Objects.requireNonNull(STATIC_JARS_DIRECTORY, "The Jars directory should not be null.");
        return EngineInfo.defineDLEngine(framework, version, STATIC_JARS_DIRECTORY);
    }

    public static EngineInfo defineDLEngine(String framework, String version, boolean gpu) throws IllegalArgumentException {
        Objects.requireNonNull(framework, "DL framework cannot be null.");
        Objects.requireNonNull(version, "DL framework version cannot be null.");
        if (AvailableEngines.modelRunnerToBioimageioKeysMap().keySet().contains(framework)) {
            framework = AvailableEngines.modelRunnerToBioimageioKeysMap().get(framework);
        }
        Objects.requireNonNull(STATIC_JARS_DIRECTORY, "The Jars directory should not be null.");
        List<DeepLearningVersion> vs = InstalledEngines.checkEngineWithArgsInstalledForOS(framework, version, null, gpu, STATIC_JARS_DIRECTORY);
        if (vs.size() == 0) {
            String jV = SupportedVersions.getJavaVersionForPythonVersion(framework, version);
            if (jV == null) {
                return null;
            }
            return EngineInfo.defineDLEngineWithJavaVersion(framework, jV, null, gpu, STATIC_JARS_DIRECTORY);
        }
        boolean cpu = false;
        if (vs.stream().filter(v -> v.getCPU()).collect(Collectors.toList()).size() > 0) {
            cpu = true;
        }
        return EngineInfo.defineDLEngine(framework, vs.get(0).getPythonVersion(), cpu, gpu, STATIC_JARS_DIRECTORY);
    }

    public static EngineInfo defineDLEngine(String framework, String version, boolean cpu, boolean gpu) throws IllegalArgumentException {
        Objects.requireNonNull(STATIC_JARS_DIRECTORY, "The Jars directory should not be null.");
        return EngineInfo.defineDLEngine(framework, version, cpu, gpu, STATIC_JARS_DIRECTORY);
    }

    private static EngineInfo defineDLEngineWithJavaVersion(String framework, String javaVersion, Boolean cpu, Boolean gpu, String jarsDirectory) {
        Objects.requireNonNull(framework);
        Objects.requireNonNull(javaVersion);
        Objects.requireNonNull(jarsDirectory);
        List<DeepLearningVersion> vvs = InstalledEngines.checkEngineWithArgsInstalledForOS(framework, null, cpu, gpu, jarsDirectory);
        if (vvs.size() == 0) {
            return null;
        }
        List compVersions = vvs.stream().filter(vv -> vv.getVersion().equals(javaVersion)).collect(Collectors.toList());
        if (compVersions.size() == 0) {
            return null;
        }
        List cpuComp = compVersions.stream().filter(v -> v.getCPU() && (gpu == null || v.getGPU() == gpu.booleanValue())).collect(Collectors.toList());
        boolean ncpu = cpu == null && cpuComp.size() > 0 ? true : (cpu == null ? false : cpu);
        List gpuComp = compVersions.stream().filter(v -> v.getCPU() == ncpu && v.getGPU()).collect(Collectors.toList());
        boolean ngpu = gpu == null && gpuComp.size() != 0 ? true : (gpu == null ? false : gpu);
        String version = ((DeepLearningVersion)compVersions.stream().filter(v -> v.getCPU() == ncpu && v.getGPU() == ngpu).findFirst().orElse(null)).getPythonVersion();
        return EngineInfo.defineDLEngine(framework, version, ncpu, ngpu, jarsDirectory);
    }

    public static EngineInfo defineCompatibleDLEngineCPU(String framework, String version, String jarsDirectory) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(framework, "DL framework cannot be null.");
        Objects.requireNonNull(version, "DL framework version cannot be null.");
        Objects.requireNonNull(jarsDirectory, "The engine JARs directory cannot be null.");
        InstalledEngines manager = InstalledEngines.buildEnginesFinder(jarsDirectory);
        String compatibleVersion = manager.getMostCompatibleVersionForFramework(framework, version);
        if (compatibleVersion == null) {
            return null;
        }
        List<DeepLearningVersion> vv = manager.getDownloadedForVersionedFramework(framework, compatibleVersion);
        boolean gpu = vv.stream().filter(v -> v.getGPU()).findFirst().orElse(null) != null;
        return EngineInfo.defineDLEngine(framework, compatibleVersion, true, gpu, jarsDirectory);
    }

    public static EngineInfo defineCompatibleDLEngine(String framework, String version, boolean cpu, boolean gpu, String jarsDirectory) throws IllegalArgumentException {
        Objects.requireNonNull(framework, "DL framework cannot be null.");
        Objects.requireNonNull(version, "DL framework version cannot be null.");
        Objects.requireNonNull(jarsDirectory, "The engine JARs directory cannot be null.");
        List<DeepLearningVersion> possibles = InstalledEngines.checkEngineWithArgsInstalledForOS(framework, null, cpu, gpu, jarsDirectory);
        if (possibles.size() == 0) {
            return null;
        }
        List<String> possibleStrs = possibles.stream().map(DeepLearningVersion::getPythonVersion).collect(Collectors.toList());
        List<String> compatibleVersion = VersionStringUtils.getCompatibleEngineVersionsInOrder(version, possibleStrs, framework);
        if (compatibleVersion == null || compatibleVersion.size() == 0) {
            return null;
        }
        return EngineInfo.defineDLEngine(framework, compatibleVersion.get(0), cpu, gpu, jarsDirectory);
    }

    public static EngineInfo defineCompatibleDLEngineGPU(String framework, String version, String jarsDirectory) throws IllegalArgumentException {
        Objects.requireNonNull(framework, "DL framework cannot be null.");
        Objects.requireNonNull(version, "DL framework version cannot be null.");
        Objects.requireNonNull(jarsDirectory, "The engine JARs directory cannot be null.");
        List<DeepLearningVersion> possibles = InstalledEngines.checkEngineWithArgsInstalledForOS(framework, null, null, true, jarsDirectory);
        if (possibles.size() == 0) {
            return null;
        }
        List<String> possibleStrs = possibles.stream().map(DeepLearningVersion::getPythonVersion).collect(Collectors.toList());
        List<String> compatibleVersion = VersionStringUtils.getCompatibleEngineVersionsInOrder(version, possibleStrs, framework);
        if (compatibleVersion == null || compatibleVersion.size() == 0) {
            return null;
        }
        boolean cpu = InstalledEngines.checkEngineWithArgsInstalledForOS(framework, compatibleVersion.get(0), true, true, jarsDirectory).size() > 0;
        return EngineInfo.defineDLEngine(framework, compatibleVersion.get(0), cpu, true, jarsDirectory);
    }

    public static EngineInfo defineCompatibleDLEngineWithRdfYamlWeights(WeightFormat weight) throws IOException, IllegalArgumentException {
        return EngineInfo.defineCompatibleDLEngineWithRdfYamlWeights(weight, InstalledEngines.getEnginesDir());
    }

    public static EngineInfo defineCompatibleDLEngineWithRdfYamlWeights(WeightFormat weight, String enginesDir) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(weight, "DL weigths cannot be null.");
        Objects.requireNonNull(enginesDir, "The engine JARs directory cannot be null.");
        String compatibleVersion = null;
        String engine = weight.getFramework();
        String version = weight.getTrainingVersion();
        InstalledEngines manager = InstalledEngines.buildEnginesFinder(enginesDir);
        compatibleVersion = manager.getMostCompatibleVersionForFramework(engine, version);
        if (compatibleVersion == null) {
            return null;
        }
        List<DeepLearningVersion> vv = manager.getDownloadedForVersionedFramework(engine, compatibleVersion);
        boolean gpu = vv.stream().filter(v -> v.getGPU()).findFirst().orElse(null) != null;
        return EngineInfo.defineDLEngine(engine, compatibleVersion, true, gpu, enginesDir);
    }

    public static EngineInfo defineExactDLEngineWithRdfYamlWeights(WeightFormat weight) throws IOException, IllegalArgumentException {
        return EngineInfo.defineExactDLEngineWithRdfYamlWeights(weight, InstalledEngines.getEnginesDir());
    }

    public static EngineInfo defineExactDLEngineWithRdfYamlWeights(WeightFormat weight, String enginesDir) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(weight, "DL weigths cannot be null.");
        Objects.requireNonNull(enginesDir, "The engine JARs directory cannot be null.");
        String engine = weight.getFramework();
        String version = weight.getTrainingVersion();
        InstalledEngines manager = InstalledEngines.buildEnginesFinder(enginesDir);
        if (version == null) {
            return null;
        }
        List<DeepLearningVersion> vv = manager.getDownloadedForVersionedFramework(engine, version);
        if (vv.size() == 0) {
            return null;
        }
        boolean gpu = vv.stream().filter(v -> v.getGPU()).findFirst().orElse(null) != null;
        return EngineInfo.defineDLEngine(engine, vv.get(0).getPythonVersion(), true, gpu, enginesDir);
    }

    public String getDeepLearningVersionJarsDirectory() {
        String vv = this.engine + "-" + this.version + "-" + this.versionJava + "-" + this.os + (this.cpu ? "-cpu" : "") + (this.gpu ? "-gpu" : "");
        return this.jarsDirectory + File.separator + vv;
    }

    private String findCorrespondingJavaVersion() {
        return this.supportedVersions.getCorrespondingJavaVersion(this.version);
    }

    private void setSupportedVersions() {
        this.supportedVersions = new SupportedVersions(this.engine);
    }

    public String getFramework() {
        return this.engine;
    }

    private void setFramework(String engine) {
        if (engine.contentEquals(ModelWeight.getTensorflowID())) {
            this.engine = TENSORFLOW_ENGINE_NAME;
        } else if (engine.contentEquals(ModelWeight.getTorchscriptID())) {
            this.engine = PYTORCH_ENGINE_NAME;
        } else if (engine.contentEquals(ModelWeight.getOnnxID())) {
            this.engine = ONNX_ENGINE_NAME;
        }
    }

    public String getJarsDirectory() {
        return this.jarsDirectory;
    }

    public void setTags(String tag, String sigDef) {
        if (this.engine.contentEquals(TENSORFLOW_ENGINE_NAME)) {
            this.tfTag = tag;
            this.tfSigDef = sigDef;
        }
    }

    public String getTfSigDef() {
        return this.tfSigDef;
    }

    public String getTfTag() {
        return this.tfTag;
    }

    public String getVersion() {
        return this.version;
    }

    public String getJavaVersion() {
        return this.versionJava;
    }

    public boolean isGPU() {
        return this.gpu;
    }

    public boolean isCPU() {
        return this.cpu;
    }

    public String getOS() {
        return this.os;
    }

    public static String getLoadedVersions(String framework, String version) throws IllegalArgumentException {
        if (framework.equals(ModelWeight.getTensorflowID()) && version.startsWith("1")) {
            return loadedTf1Version;
        }
        if (framework.equals(ModelWeight.getTensorflowID()) && version.startsWith("2")) {
            return loadedTf2Version;
        }
        if (framework.equals(ModelWeight.getTorchscriptID())) {
            return loadedPytorchVersion;
        }
        if (framework.equals(ModelWeight.getOnnxID())) {
            return loadedOnnxVersion;
        }
        throw new IllegalArgumentException("The selected engine '" + framework + "' is not supported yet.");
    }

    public String getMajorVersion() {
        int ind = this.version.indexOf(".");
        String majorVersion = "" + this.version;
        if (ind != -1) {
            majorVersion = this.version.substring(0, ind);
        }
        return majorVersion;
    }

    private boolean isEngineInstalled() {
        File file = new File(this.getDeepLearningVersionJarsDirectory());
        try {
            boolean missingJars;
            boolean bl = missingJars = DeepLearningVersion.fromFile(file).checkMissingJars().size() == 0;
            if (!missingJars) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isBioengine() {
        return this.serverURL != null;
    }

    public String getServer() {
        if (!this.isBioengine()) {
            throw new IllegalArgumentException("The Bioengine server can only be retrieved if the method EngineInfo.defineBioengine(String) has been used to create the object.");
        }
        return this.serverURL;
    }

    public static void setStaticJarsDirectory(String jarsDirectory) {
        STATIC_JARS_DIRECTORY = jarsDirectory;
    }

    public static String getTensorflowKey() {
        return TENSORFLOW_ENGINE_NAME;
    }

    public static String getPytorchKey() {
        return PYTORCH_ENGINE_NAME;
    }

    public static String getOnnxKey() {
        return ONNX_ENGINE_NAME;
    }

    public static String getKerasKey() {
        return KERAS_ENGINE_NAME;
    }

    public static String getBioimageioTfKey() {
        return ModelWeight.getTensorflowID();
    }

    public static String getBioimageioPytorchKey() {
        return ModelWeight.getTorchscriptID();
    }

    public static String getBioimageioOnnxKey() {
        return ModelWeight.getOnnxID();
    }

    public static String getBioimageioKerasKey() {
        return ModelWeight.getKerasID();
    }
}

