/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.engine;

import io.bioimage.modelrunner.apposed.appose.Types;
import io.bioimage.modelrunner.engine.DeepLearningEngineInterface;
import io.bioimage.modelrunner.engine.EngineInfo;
import io.bioimage.modelrunner.engine.ParentLastURLClassLoader;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.versionmanagement.DeepLearningVersion;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class EngineLoader
extends ClassLoader {
    private ClassLoader engineClassloader;
    private ClassLoader baseClassloader;
    private String enginePath;
    private String engine;
    private String versionedEngine;
    private DeepLearningEngineInterface engineInstance;
    private static final String ENGINE_INTERFACE_NAME = "io.bioimage.modelrunner.engine.DeepLearningEngineInterface";
    private static HashMap<String, ClassLoader> loadedEngines = new HashMap();
    private static HashMap<String, String> loadedVersions = new HashMap();

    private EngineLoader(ClassLoader classloader, EngineInfo engineInfo) throws LoadEngineException, MalformedURLException, IllegalStateException, IOException {
        this.baseClassloader = classloader;
        this.engine = engineInfo.getFramework();
        this.enginePath = engineInfo.getDeepLearningVersionJarsDirectory();
        this.versionedEngine = this.engine + engineInfo.getMajorVersion();
        this.loadClasses();
        this.setEngineClassLoader();
        this.setEngineInstance();
        this.setBaseClassLoader();
    }

    public static EngineLoader createEngine(ClassLoader classloader, EngineInfo engineInfo) throws MalformedURLException, IllegalStateException, LoadEngineException, IOException {
        return new EngineLoader(classloader, engineInfo);
    }

    private void loadClasses() throws MalformedURLException, IllegalStateException, IOException {
        if (loadedEngines.get(this.versionedEngine) != null && !this.versionedEngine.equals("tensorflow2")) {
            this.engineClassloader = loadedEngines.get(this.versionedEngine);
            return;
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (!new File(this.enginePath).isDirectory()) {
            throw new IllegalArgumentException("Engine directory does not exist: " + this.enginePath);
        }
        DeepLearningVersion dlv = DeepLearningVersion.fromFile(new File(this.enginePath));
        for (File ff : new File(this.enginePath).listFiles()) {
            if (!ff.getName().endsWith(".jar") || !dlv.doesJarBelongToEngine(ff.getAbsolutePath())) continue;
            urlList.add(ff.toURI().toURL());
        }
        URL[] urls = new URL[urlList.size()];
        urlList.toArray(urls);
        this.engineClassloader = new ParentLastURLClassLoader(urls, this.baseClassloader);
        loadedEngines.put(this.versionedEngine, this.engineClassloader);
        loadedVersions.put(this.versionedEngine, dlv.getPythonVersion());
    }

    public void setEngineClassLoader() {
        Thread.currentThread().setContextClassLoader(this.engineClassloader);
    }

    public void setBaseClassLoader() {
        Thread.currentThread().setContextClassLoader(this.baseClassloader);
    }

    private static DeepLearningEngineInterface getEngineClassFromEntries(Enumeration<? extends ZipEntry> entries, ClassLoader engineClassloader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String file = entry.getName();
            if (!file.endsWith(".class") || file.contains("$") || file.contains("-")) continue;
            String className = EngineLoader.getClassNameInJAR(file);
            Class<?> c = engineClassloader.loadClass(className);
            Class<?>[] intf = c.getInterfaces();
            for (int j = 0; j < intf.length; ++j) {
                if (!intf[j].getName().equals(ENGINE_INTERFACE_NAME)) continue;
                return (DeepLearningEngineInterface)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            intf = null;
            c = null;
        }
        return null;
    }

    private static String getClassNameInJAR(String entryName) {
        String className = entryName.substring(0, entryName.indexOf("."));
        className = className.replace("/", ".");
        return className;
    }

    private void setEngineInstance() throws LoadEngineException {
        String jarPrefix = "dl-modelrunner-" + this.engine;
        DeepLearningVersion dlv = null;
        try {
            dlv = DeepLearningVersion.fromFile(new File(this.enginePath));
        }
        catch (IOException | IllegalStateException exception) {
            // empty catch block
        }
        String errMsg = "Missing " + jarPrefix + " jar file that implements the 'DeepLearningInterface";
        try {
            for (File ff : new File(this.enginePath).listFiles()) {
                if (!ff.getName().endsWith(".jar") || !ff.getName().startsWith(jarPrefix + "-") || !dlv.doesJarBelongToEngine(ff.getAbsolutePath())) continue;
                ZipFile jarFile = new ZipFile(ff);
                Enumeration<? extends ZipEntry> entries = jarFile.entries();
                this.engineInstance = EngineLoader.getEngineClassFromEntries(entries, this.engineClassloader);
                if (this.engineInstance != null) {
                    jarFile.close();
                    return;
                }
                jarFile.close();
            }
        }
        catch (Error | Exception ex) {
            errMsg = Types.stackTrace(ex);
        }
        throw new LoadEngineException(new File(this.enginePath), errMsg);
    }

    public DeepLearningEngineInterface getEngineInstance() {
        return this.engineInstance;
    }

    public void close() {
        this.engineInstance.closeModel();
        this.setBaseClassLoader();
    }

    public static HashMap<String, String> getLoadedVersions() {
        return loadedVersions;
    }
}

