/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.engine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class ParentLastURLClassLoader
extends URLClassLoader {
    private ClassLoader helper;

    public ParentLastURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, (ClassLoader)null);
        this.helper = parent;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.loadClassFromParent(name, resolve);
            }
            catch (SecurityException e) {
                c = this.loadClassFromParent(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private Class<?> loadClassFromParent(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        try {
            c = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            c = this.loadClassFromSystem(name);
        }
        catch (SecurityException e) {
            c = this.loadClassFromSystem(name);
        }
        return c;
    }

    private Class<?> loadClassFromSystem(String name) throws ClassNotFoundException {
        Class<?> c = null;
        if (this.helper != null) {
            c = this.helper.loadClass(name);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        if (url == null && this.helper != null) {
            url = this.helper.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls;
        block6: {
            Enumeration<URL> parentUrls;
            Enumeration<URL> localUrls;
            Enumeration<URL> systemUrls;
            block7: {
                block5: {
                    systemUrls = null;
                    if (this.helper != null) {
                        systemUrls = this.helper.getResources(name);
                    }
                    localUrls = this.findResources(name);
                    parentUrls = null;
                    if (this.getParent() != null) {
                        parentUrls = this.getParent().getResources(name);
                    }
                    urls = new ArrayList<URL>();
                    if (localUrls == null) break block5;
                    while (localUrls.hasMoreElements()) {
                        URL local = localUrls.nextElement();
                        urls.add(local);
                    }
                    break block6;
                }
                if (parentUrls == null || localUrls != null) break block7;
                while (parentUrls.hasMoreElements()) {
                    urls.add(parentUrls.nextElement());
                }
                break block6;
            }
            if (systemUrls == null || localUrls != null || parentUrls != null) break block6;
            while (systemUrls.hasMoreElements()) {
                urls.add(systemUrls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

