/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.engine.installation;

import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.bioimageio.description.exceptions.ModelSpecsException;
import io.bioimage.modelrunner.bioimageio.description.weights.WeightFormat;
import io.bioimage.modelrunner.download.MultiFileDownloader;
import io.bioimage.modelrunner.engine.EngineInfo;
import io.bioimage.modelrunner.system.PlatformDetection;
import io.bioimage.modelrunner.versionmanagement.AvailableEngines;
import io.bioimage.modelrunner.versionmanagement.DeepLearningVersion;
import io.bioimage.modelrunner.versionmanagement.InstalledEngines;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class EngineInstall {
    private static final String ENGINES_DIR = new File("engines").getAbsolutePath();
    public static LinkedHashMap<String, String> ENGINES_VERSIONS = new LinkedHashMap();
    public static final String NBYTES_SUFFIX = "_SIZE";
    private static final Map<String, String> ENGINES_MAP;
    private static final String GENERAL_KEYWORD = "-general";
    public static final String PROGRESS_ENGINE_KEYWORD = "Engine: ";
    private boolean everythingInstalled = false;
    private LinkedHashMap<String, String> missingEngineFolders;
    private boolean isManagementFinished = false;
    private String managersDir;
    private boolean readJSon = false;
    private Consumer<Double> consumer;
    private Consumer<String> strConsumer;
    private long downloaded = 0L;

    private EngineInstall() {
    }

    public static EngineInstall createInstaller() {
        EngineInstall manager = new EngineInstall();
        manager.managersDir = ENGINES_DIR;
        return manager;
    }

    public static EngineInstall createInstaller(String dir) {
        EngineInstall manager = new EngineInstall();
        manager.managersDir = dir;
        return manager;
    }

    public void setProgresConsumer(Consumer<Double> consumer) {
        this.consumer = consumer;
    }

    public void setEngineInstalledConsumer(Consumer<String> strConsumer) {
        this.strConsumer = strConsumer;
    }

    public void checkBasicEngineInstallation() {
        this.everythingInstalled = false;
        this.isManagementFinished = false;
        this.readEnginesJSON();
        this.checkEnginesInstalled();
    }

    public void basicEngineInstallation() throws InterruptedException {
        if (!this.everythingInstalled) {
            this.manageMissingEngines();
        }
        this.isManagementFinished = true;
    }

    public Map<String, String> getNotInstalledMainEngines() {
        if (this.missingEngineFolders == null) {
            this.checkEnginesInstalled();
        }
        return this.missingEngineFolders;
    }

    public ArrayList<String> getMissingEngines() {
        if (this.missingEngineFolders == null) {
            this.checkEnginesInstalled();
        }
        return new ArrayList<String>(this.missingEngineFolders.keySet());
    }

    private void readEnginesJSON() {
        Map<String, String> versionsNotInRequired = EngineInstall.getListOfSingleVersionsPerFrameworkNotInRequired();
        List uniqueFrameworks = versionsNotInRequired.keySet().stream().map(f -> f.substring(0, f.lastIndexOf("_"))).distinct().collect(Collectors.toList());
        Comparator versionComparator = (v1, v2) -> DeepLearningVersion.stringVersionComparator(v1, v2) * -1;
        for (String f2 : uniqueFrameworks) {
            String selectedVersion = versionsNotInRequired.entrySet().stream().filter(v -> ((String)v.getKey()).startsWith(f2 + "_")).map(v -> (String)v.getValue()).max(versionComparator).orElse(null);
            ENGINES_VERSIONS.put(f2 + "_" + selectedVersion.substring(0, selectedVersion.indexOf(".")), selectedVersion);
        }
        this.readJSon = true;
    }

    public static Map<String, String> getListOfSingleVersionsPerFrameworkNotInRequired() {
        List vList = AvailableEngines.getForCurrentOS().stream().filter(v -> !v.getFramework().startsWith(EngineInfo.getOnnxKey()) && !ENGINES_VERSIONS.keySet().contains(v.getFramework() + "_" + v.getPythonVersion().substring(0, v.getPythonVersion().indexOf("."))) && v.getOs().equals(new PlatformDetection().toString())).collect(Collectors.groupingBy(DeepLearningVersion::getPythonVersion)).values().stream().flatMap(sizeGroup -> {
            List uniquePythonVersions = sizeGroup.stream().filter(v -> sizeGroup.stream().noneMatch(otherV -> v != otherV && v.getPythonVersion().equals(otherV.getPythonVersion()))).collect(Collectors.toList());
            List guVersions = sizeGroup.stream().filter(obj -> obj.getGPU()).limit(1L).collect(Collectors.toList());
            uniquePythonVersions.addAll(guVersions);
            return uniquePythonVersions.stream();
        }).distinct().collect(Collectors.toList());
        Map<String, String> versionsNotInRequired = vList.stream().collect(Collectors.toMap(v -> v.getFramework() + "_" + v.getPythonVersion(), v -> v.getPythonVersion()));
        return versionsNotInRequired;
    }

    private void checkEnginesInstalled() {
        if (!this.readJSon) {
            this.readEnginesJSON();
        }
        Map engineFolders = ENGINES_VERSIONS.entrySet().stream().collect(Collectors.toMap(v -> (String)v.getKey(), v -> {
            String framework = ((String)v.getKey()).substring(0, ((String)v.getKey()).lastIndexOf("_"));
            if (ENGINES_MAP.get(framework) != null) {
                framework = ENGINES_MAP.get(framework);
            }
            String pythonVersion = (String)v.getValue();
            try {
                boolean gpu = true;
                boolean cpu = true;
                List<DeepLearningVersion> supported = AvailableEngines.getEnginesForOsByParams(framework, pythonVersion, cpu, gpu);
                if (supported.size() == 0) {
                    supported = AvailableEngines.getEnginesForOsByParams(framework, pythonVersion, cpu, null);
                }
                if (supported.size() == 0) {
                    return "";
                }
                return this.managersDir + File.separator + supported.get(0).folderName();
            }
            catch (Exception ex) {
                return "";
            }
        }, (u, v) -> u, LinkedHashMap::new));
        this.missingEngineFolders = engineFolders.entrySet().stream().filter(dir -> {
            try {
                if (((String)dir.getValue()).equals("")) {
                    return false;
                }
                File dirFile = new File((String)dir.getValue());
                return !dirFile.isDirectory() || DeepLearningVersion.fromFile(dirFile).checkMissingJars().size() != 0;
            }
            catch (Exception e) {
                return true;
            }
        }).collect(Collectors.toMap(dir -> (String)dir.getKey(), dir -> (String)dir.getValue(), (u, v) -> u, LinkedHashMap::new));
        if (this.missingEngineFolders.entrySet().size() == 0) {
            this.everythingInstalled = true;
        }
    }

    private void manageMissingEngines() throws InterruptedException {
        if (this.missingEngineFolders == null) {
            this.checkEnginesInstalled();
        }
        if (this.missingEngineFolders.entrySet().size() == 0) {
            return;
        }
        this.missingEngineFolders = this.missingEngineFolders.entrySet().stream().filter(v -> {
            String value = (String)v.getValue();
            String generalName = value.substring(0, value.indexOf(new PlatformDetection().toString()) - 1);
            File generalFile = new File(generalName = generalName + GENERAL_KEYWORD);
            return !generalFile.isDirectory() || !generalFile.renameTo(new File((String)v.getValue()));
        }).collect(Collectors.toMap(v -> (String)v.getKey(), v -> (String)v.getValue(), (u, v) -> u, LinkedHashMap::new));
        this.installMissingBasicEngines();
    }

    private void installMissingBasicEngines() throws InterruptedException {
        if (this.missingEngineFolders == null) {
            this.checkEnginesInstalled();
        }
        if (this.missingEngineFolders.entrySet().size() == 0) {
            return;
        }
        ArrayList<MultiFileDownloader> mfdList = new ArrayList<MultiFileDownloader>();
        for (Map.Entry<String, String> v : this.missingEngineFolders.entrySet()) {
            try {
                DeepLearningVersion dlv = DeepLearningVersion.fromFile(new File(v.getValue()));
                mfdList.add(this.getDownloaderForEngine(dlv, new File(v.getValue()).getParentFile().getAbsolutePath()));
            }
            catch (IOException | IllegalStateException e) {
                mfdList.add(null);
            }
        }
        long totalSize = mfdList.stream().mapToLong(m -> m == null ? 0L : m.getTotalSize()).sum();
        ArrayList<Boolean> installedArr = new ArrayList<Boolean>();
        this.downloaded = 0L;
        Consumer<Long> consumerLong = l -> this.consumer.accept((double)(l + this.downloaded) / (double)totalSize);
        for (MultiFileDownloader mfd : mfdList) {
            if (mfd == null) {
                installedArr.add(false);
                continue;
            }
            this.strConsumer.accept(mfd.getFolder().getName());
            mfd.setTotalProgressConsumer(consumerLong);
            try {
                mfd.download();
                this.downloaded += mfd.getDownloadedBytes();
                installedArr.add(true);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        consumerLong.accept(0L);
        List keys = this.missingEngineFolders.keySet().stream().collect(Collectors.toList());
        for (int i = 0; i < installedArr.size(); ++i) {
            if (!((Boolean)installedArr.get(i)).booleanValue()) continue;
            this.missingEngineFolders.remove(keys.get(i));
        }
    }

    private MultiFileDownloader getDownloaderForEngine(DeepLearningVersion dlv, String dir) {
        dir = dir + File.separator + dlv.folderName();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String str : dlv.getJars()) {
            try {
                urls.add(new URL(str));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return new MultiFileDownloader(urls, new File(dir), Thread.currentThread());
    }

    public static boolean installEngineByCompleteName(String engineDir) throws IOException, InterruptedException, ExecutionException {
        return EngineInstall.installEngineByCompleteName(engineDir, null);
    }

    public static boolean installEngineByCompleteName(String engineDir, Consumer<Double> consumer) throws IOException, InterruptedException, ExecutionException {
        DeepLearningVersion dlVersion;
        File engineFileDir = new File(engineDir);
        if (!engineFileDir.isDirectory() && !engineFileDir.mkdirs()) {
            return false;
        }
        try {
            dlVersion = DeepLearningVersion.fromFile(engineFileDir);
        }
        catch (Exception e) {
            return false;
        }
        if (dlVersion == null) {
            throw new IOException("JDLL does not support any engine compatible with the provided engine directory: " + engineDir);
        }
        EngineInstall.installEngineInDir(dlVersion, engineFileDir.getParentFile().getAbsolutePath(), consumer);
        return true;
    }

    public static boolean installEngineForWeights(WeightFormat ww) throws IOException, InterruptedException, ExecutionException {
        return EngineInstall.installEngineForWeightsInDir(ww, InstalledEngines.getEnginesDir(), null);
    }

    public static boolean installEngineForWeights(WeightFormat ww, Consumer<Double> consumer) throws IOException, InterruptedException, ExecutionException {
        return EngineInstall.installEngineForWeightsInDir(ww, InstalledEngines.getEnginesDir(), consumer);
    }

    public static boolean installEngineForWeightsInDir(WeightFormat ww, String enginesDir) throws IOException, InterruptedException, ExecutionException {
        return EngineInstall.installEngineForWeightsInDir(ww, enginesDir, null);
    }

    public static boolean installEngineForWeightsInDir(WeightFormat ww, String enginesDir, Consumer<Double> consumer) throws IOException, InterruptedException, ExecutionException {
        DeepLearningVersion dlv;
        String version;
        String engine;
        InstalledEngines manager = InstalledEngines.buildEnginesFinder(enginesDir);
        List<DeepLearningVersion> vs = manager.getDownloadedForVersionedFramework(engine = ww.getFramework(), version = ww.getTrainingVersion());
        if (vs.size() != 0) {
            return true;
        }
        if (AvailableEngines.isEngineSupportedInOS(engine, version, true, true)) {
            dlv = AvailableEngines.getEnginesForOsByParams(engine, version, true, true).get(0);
        } else if (AvailableEngines.isEngineSupportedInOS(engine, version, true, false)) {
            dlv = AvailableEngines.getEnginesForOsByParams(engine, version, true, false).get(0);
        } else if (AvailableEngines.isEngineSupportedInOS(engine, version, false, true)) {
            dlv = AvailableEngines.getEnginesForOsByParams(engine, version, false, true).get(0);
        } else {
            return false;
        }
        if (dlv == null) {
            throw new IOException("JDLL does not support any engine compatible with the provided WeightFormat: " + ww.getFramework() + " " + ww.getTrainingVersion());
        }
        EngineInstall.installEngineInDir(dlv, enginesDir, consumer);
        return true;
    }

    public static boolean installEnginesForModel(ModelDescriptor descriptor) throws IOException {
        return EngineInstall.installEnginesForModelInDir(descriptor, InstalledEngines.getEnginesDir());
    }

    public static boolean installEnginesForModel(ModelDescriptor descriptor, Consumer<Double> consumer) throws IOException {
        return EngineInstall.installEnginesForModelInDir(descriptor, InstalledEngines.getEnginesDir(), consumer);
    }

    public static boolean installEnginesForModelInDir(ModelDescriptor descriptor, String enginesDir) throws IOException {
        return EngineInstall.installEnginesForModelInDir(descriptor, enginesDir, null);
    }

    public static boolean installEnginesForModelInDir(ModelDescriptor descriptor, String enginesDir, Consumer<Double> consumer) throws IOException {
        boolean installed = true;
        for (WeightFormat ww : descriptor.getWeights().gettAllSupportedWeightObjects()) {
            try {
                boolean status = EngineInstall.installEngineForWeightsInDir(ww, enginesDir, consumer);
                if (status) continue;
                System.out.println("DL engine not supported by JDLL: " + ww.getFramework());
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                e.printStackTrace();
                installed = false;
            }
        }
        return installed;
    }

    public static boolean installEnginesForModelByID(String modelID) throws IOException, InterruptedException {
        return EngineInstall.installEnginesForModelByIDInDir(modelID, InstalledEngines.getEnginesDir(), null);
    }

    public static boolean installEnginesForModelByID(String modelID, Consumer<Double> consumer) throws IOException, InterruptedException {
        return EngineInstall.installEnginesForModelByIDInDir(modelID, InstalledEngines.getEnginesDir(), consumer);
    }

    public static boolean installEnginesForModelByIDInDir(String modelID, String enginesDir) throws IOException, InterruptedException {
        return EngineInstall.installEnginesForModelByIDInDir(modelID, enginesDir, null);
    }

    public static boolean installEnginesForModelByIDInDir(String modelID, String enginesDir, Consumer<Double> consumer) throws IOException, InterruptedException {
        ModelDescriptor descriptor = BioimageioRepo.connect().selectByID(modelID);
        if (descriptor == null) {
            return false;
        }
        return EngineInstall.installEnginesForModelInDir(descriptor, enginesDir, consumer);
    }

    public static boolean installEnginesForModelByName(String modelName) throws IOException, InterruptedException {
        return EngineInstall.installEnginesForModelByNameinDir(modelName, InstalledEngines.getEnginesDir(), null);
    }

    public static boolean installEnginesForModelByName(String modelName, Consumer<Double> consumer) throws IOException, InterruptedException {
        return EngineInstall.installEnginesForModelByNameinDir(modelName, InstalledEngines.getEnginesDir(), consumer);
    }

    public static boolean installEnginesForModelByNameinDir(String modelName, String enginesDir) throws IOException, InterruptedException {
        return EngineInstall.installEnginesForModelByNameinDir(modelName, enginesDir, null);
    }

    public static boolean installEnginesForModelByNameinDir(String modelName, String enginesDir, Consumer<Double> consumer) throws IOException, InterruptedException {
        ModelDescriptor descriptor = BioimageioRepo.connect().selectByName(modelName);
        if (descriptor == null) {
            return false;
        }
        return EngineInstall.installEnginesForModelInDir(descriptor, enginesDir, consumer);
    }

    public static boolean installEnginesForModelInFolder(String modelFolder) throws FileNotFoundException, ModelSpecsException, IOException {
        return EngineInstall.installEnginesinDirForModelInFolder(modelFolder, InstalledEngines.getEnginesDir(), null);
    }

    public static boolean installEnginesForModelInFolder(String modelFolder, Consumer<Double> consumer) throws FileNotFoundException, ModelSpecsException, IOException {
        return EngineInstall.installEnginesinDirForModelInFolder(modelFolder, InstalledEngines.getEnginesDir(), consumer);
    }

    public static boolean installEnginesinDirForModelInFolder(String modelFolder, String enginesDir) throws FileNotFoundException, ModelSpecsException, IOException {
        return EngineInstall.installEnginesinDirForModelInFolder(modelFolder, enginesDir, null);
    }

    public static boolean installEnginesinDirForModelInFolder(String modelFolder, String enginesDir, Consumer<Double> consumer) throws FileNotFoundException, ModelSpecsException, IOException {
        if (!new File(modelFolder, "rdf.yaml").isFile()) {
            throw new FileNotFoundException("A Bioimage.io model folder should contain its corresponding rdf.yaml file.");
        }
        ModelDescriptor descriptor = ModelDescriptorFactory.readFromLocalFile(modelFolder + File.separator + "rdf.yaml");
        return EngineInstall.installEnginesForModelInDir(descriptor, enginesDir, consumer);
    }

    public static void installEngine(DeepLearningVersion engine) throws IOException, InterruptedException, ExecutionException {
        EngineInstall.installEngine(engine, null);
    }

    public static void installEngine(DeepLearningVersion engine, Consumer<Double> consumer) throws IOException, InterruptedException, ExecutionException {
        EngineInstall.installEngineInDir(engine, ENGINES_DIR, consumer);
    }

    public static void installEngineInDir(DeepLearningVersion engine, String engineDir) throws IOException, InterruptedException, ExecutionException {
        EngineInstall.installEngineInDir(engine, engineDir, null);
    }

    public static void installEngineInDir(DeepLearningVersion engine, String engineDir, Consumer<Double> consumer) throws IOException, InterruptedException, ExecutionException {
        String folder = engineDir + File.separator + engine.folderName();
        if (!new File(folder).isDirectory() && !new File(folder).mkdirs()) {
            throw new IOException("Unable to create the folder where the engine will be installed: " + folder);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String jj : engine.getJars()) {
            urls.add(new URL(jj));
        }
        MultiFileDownloader mfd = new MultiFileDownloader(urls, new File(folder), Thread.currentThread());
        if (consumer != null) {
            mfd.setPartialProgressConsumer(consumer);
        }
        mfd.download();
    }

    public static void installEngineWithArgs(String framework, String version, boolean cpu, boolean gpu) throws IOException, InterruptedException, ExecutionException {
        EngineInstall.installEngineWithArgsInDir(framework, version, cpu, gpu, ENGINES_DIR, null);
    }

    public static void installEngineWithArgsInDir(String framework, String version, boolean cpu, boolean gpu, String dir) throws IOException, InterruptedException, ExecutionException {
        EngineInstall.installEngineWithArgsInDir(framework, version, cpu, gpu, dir, null);
    }

    public static void installEngineWithArgs(String framework, String version, boolean cpu, boolean gpu, Consumer<Double> consumer) throws IOException, InterruptedException, ExecutionException {
        EngineInstall.installEngineWithArgsInDir(framework, version, cpu, gpu, ENGINES_DIR, consumer);
    }

    public static void installEngineWithArgsInDir(String framework, String version, boolean cpu, boolean gpu, String dir, Consumer<Double> consumer) throws IOException, InterruptedException, ExecutionException {
        DeepLearningVersion engine;
        if (AvailableEngines.bioimageioToModelRunnerKeysMap().get(framework) != null) {
            framework = AvailableEngines.bioimageioToModelRunnerKeysMap().get(framework);
        }
        if ((engine = (DeepLearningVersion)AvailableEngines.filterByFrameworkForOS(framework).stream().filter(v -> v.getPythonVersion().equals(version) && v.getCPU() == cpu && v.getGPU() == gpu).findFirst().orElse(null)) == null) {
            throw new IOException("JDLL does not support any engine compatible with the provided arguments: framework=" + framework + " version=" + version + " cpu=" + cpu + " gpu=" + gpu);
        }
        EngineInstall.installEngineInDir(engine, dir, consumer);
    }

    public boolean isInstallationFinished() {
        return this.isManagementFinished;
    }

    public static boolean isEngineSupported(String framework, String version, boolean cpu, boolean gpu) {
        DeepLearningVersion engine;
        if (ENGINES_MAP.get(framework) != null) {
            framework = AvailableEngines.bioimageioToModelRunnerKeysMap().get(framework);
        }
        return (engine = (DeepLearningVersion)AvailableEngines.filterByFrameworkForOS(framework).stream().filter(v -> v.getPythonVersion().equals(version) && v.getOs().equals(new PlatformDetection().toString()) && v.getCPU() == cpu && v.getGPU() == gpu && (!PlatformDetection.isUsingRosseta() || v.getRosetta())).findFirst().orElse(null)) != null;
    }

    static {
        ENGINES_VERSIONS.put(EngineInfo.getTensorflowKey() + "_2", "2.7.0");
        ENGINES_VERSIONS.put(EngineInfo.getTensorflowKey() + "_1", "1.15.0");
        ENGINES_VERSIONS.put(EngineInfo.getOnnxKey() + "_17", "17");
        ENGINES_VERSIONS.put(EngineInfo.getPytorchKey() + "_1", "1.13.1");
        ENGINES_MAP = AvailableEngines.bioimageioToModelRunnerKeysMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }
}

