/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.example;

import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.engine.EngineInfo;
import io.bioimage.modelrunner.engine.installation.EngineInstall;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.model.java.DLModelJava;
import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.versionmanagement.AvailableEngines;
import io.bioimage.modelrunner.versionmanagement.DeepLearningVersion;
import io.bioimage.modelrunner.versionmanagement.InstalledEngines;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public class ExampleLoadAndRunModel {
    private static final String CWD = System.getProperty("user.dir");
    private static final String ENGINES_DIR = new File(CWD, "engines").getAbsolutePath();
    private static final String MODELS_DIR = new File(CWD, "models").getAbsolutePath();

    public static <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> void main(String[] args) throws LoadEngineException, Exception {
        String framework = "torchscript";
        String engineVersion = "1.13.1";
        String enginesDir = ENGINES_DIR;
        ExampleLoadAndRunModel.downloadCPUEngine(framework, engineVersion, enginesDir);
        String bmzModelName = "EnhancerMitochondriaEM2D";
        String modelFolder = ExampleLoadAndRunModel.downloadBMZModel(bmzModelName, MODELS_DIR);
        String modelSource = new File(modelFolder, "weights-torchscript.pt").getAbsolutePath();
        boolean cpu = true;
        List<DeepLearningVersion> installedList = InstalledEngines.checkEngineWithArgsInstalledForOS(framework, engineVersion, cpu, null, enginesDir);
        boolean gpu = installedList.get(0).getGPU();
        EngineInfo engineInfo = ExampleLoadAndRunModel.createEngineInfo(framework, engineVersion, enginesDir, cpu, gpu);
        DLModelJava model = ExampleLoadAndRunModel.loadModel(modelFolder, modelSource, engineInfo);
        ArrayImgFactory imgFactory = new ArrayImgFactory((NativeType)new FloatType());
        Img img1 = imgFactory.create(new long[]{1L, 1L, 512L, 512L});
        Tensor inpTensor = Tensor.build("input0", "bcyx", img1);
        ArrayList inputs = new ArrayList();
        inputs.add(inpTensor);
        Img img2 = imgFactory.create(new long[]{1L, 2L, 512L, 512L});
        Tensor outTensor = Tensor.build("output0", "bcyx", img2);
        ArrayList outputs = new ArrayList();
        outputs.add(outTensor);
        System.out.println(Util.average((double[])Util.asDoubleArray(((Tensor)outputs.get(0)).getData())));
        model.run(inputs, outputs);
        System.out.println(Util.average((double[])Util.asDoubleArray(((Tensor)outputs.get(0)).getData())));
        model.close();
        inputs.stream().forEach(t -> t.close());
        outputs.stream().forEach(t -> t.close());
        System.out.print("Success!!");
    }

    public static void downloadCPUEngine(String framework, String engineVersion, String enginesDir) throws IOException, InterruptedException, ExecutionException {
        List<DeepLearningVersion> possibleEngines = AvailableEngines.getEnginesForOsByParams(framework, engineVersion, true, null);
        EngineInstall.installEngineInDir(possibleEngines.get(0), enginesDir);
    }

    public static String downloadBMZModel(String bmzModelName, String modelsDir) throws IOException, InterruptedException {
        BioimageioRepo br = BioimageioRepo.connect();
        return br.downloadByName(bmzModelName, modelsDir);
    }

    public static EngineInfo createEngineInfo(String engine, String engineVersion, String enginesDir, boolean cpu, boolean gpu) {
        return EngineInfo.defineDLEngine(engine, engineVersion, cpu, gpu, enginesDir);
    }

    public static DLModelJava loadModel(String modelFolder, String modelSource, EngineInfo engineInfo) throws LoadEngineException, Exception {
        DLModelJava model = DLModelJava.createModel(modelFolder, modelSource, engineInfo);
        model.loadModel();
        return model;
    }
}

