/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.gui.DefaultIcon;
import io.bioimage.modelrunner.gui.ModelSelectionPanel;
import io.bioimage.modelrunner.gui.workers.ImageLoaderWorker;
import io.bioimage.modelrunner.gui.workers.ModelInfoWorker;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ContentPanel
extends JPanel {
    private JLabel exampleImageLabel;
    private JEditorPane modelInfoArea;
    private JProgressBar progressBar;
    private JLabel progressInfoLabel;
    private JPanel progressLabelPanel;
    private JPanel progressPanel;
    private JScrollPane infoScrollPane;
    private CardLayout progressLabelLayout;
    private ImageLoaderWorker imageWorker;
    private final long parentHeight;
    private final long parentWidth;
    private static final double MODEL_VRATIO = 0.4;
    private static final double PROGRESS_VRATIO = 0.2;
    private static final double INFO_VRATIO = 0.7;
    private static final long serialVersionUID = -7691139174208436363L;

    protected ContentPanel(int parentWidth, int parentHeight) {
        super(new GridLayout(1, 2));
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
        this.setBorder(new EmptyBorder(5, 5, 5, 15));
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(parentWidth, (int)((double)parentHeight * 0.4)));
        JPanel exampleImagePanel = new JPanel(new GridBagLayout());
        exampleImagePanel.setBackground(Color.WHITE);
        JLabel exampleTitleLabel = new JLabel("Cover Image", 0);
        exampleTitleLabel.setFont(new Font("SansSerif", 1, 18));
        int logoHeight = (int)((double)parentHeight * 0.3);
        int logoWidth = parentWidth / 3;
        ImageIcon logoIcon = DefaultIcon.getDefaultIcon(logoWidth, logoHeight);
        this.exampleImageLabel = new JLabel(logoIcon, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        exampleImagePanel.add((Component)exampleTitleLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 10.0;
        exampleImagePanel.add((Component)this.exampleImageLabel, gbc);
        JPanel modelInfoPanel = new JPanel(new GridBagLayout());
        modelInfoPanel.setBackground(Color.WHITE);
        JLabel infoTitleLabel = new JLabel("Model Information", 0);
        infoTitleLabel.setFont(new Font("SansSerif", 1, 18));
        this.modelInfoArea = new JEditorPane("text/html", "Detailed model description...");
        this.modelInfoArea.setEditable(false);
        this.modelInfoArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.modelInfoArea.setPreferredSize(new Dimension(0, (int)(0.27999999999999997 * (double)this.parentHeight)));
        this.infoScrollPane = new JScrollPane(this.modelInfoArea);
        this.infoScrollPane.setMinimumSize(new Dimension(0, (int)(0.27999999999999997 * (double)this.parentHeight)));
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        modelInfoPanel.add((Component)infoTitleLabel, gbc);
        gbc.gridy = 1;
        gbc.weighty = 10.0;
        gbc.fill = 1;
        modelInfoPanel.add((Component)this.infoScrollPane, gbc);
        gbc.gridy = 2;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.createProgressBar();
        modelInfoPanel.add((Component)this.progressPanel, gbc);
        this.add(exampleImagePanel);
        this.add(modelInfoPanel);
    }

    protected void setIcon(Icon icon) {
        this.exampleImageLabel.setIcon(icon);
    }

    protected void setInfo(String text) {
        this.modelInfoArea.setText(text);
        this.modelInfoArea.setCaretPosition(0);
    }

    private void createProgressBar() {
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(false);
        this.progressBar.setPreferredSize(new Dimension((int)this.infoScrollPane.getPreferredSize().getWidth(), (int)((double)this.parentHeight * 0.2)));
        this.progressBar.setBackground(Color.LIGHT_GRAY);
        this.progressBar.setVisible(true);
        this.progressBar.setForeground(new Color(46, 204, 113));
        this.progressInfoLabel = new JLabel("Example text");
        this.progressInfoLabel.setForeground(Color.black);
        this.progressInfoLabel.setFont(new Font("SansSerif", 2, 14));
        this.progressPanel = new JPanel(new GridBagLayout());
        this.progressPanel.setOpaque(false);
        GridBagConstraints progressBarGbc = new GridBagConstraints();
        progressBarGbc.gridx = 0;
        progressBarGbc.weightx = 1.0;
        progressBarGbc.insets = new Insets(2, 2, 2, 2);
        progressBarGbc.fill = 1;
        progressBarGbc.gridy = 0;
        this.progressPanel.add((Component)this.progressBar, progressBarGbc);
        progressBarGbc.gridy = 1;
        this.progressLabelPanel = new JPanel();
        this.progressLabelLayout = new CardLayout();
        this.progressLabelPanel.setLayout(this.progressLabelLayout);
        this.progressLabelPanel.add((Component)this.progressInfoLabel, "visible");
        this.progressLabelPanel.add((Component)new JPanel(), "invisible");
        this.progressLabelLayout.show(this.progressLabelPanel, "invisible");
        this.progressPanel.add((Component)this.progressLabelPanel, progressBarGbc);
    }

    protected void setDeterminatePorgress(int progress) {
        this.progressBar.setValue(progress);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(progress + "%");
    }

    protected void setProgressIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
    }

    protected void setProgressBarText(String text) {
        this.progressBar.setString(text);
    }

    protected int getProgress() {
        return this.progressBar.getValue();
    }

    protected String getProgressBarText() {
        return this.progressBar.getString();
    }

    protected void setProgressLabelText(String text) {
        if (text == null || text.equals("")) {
            this.progressLabelLayout.show(this.progressLabelPanel, "invisible");
            return;
        }
        this.progressInfoLabel.setText(text);
        this.progressLabelLayout.show(this.progressLabelPanel, "visible");
    }

    protected void update(ModelDescriptor modelDescriptor, final URL path, int logoWidth, int logoHeight) {
        DefaultIcon.getLoadingIconWithCallback(logoWidth, logoHeight, icon -> {
            this.setIcon((Icon)icon);
            this.revalidate();
            this.repaint();
        });
        ModelSelectionPanel.ICONS_DISPLAYED.put("main", path);
        ModelInfoWorker.TextLoadCallback callback = new ModelInfoWorker.TextLoadCallback(){

            @Override
            public void onTextLoaded(String infoText) {
                if (!ModelSelectionPanel.ICONS_DISPLAYED.get("main").equals(path)) {
                    return;
                }
                ContentPanel.this.setInfo(infoText);
                ContentPanel.this.revalidate();
                ContentPanel.this.repaint();
            }
        };
        ModelInfoWorker worker = new ModelInfoWorker(modelDescriptor, callback);
        worker.execute();
        if (this.imageWorker != null && !this.imageWorker.isDone()) {
            this.imageWorker.cancelBackground();
        }
        ImageLoaderWorker.ImageLoadCallback imageCallback = new ImageLoaderWorker.ImageLoadCallback(){

            @Override
            public void onImageLoaded(ImageIcon icon) {
                if (ModelSelectionPanel.ICONS_DISPLAYED.get("main") != path) {
                    return;
                }
                ContentPanel.this.setIcon(icon);
                ContentPanel.this.revalidate();
                ContentPanel.this.repaint();
            }
        };
        this.imageWorker = ImageLoaderWorker.create(path, logoWidth, logoHeight, imageCallback);
        this.imageWorker.execute();
    }
}

