/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.gui.workers.InstallEnvWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;

public class EnvironmentInstaller
extends JPanel {
    private static final long serialVersionUID = -459646711339061371L;
    private InstallEnvWorker worker;
    private Consumer<String> consumer;
    private JTextPane htmlPane;
    private JButton cancelButton;
    private Point initialClick;
    private int loadingCharInd = 0;
    private static final String[] LOADING_CHAR = new String[]{"/", "\\", "|"};
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final String HTML_STYLE = "<!DOCTYPE html>" + System.lineSeparator() + "<html lang=\"en\">" + System.lineSeparator() + "  <head>" + System.lineSeparator() + "    <meta charset=\"UTF-8\">" + System.lineSeparator() + "    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">" + System.lineSeparator() + "    <title>Installation Console</title>" + System.lineSeparator() + "    <style>" + System.lineSeparator() + "      body {" + System.lineSeparator() + "        font-family: 'SF Mono', 'Fira Code', monospace;" + System.lineSeparator() + "      }" + System.lineSeparator() + "    </style>" + System.lineSeparator() + "  </head>" + System.lineSeparator() + "  <body>" + System.lineSeparator() + "    <div class=\"console-panel\">" + System.lineSeparator() + "      <h1>%s</h1>" + System.lineSeparator() + "    </div>" + System.lineSeparator() + "  </body>" + System.lineSeparator() + "</html>" + System.lineSeparator();
    private static final String LOADING_STR = "<p class='logline'>%s -- Installation in progress...%s</p>";
    private static final String LOADING_REGEX = "<p\\s+class=[\"']logline[\"']>\\s*((?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d)\\s+--\\s+Installation in progress\\.\\.\\.(.)\\s*</p>";

    private EnvironmentInstaller(InstallEnvWorker worker) {
        this.worker = worker;
        this.consumer = str -> this.updateText((String)str, Color.BLACK);
        worker.setConsumer(this.consumer);
        this.setLayout(new BorderLayout());
        this.htmlPane = new JTextPane();
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditable(false);
        this.htmlPane.setText(String.format(HTML_STYLE, "Installing Python for " + worker.getModelFamily()));
        JScrollPane scrollPane = new JScrollPane(this.htmlPane);
        this.add((Component)scrollPane, "Center");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(e -> this.cancelInstallation());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.cancelButton);
        this.add((Component)buttonPanel, "South");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EnvironmentInstaller.this.initialClick = e.getPoint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = e.getXOnScreen() - ((EnvironmentInstaller)EnvironmentInstaller.this).initialClick.x;
                int y = e.getYOnScreen() - ((EnvironmentInstaller)EnvironmentInstaller.this).initialClick.y;
                SwingUtilities.getWindowAncestor(EnvironmentInstaller.this).setLocation(x, y);
            }
        });
    }

    public static EnvironmentInstaller create(InstallEnvWorker worker) {
        EnvironmentInstaller installer = new EnvironmentInstaller(worker);
        return installer;
    }

    public Consumer<String> getConsumer() {
        return this.consumer;
    }

    public void cancelInstallation() {
        this.worker.stopBackground();
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.dispose();
        }
    }

    public void addToFrame(JDialog parentFrame) {
        parentFrame.setContentPane(this);
        parentFrame.setLocationRelativeTo(null);
        parentFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EnvironmentInstaller.this.cancelInstallation();
            }
        });
        parentFrame.setVisible(true);
    }

    public void updateText(String text, Color color) {
        if ((text = text.trim()).equals("") || text.equals(null)) {
            this.updateWait();
        } else {
            this.appendText(text, color);
        }
    }

    private void appendText(String text, Color color) {
        text = EnvironmentInstaller.formatInput(text);
        String hexColor = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        String htmlSnippet = "<p class='logline' style='color:" + hexColor + ";'>" + text + "</p>";
        String[] fullText = new String[]{""};
        try {
            SwingUtilities.invokeAndWait(() -> {
                fullText[0] = this.htmlPane.getText();
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        int containerStart = fullText[0].indexOf("</h1>" + System.lineSeparator());
        int containerEnd = fullText[0].indexOf("</div>", containerStart);
        if (containerStart < 0 || containerEnd < 0) {
            return;
        }
        String nText = fullText[0].substring(0, containerEnd) + htmlSnippet + fullText[0].substring(containerEnd, fullText[0].length());
        SwingUtilities.invokeLater(() -> {
            this.htmlPane.setText(nText);
            HTMLDocument doc = (HTMLDocument)this.htmlPane.getDocument();
            this.htmlPane.setCaretPosition(doc.getLength());
        });
    }

    private void updateWait() {
        String[] fullText = new String[]{""};
        try {
            SwingUtilities.invokeAndWait(() -> {
                fullText[0] = this.htmlPane.getText();
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        int containerStart = fullText[0].indexOf("</h1>" + System.lineSeparator());
        int containerEnd = fullText[0].indexOf("</div>", containerStart);
        if (containerStart < 0 || containerEnd < 0) {
            return;
        }
        Pattern pattern = Pattern.compile(LOADING_REGEX);
        Matcher matcher = pattern.matcher(fullText[0]);
        int lastMatchStart = -1;
        int lastMatchEnd = -1;
        while (matcher.find()) {
            lastMatchStart = matcher.start(1) - "<p class='logline'>".length();
            lastMatchStart = fullText[0].substring(0, lastMatchStart).lastIndexOf("<p");
            lastMatchEnd = fullText[0].substring(lastMatchStart).indexOf("</p>") + "</p>".length() + lastMatchStart;
        }
        String loadingString = String.format(LOADING_STR, LocalTime.now().format(FORMATTER), this.getLoadingChar());
        if (lastMatchEnd == -1 || !fullText[0].substring(lastMatchEnd, containerEnd).trim().equals("")) {
            lastMatchStart = containerEnd;
            lastMatchEnd = containerEnd;
        }
        String nText = fullText[0].substring(0, lastMatchStart) + loadingString + fullText[0].substring(lastMatchEnd, fullText[0].length());
        this.htmlPane.setText(nText);
        HTMLDocument doc = (HTMLDocument)this.htmlPane.getDocument();
        this.htmlPane.setCaretPosition(doc.getLength());
    }

    private String getLoadingChar() {
        this.loadingCharInd %= LOADING_CHAR.length;
        String sel = LOADING_CHAR[this.loadingCharInd];
        ++this.loadingCharInd;
        return sel;
    }

    private static String formatInput(String text) {
        if (text.matches("^\\d{2}:\\d{2}:\\d{2}\\s--.*")) {
            return text;
        }
        LocalTime now = LocalTime.now();
        return now.format(FORMATTER) + " -- " + text;
    }
}

