/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

public class Layout
extends GridBagLayout {
    private static final long serialVersionUID = 1816507461370536813L;
    private GridBagConstraints gbc = new GridBagConstraints();
    private boolean isVertical = false;
    private final double[] weigths;

    protected Layout(double[] weigths, boolean isVertical) {
        this.isVertical = isVertical;
        this.weigths = weigths;
    }

    public static Layout createVertical(double[] weights) {
        Layout layout = new Layout(weights, true);
        return layout;
    }

    public static Layout createHorizontal(double[] weights) {
        Layout layout = new Layout(weights, false);
        return layout;
    }

    public GridBagConstraints get(int n) {
        if (n >= this.weigths.length) {
            throw new IllegalArgumentException("The interface does not have as many components.");
        }
        this.gbc.fill = 1;
        if (this.isVertical) {
            this.gbc.fill = 1;
            this.gbc.gridx = 0;
            this.gbc.gridwidth = 0;
            this.gbc.weightx = 1.0;
        } else {
            this.gbc.fill = 1;
            this.gbc.gridy = 0;
            this.gbc.gridheight = 0;
            this.gbc.weighty = 1.0;
        }
        if (this.isVertical) {
            this.gbc.gridy = n;
            this.gbc.weighty = this.weigths[n];
        } else {
            this.gbc.gridx = n;
            this.gbc.weightx = this.weigths[n];
        }
        return this.gbc;
    }
}

