/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.gui.DefaultIcon;
import io.bioimage.modelrunner.gui.ModelSelectionPanel;
import io.bioimage.modelrunner.gui.workers.ImageLoaderWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ModelCard
extends JPanel {
    private static final long serialVersionUID = -5625832740571130175L;
    private JLabel nameLabel;
    private JLabel imageLabel;
    private JLabel nicknameLabel;
    private long cardWidth;
    private long cardHeight;
    private String id;
    private ImageLoaderWorker worker;
    private final double scale;
    private static double CARD_ICON_VRATIO = 0.8;
    private static double CARD_ICON_HRATIO = 0.9;

    private ModelCard(long cardWidth, long cardHeight, double scale) {
        super(new BorderLayout());
        this.scale = scale;
        this.cardWidth = cardWidth;
        this.cardHeight = cardHeight;
        this.setPreferredSize(new Dimension((int)((double)cardWidth * scale), (int)((double)cardHeight * scale)));
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        ImageIcon logoIcon = ModelCard.createEmptyIcon((int)(CARD_ICON_HRATIO * (double)cardWidth * scale), (int)((double)cardHeight * CARD_ICON_VRATIO * scale));
        this.imageLabel = new JLabel(logoIcon, 0);
        this.nameLabel = new JLabel("loading...", 0);
        this.nameLabel.setFont(new Font("SansSerif", 1, (int)(16.0 * scale)));
        this.nicknameLabel = new JLabel("loading...", 0);
        this.nicknameLabel.setFont(new Font("SansSerif", 2, (int)(14.0 * scale)));
        this.add((Component)this.nameLabel, "North");
        this.add((Component)this.imageLabel, "Center");
        this.add((Component)this.nicknameLabel, "South");
    }

    public void setOptionalID(String id) {
        this.id = id;
    }

    protected static ModelCard createModelCard(long cardWidth, long cardHeight, double scale) {
        ModelCard modelCardPanel = new ModelCard(cardWidth, cardHeight, scale);
        return modelCardPanel;
    }

    protected void updateCard(String name, String nickname, final URL imagePath) {
        this.nameLabel.setText(name);
        this.nicknameLabel.setText(nickname);
        int iconW = (int)(CARD_ICON_HRATIO * (double)this.cardWidth * this.scale);
        int iconH = (int)((double)this.cardHeight * CARD_ICON_VRATIO * this.scale);
        DefaultIcon.getLoadingIconWithCallback(iconW, iconH, icon -> {
            this.imageLabel.setIcon((Icon)icon);
            this.revalidate();
            this.repaint();
        });
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancelBackground();
        }
        ImageLoaderWorker.ImageLoadCallback callback = new ImageLoaderWorker.ImageLoadCallback(){

            @Override
            public void onImageLoaded(ImageIcon icon) {
                if (ModelSelectionPanel.ICONS_DISPLAYED.get(ModelCard.this.id) != imagePath) {
                    return;
                }
                ModelCard.this.imageLabel.setIcon(icon);
                ModelCard.this.revalidate();
                ModelCard.this.repaint();
            }
        };
        this.worker = ImageLoaderWorker.create(imagePath, iconW, iconH, callback);
        this.worker.execute();
    }

    private static ImageIcon createEmptyIcon(int width, int height) {
        BufferedImage emptyImage = new BufferedImage(width, height, 2);
        return new ImageIcon(emptyImage);
    }
}

