/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.gui.DefaultIcon;
import io.bioimage.modelrunner.gui.ModelCard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ModelSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 6264134076603842497L;
    private final long parentHeight;
    private final long parentWidth;
    private String defaultString = "loading...";
    private JPanel modelCarouselPanel;
    private ModelCard prevModelPanel;
    private ModelCard selectedModelPanel;
    private ModelCard nextModelPanel;
    protected JButton nextButton;
    protected JButton prevButton;
    private TitledBorder lineBorder;
    private List<String> modelNames;
    private List<String> modelNicknames;
    private List<URL> modelImagePaths;
    private List<ModelDescriptor> models;
    protected static Map<String, URL> ICONS_DISPLAYED = new ConcurrentHashMap<String, URL>();
    private static final String PREV_ICON = "prev";
    private static final String MAIN_ICON = "main";
    private static final String NEXT_ICON = "next";
    private static final double CARD_VRATIO = 0.8;
    private static final double CARD_HRATIO = 0.33;
    private static final double CARR_VRATIO = 0.95;
    private static final double SELECTION_PANE_VRATIO = 0.35;
    private static final double ARROWS_VRATIO = 0.05;
    protected static final double MAIN_CARD_RT = 1.0;
    protected static final double SECOND_CARD_RT = 0.8;

    protected ModelSelectionPanel(int parentWidth, int parentHeight) {
        super(new GridBagLayout());
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
        this.setBackground(new Color(236, 240, 241));
        this.lineBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 2, true), "Local");
        Border paddingBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.setBorder(BorderFactory.createCompoundBorder(paddingBorder, this.lineBorder));
        this.setPreferredSize(new Dimension(parentWidth, (int)((double)parentHeight * 0.35)));
        this.modelCarouselPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.modelCarouselPanel.setBackground(new Color(236, 240, 241));
        this.modelCarouselPanel.setPreferredSize(new Dimension(parentWidth, (int)((double)parentHeight * 0.35 * 0.95)));
        int cardHeight = (int)((double)this.parentHeight * 0.35 * 0.8);
        int cardWidth = (int)((double)parentWidth * 0.33);
        this.prevModelPanel = ModelCard.createModelCard(cardWidth, cardHeight, 0.8);
        this.prevModelPanel.setOptionalID(PREV_ICON);
        this.selectedModelPanel = ModelCard.createModelCard(cardWidth, cardHeight, 1.0);
        this.selectedModelPanel.setOptionalID(MAIN_ICON);
        this.nextModelPanel = ModelCard.createModelCard(cardWidth, cardHeight, 0.8);
        this.nextModelPanel.setOptionalID(NEXT_ICON);
        this.modelCarouselPanel.add(this.prevModelPanel);
        this.modelCarouselPanel.add(this.selectedModelPanel);
        this.modelCarouselPanel.add(this.nextModelPanel);
        int btnWidth = (int)(this.parentWidth / 2L);
        int btnHeight = (int)((double)this.parentHeight * 0.35 * 0.05);
        this.prevButton = new JButton("\u25c0");
        this.prevButton.setFont(new Font("SansSerif", 1, 10));
        this.prevButton.setPreferredSize(new Dimension(btnWidth, btnHeight));
        this.nextButton = new JButton("\u25b6");
        this.nextButton.setFont(new Font("SansSerif", 1, 10));
        this.nextButton.setPreferredSize(new Dimension(btnWidth, btnHeight));
        JPanel navigationPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbcb = new GridBagConstraints();
        gbcb.gridy = 0;
        gbcb.weightx = 1.0;
        gbcb.weighty = 1.0;
        gbcb.fill = 2;
        navigationPanel.setPreferredSize(new Dimension(parentWidth, btnHeight));
        navigationPanel.setBackground(new Color(236, 240, 241));
        gbcb.gridx = 0;
        navigationPanel.add((Component)this.prevButton, gbcb);
        gbcb.gridx = 1;
        navigationPanel.add((Component)this.nextButton, gbcb);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.ipady = 10;
        gbc.gridy = 0;
        gbc.weighty = 20.0;
        this.add((Component)this.modelCarouselPanel, gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        this.add((Component)navigationPanel, gbc);
    }

    private void setCardsData() {
        this.modelNames = this.models.stream().map(mm -> mm == null ? "no models found" : mm.getName()).collect(Collectors.toList());
        this.modelNicknames = this.models.stream().map(mm -> mm == null ? "no models found" : mm.getNickname()).collect(Collectors.toList());
        this.modelImagePaths = this.models.stream().map(mm -> {
            if (mm == null || mm.getCovers() == null || mm.getCovers().size() == 0) {
                return this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH);
            }
            File imFile = new File(mm.getCovers().get(0));
            if (!imFile.exists() && mm.getModelPath() != null) {
                imFile = new File(mm.getModelPath() + File.separator + mm.getCovers().get(0));
            } else if (mm.getModelPath() == null) {
                try {
                    return new URL(mm.getModelURL() + mm.getCovers().get(0));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (!imFile.exists()) {
                return this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH);
            }
            try {
                return imFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH);
            }
        }).collect(Collectors.toList());
    }

    protected void setModels(List<ModelDescriptor> models) {
        this.models = models;
        this.setCardsData();
        if (SwingUtilities.isEventDispatchThread()) {
            this.redrawModelCards(0);
        } else {
            SwingUtilities.invokeLater(() -> this.redrawModelCards(0));
        }
    }

    protected void setModelAt(ModelDescriptor model, int pos) {
        Objects.requireNonNull(model);
        if (pos > this.models.size()) {
            throw new IllegalArgumentException("Wanted position of the model (" + pos + ") out of range (" + this.models.size() + ").");
        }
        this.models.set(pos, model);
        this.modelNames.set(pos, model.getName() == null ? this.defaultString : model.getName());
        this.modelNicknames.set(pos, model.getNickname() == null ? this.defaultString : model.getNickname());
        if (model.getCovers() == null || model.getCovers().size() == 0) {
            this.modelImagePaths.set(pos, this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH));
            return;
        }
        File imFile = new File(model.getCovers().get(0));
        if (!imFile.exists() && model.getModelPath() != null) {
            imFile = new File(model.getModelPath() + File.separator + model.getCovers().get(0));
        } else if (model.getModelPath() == null) {
            try {
                this.modelImagePaths.set(pos, new URL(model.getModelURL() + model.getCovers().get(0)));
                return;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (!imFile.exists()) {
            this.modelImagePaths.set(pos, this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH));
            return;
        }
        try {
            this.modelImagePaths.set(pos, imFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.modelImagePaths.set(pos, this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH));
        }
    }

    protected void redrawModelCards(int currentIndex) {
        ICONS_DISPLAYED.put(PREV_ICON, this.modelImagePaths.get(this.getWrappedIndex(currentIndex - 1)));
        this.prevModelPanel.updateCard(this.modelNames.get(this.getWrappedIndex(currentIndex - 1)), this.modelNicknames.get(this.getWrappedIndex(currentIndex - 1)), this.modelImagePaths.get(this.getWrappedIndex(currentIndex - 1)));
        ICONS_DISPLAYED.put(MAIN_ICON, this.modelImagePaths.get(this.getWrappedIndex(currentIndex)));
        this.selectedModelPanel.updateCard(this.modelNames.get(currentIndex), this.modelNicknames.get(currentIndex), this.modelImagePaths.get(currentIndex));
        ICONS_DISPLAYED.put(NEXT_ICON, this.modelImagePaths.get(this.getWrappedIndex(currentIndex + 1)));
        this.nextModelPanel.updateCard(this.modelNames.get(this.getWrappedIndex(currentIndex + 1)), this.modelNicknames.get(this.getWrappedIndex(currentIndex + 1)), this.modelImagePaths.get(this.getWrappedIndex(currentIndex + 1)));
        this.modelCarouselPanel.revalidate();
        this.modelCarouselPanel.repaint();
    }

    protected void setBorderLabel(String text) {
        this.lineBorder.setTitle(text);
        this.validate();
        this.repaint();
    }

    protected void setArrowsEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
    }

    protected void setLocalBorder() {
        this.setBorderLabel("Local");
    }

    protected void setBMZBorder() {
        this.setBorderLabel("Bioimage.io");
    }

    private int getWrappedIndex(int index) {
        int size = this.getModelNames().size();
        return size == 0 ? size : (index % size + size) % size;
    }

    public List<String> getModelNames() {
        return this.modelNames;
    }

    public List<String> getModelNicknames() {
        return this.modelNicknames;
    }

    public List<URL> getCoverPaths() {
        return this.modelImagePaths;
    }

    public List<ModelDescriptor> getModels() {
        return this.models;
    }

    protected void setLoading() {
        this.defaultString = "loading...";
    }

    protected void setNotFound() {
        this.defaultString = "no models found";
    }
}

