/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.gui.workers.ImageLoaderWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SearchBar
extends JPanel {
    private static final long serialVersionUID = -1741389221668683293L;
    protected JTextField searchField;
    protected JButton searchButton;
    protected JButton switchButton;
    private long parentHeight;
    private long parentWidth;
    private List<ModelDescriptor> bmzModels;
    private int nModels;
    private static final double H_RATIO = 1.0;
    private static final double V_RATIO = 0.05;
    private static final double ICON_VRATIO = 1.0;
    private static final double ICON_HRATIO = 0.05;
    private static final double SEARCH_VRATIO = 1.0;
    private static final double SEARCH_HRATIO = 0.15;
    private static final double SWITCH_VRATIO = 1.0;
    private static final double SWITCH_HRATIO = 0.15;
    protected static final String SEARCH_ICON_PATH = "dij_imgs/search_logo.png";

    protected SearchBar(long parentWidth, long parentHeight) {
        this.parentHeight = parentHeight;
        this.parentWidth = parentWidth;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension((int)((double)parentWidth * 1.0), (int)((double)parentHeight * 0.05)));
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true));
        URL iconPath = this.getClass().getClassLoader().getResource(SEARCH_ICON_PATH);
        int iconH = (int)((double)parentHeight * 0.05 * 1.0);
        int iconW = (int)((double)parentWidth * 1.0 * 0.05);
        ImageIcon scaledImage = ImageLoaderWorker.createScaledIcon(iconPath, iconW, iconH);
        JLabel iconLabel = new JLabel(scaledImage);
        iconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URL("https://www.bioimage.io").toURI());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.searchField = new JTextField();
        this.searchField.setBorder(null);
        this.searchField.setFont(new Font("Arial", 0, 14));
        this.searchButton = new JButton("Search");
        int searchH = (int)((double)parentHeight * 0.05 * 1.0);
        int searchW = (int)((double)parentWidth * 1.0 * 0.15);
        this.searchButton.setPreferredSize(new Dimension(searchW, searchH));
        this.searchButton.setBackground(new Color(0, 120, 215));
        this.searchButton.setForeground(Color.WHITE);
        this.searchButton.setFocusPainted(false);
        this.searchButton.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.switchButton = new JButton("Bioimage.io");
        int switchH = (int)((double)parentHeight * 0.05 * 1.0);
        int switchW = (int)((double)parentWidth * 1.0 * 0.15);
        this.switchButton.setPreferredSize(new Dimension(switchW, switchH));
        this.switchButton.setBackground(new Color(255, 140, 0));
        this.switchButton.setForeground(Color.BLACK);
        this.switchButton.setFocusPainted(false);
        this.switchButton.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel wrapperPanel = new JPanel(new GridLayout(1, 2));
        wrapperPanel.add(this.searchButton);
        wrapperPanel.add(this.switchButton);
        this.add((Component)iconLabel, "West");
        this.add((Component)this.searchField, "Center");
        this.add((Component)wrapperPanel, "East");
    }

    protected List<ModelDescriptor> performSearch() {
        String searchText = this.searchField.getText().trim();
        return this.bmzModels.stream().filter(mm -> {
            if (mm == null) {
                return false;
            }
            return mm.getName().contains(searchText) || mm.getDescription().contains(searchText) || mm.getNickname().contains(searchText) || mm.getTags().contains(searchText);
        }).collect(Collectors.toList());
    }

    protected int countBMZModels() throws InterruptedException {
        return this.countBMZModels(false);
    }

    protected int countBMZModels(boolean recount) throws InterruptedException {
        if (!recount) {
            return this.nModels;
        }
        BioimageioRepo.connect();
        this.nModels = BioimageioRepo.getModelIDs().size();
        return this.nModels;
    }

    protected List<ModelDescriptor> findBMZModels() throws InterruptedException {
        this.bmzModels = new ArrayList<ModelDescriptor>();
        for (String url : BioimageioRepo.getModelIDs()) {
            ModelDescriptor descriptor = BioimageioRepo.retreiveDescriptorFromURL(BioimageioRepo.getModelURL(url) + "rdf.yaml");
            if (descriptor == null) continue;
            this.bmzModels.add(descriptor);
        }
        return this.bmzModels;
    }

    protected void findLocalModels(String dir) {
        this.bmzModels = ModelDescriptorFactory.getModelsAtLocalRepo(dir);
    }

    protected List<ModelDescriptor> getBMZModels() {
        return this.bmzModels;
    }

    protected void setModels(List<ModelDescriptor> models) {
        this.bmzModels = models;
    }

    protected boolean isBMZPArsingDone() {
        return this.nModels == this.bmzModels.size();
    }

    protected void changeButtonToLocal() {
        this.switchButton.setText("Local");
    }

    protected void changeButtonToBMZ() {
        this.switchButton.setText("Bioimage.io");
    }

    protected boolean isBarOnLocal() {
        return this.switchButton.getText().equals("Bioimage.io");
    }

    protected void setBarEnabled(boolean enabled) {
        this.searchButton.setEnabled(enabled);
        this.switchButton.setEnabled(enabled);
        this.searchField.setEnabled(enabled);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Modern Search Bar");
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().add(new SearchBar(600L, 800L));
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

