/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.numpy;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteArrayUtils {
    public static short[] toInt16(byte[] arr) {
        return ByteArrayUtils.toInt16(arr, ByteOrder.LITTLE_ENDIAN);
    }

    public static short[] toInt16(byte[] arr, ByteOrder byteOrder) {
        short[] int16 = new short[arr.length / 2];
        for (int i = 0; i < arr.length / 4; ++i) {
            byte[] intArr = new byte[]{arr[i * 2], arr[i * 4 + 1]};
            int16[i] = ByteBuffer.wrap(intArr).order(byteOrder).getShort();
        }
        return int16;
    }

    public static int[] toUInt8(byte[] arr) {
        return ByteArrayUtils.toUInt8(arr, ByteOrder.LITTLE_ENDIAN);
    }

    public static int[] toUInt8(byte[] arr, ByteOrder byteOrder) {
        int[] int32 = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            int32[i] = arr[i] < 0 ? 256 + arr[i] : arr[i];
        }
        return int32;
    }

    public static int[] toInt32(byte[] arr) {
        return ByteArrayUtils.toInt32(arr, ByteOrder.LITTLE_ENDIAN);
    }

    public static int[] toInt32(byte[] arr, ByteOrder byteOrder) {
        int[] int32 = new int[arr.length / 4];
        for (int i = 0; i < arr.length / 4; ++i) {
            byte[] intArr = new byte[]{arr[i * 4], arr[i * 4 + 1], arr[i * 4 + 2], arr[i * 4 + 3]};
            int32[i] = ByteBuffer.wrap(intArr).order(byteOrder).getInt();
        }
        return int32;
    }

    public static long[] toUInt32(byte[] arr) {
        return ByteArrayUtils.toUInt32(arr, ByteOrder.LITTLE_ENDIAN);
    }

    public static long[] toUInt32(byte[] arr, ByteOrder byteOrder) {
        long[] uint32 = new long[arr.length / 4];
        for (int i = 0; i < arr.length / 4; ++i) {
            byte[] intArr = new byte[]{arr[i * 4], arr[i * 4 + 1], arr[i * 4 + 2], arr[i * 4 + 3]};
            int number = ByteBuffer.wrap(intArr).order(byteOrder).getInt();
            uint32[i] = number < 0 ? (long)(Math.pow(2.0, 32.0) + (double)number) : (long)number;
        }
        return uint32;
    }

    public static int[] toUInt16(byte[] arr) {
        return ByteArrayUtils.toUInt16(arr, ByteOrder.LITTLE_ENDIAN);
    }

    public static int[] toUInt16(byte[] arr, ByteOrder byteOrder) {
        int[] int16 = new int[arr.length / 2];
        for (int i = 0; i < arr.length / 4; ++i) {
            byte[] intArr = new byte[]{arr[i * 2], arr[i * 4 + 1]};
            short number = ByteBuffer.wrap(intArr).order(byteOrder).getShort();
            int16[i] = number < 0 ? (int)(Math.pow(2.0, 16.0) + (double)number) : (int)number;
        }
        return int16;
    }

    public static float[] toFloat32(byte[] arr) {
        return ByteArrayUtils.toFloat32(arr, ByteOrder.LITTLE_ENDIAN);
    }

    public static float[] toFloat32(byte[] arr, ByteOrder byteOrder) {
        float[] float32 = new float[arr.length / 4];
        for (int i = 0; i < arr.length / 4; ++i) {
            byte[] floatArr = new byte[]{arr[i * 4], arr[i * 4 + 1], arr[i * 4 + 2], arr[i * 4 + 3]};
            float32[i] = ByteBuffer.wrap(floatArr).order(byteOrder).getFloat();
        }
        return float32;
    }

    public static double[] toFloat64(byte[] arr) {
        return ByteArrayUtils.toFloat64(arr, ByteOrder.LITTLE_ENDIAN);
    }

    public static double[] toFloat64(byte[] arr, ByteOrder byteOrder) {
        double[] dd = new double[arr.length / 8];
        for (int i = 0; i < arr.length / 8; ++i) {
            byte[] doubleArr = new byte[]{arr[i * 8], arr[i * 8 + 1], arr[i * 8 + 2], arr[i * 8 + 3], arr[i * 8 + 4], arr[i * 8 + 5], arr[i * 8 + 6], arr[i * 8 + 7]};
            dd[i] = ByteBuffer.wrap(doubleArr).order(byteOrder).getDouble();
        }
        return dd;
    }

    public static long[] toInt64(byte[] arr) {
        return ByteArrayUtils.toInt64(arr, ByteOrder.LITTLE_ENDIAN);
    }

    public static long[] toInt64(byte[] arr, ByteOrder byteOrder) {
        long[] dd = new long[arr.length / 8];
        for (int i = 0; i < arr.length / 8; ++i) {
            byte[] doubleArr = new byte[]{arr[i * 8], arr[i * 8 + 1], arr[i * 8 + 2], arr[i * 8 + 3], arr[i * 8 + 4], arr[i * 8 + 5], arr[i * 8 + 6], arr[i * 8 + 7]};
            dd[i] = ByteBuffer.wrap(doubleArr).order(byteOrder).getLong();
        }
        return dd;
    }

    public static boolean[] toBoolean(byte[] arr, ByteOrder byteOrder) {
        return ByteArrayUtils.toBoolean(arr);
    }

    public static boolean[] toBoolean(byte[] arr) {
        boolean[] dd = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            dd[i] = arr[i] != 0;
        }
        return dd;
    }
}

