/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.numpy;

import io.bioimage.modelrunner.numpy.ByteArrayUtils;
import io.bioimage.modelrunner.tensor.ImgLib2ToArray;
import io.bioimage.modelrunner.tensor.Utils;
import io.bioimage.modelrunner.utils.IndexingUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.nio.ByteBufferAccess;
import net.imglib2.img.basictypeaccess.nio.DoubleBufferAccess;
import net.imglib2.img.basictypeaccess.nio.FloatBufferAccess;
import net.imglib2.img.basictypeaccess.nio.IntBufferAccess;
import net.imglib2.img.basictypeaccess.nio.LongBufferAccess;
import net.imglib2.img.basictypeaccess.nio.ShortBufferAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;
import net.imglib2.util.Util;

public class DecodeNumpy {
    private static final int BUFFER_SIZE = 0x100000;
    private static final String NUMPY_EXTENSION = ".npy";
    public static final byte[] NUMPY_PREFIX = new byte[]{-109, 78, 85, 77, 80, 89};
    public static final Map<String, Integer> DATA_TYPES_MAP = new HashMap<String, Integer>();
    public static final String DATA_KEY = "data";
    public static final String SHAPE_KEY = "shape";
    public static final String DTYPE_KEY = "dtype";
    public static final String IS_FORTRAN_ORDER_KEY = "is_fortran_order";
    public static final String BYTE_ORDER_KEY = "byte_order";
    public static final Pattern HEADER_PATTERN;

    public static <T extends RealType<T> & NativeType<T>> void main(String[] args) throws FileNotFoundException, IOException {
        String npy = "C:\\Users\\angel\\OneDrive\\Documentos\\pasteur\\test_input.npy";
        RandomAccessibleInterval rai = (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.doubles((long[])new long[]{1L, 512L, 512L}));
        DecodeNumpy.saveNpy(npy, rai);
        RandomAccessibleInterval<T> bb = DecodeNumpy.loadNpy(npy);
    }

    public static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> loadNpy(String path) throws FileNotFoundException, IOException {
        File npyFile = new File(path);
        if (!npyFile.isFile() || !path.endsWith(NUMPY_EXTENSION)) {
            throw new IllegalArgumentException("Path provided does not correspond to a Numpy file: " + path);
        }
        try (FileInputStream targetStream = new FileInputStream(npyFile);){
            RandomAccessibleInterval<T> randomAccessibleInterval = DecodeNumpy.decodeNumpyFromByteArrayStream(targetStream);
            return randomAccessibleInterval;
        }
    }

    private static HashMap<String, Object> decodeNumpyFromByteArrayStreamToRawMap(InputStream is) throws IOException {
        DataInputStream dis = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
        byte[] buf = new byte[NUMPY_PREFIX.length];
        dis.readFully(buf);
        if (!Arrays.equals(buf, NUMPY_PREFIX)) {
            throw new IllegalArgumentException("Malformed  or unsopported Numpy array");
        }
        byte major = dis.readByte();
        byte minor = dis.readByte();
        if (major < 1 || major > 3 || minor != 0) {
            throw new IllegalArgumentException("Unknown numpy version: " + major + '.' + minor);
        }
        int len = major == 1 ? 2 : 4;
        dis.readFully(buf, 0, len);
        ByteBuffer bb = ByteBuffer.wrap(buf, 0, len);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        len = major == 1 ? (int)bb.getShort() : bb.getInt();
        buf = new byte[len];
        dis.readFully(buf);
        String header = new String(buf, StandardCharsets.UTF_8);
        Matcher m = HEADER_PATTERN.matcher(header);
        if (!m.find()) {
            throw new IllegalArgumentException("Invalid numpy header: " + header);
        }
        String typeStr = m.group(1);
        String fortranOrder = m.group(2).trim();
        String shapeStr = m.group(3);
        long[] shape = new long[]{};
        if (!shapeStr.isEmpty()) {
            String[] tokens = shapeStr.split(", ?");
            shape = Arrays.stream(tokens).mapToLong(Long::parseLong).toArray();
        }
        char order = typeStr.charAt(0);
        ByteOrder byteOrder = null;
        if (order == '>') {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (order == '<') {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (order == '|') {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
            new IOException("Numpy .npy file did not specify the byte order of the array. It was automatically opened as little endian but this does not guarantee the that the file is open correctly. Caution is advised.").printStackTrace();
        } else {
            new IllegalArgumentException("Not supported ByteOrder for the provided .npy array.");
        }
        String dtype = DecodeNumpy.getDataType(typeStr.substring(1));
        long numBytes = DATA_TYPES_MAP.get(dtype).intValue();
        long count = shape.length == 0 ? 1L : Arrays.stream(shape).reduce(Math::multiplyExact).getAsLong();
        len = Math.toIntExact(count * numBytes);
        ByteBuffer data = ByteBuffer.allocate(len);
        data.order(byteOrder);
        DecodeNumpy.readData(dis, data, len);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SHAPE_KEY, shape);
        map.put(BYTE_ORDER_KEY, byteOrder);
        map.put(DTYPE_KEY, dtype);
        map.put(IS_FORTRAN_ORDER_KEY, fortranOrder.equals("True"));
        map.put(DATA_KEY, data);
        return map;
    }

    private static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> decodeNumpyFromByteArrayStream(InputStream is) throws IOException {
        DataInputStream dis = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
        byte[] buf = new byte[NUMPY_PREFIX.length];
        dis.readFully(buf);
        if (!Arrays.equals(buf, NUMPY_PREFIX)) {
            throw new IllegalArgumentException("Malformed  or unsopported Numpy array");
        }
        byte major = dis.readByte();
        byte minor = dis.readByte();
        if (major < 1 || major > 3 || minor != 0) {
            throw new IllegalArgumentException("Unknown numpy version: " + major + '.' + minor);
        }
        int len = major == 1 ? 2 : 4;
        dis.readFully(buf, 0, len);
        ByteBuffer bb = ByteBuffer.wrap(buf, 0, len);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        len = major == 1 ? (int)bb.getShort() : bb.getInt();
        buf = new byte[len];
        dis.readFully(buf);
        String header = new String(buf, StandardCharsets.UTF_8);
        Matcher m = HEADER_PATTERN.matcher(header);
        if (!m.find()) {
            throw new IllegalArgumentException("Invalid numpy header: " + header);
        }
        String typeStr = m.group(1);
        String fortranOrder = m.group(2).trim();
        String shapeStr = m.group(3);
        long[] shape = new long[]{};
        if (!shapeStr.isEmpty()) {
            String[] tokens = shapeStr.split(", ?");
            shape = Arrays.stream(tokens).mapToLong(Long::parseLong).toArray();
        }
        char order = typeStr.charAt(0);
        ByteOrder byteOrder = null;
        if (order == '>') {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (order == '<') {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (order == '|') {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            new IllegalArgumentException("Not supported ByteOrder for the provided .npy array.");
        }
        String dtype = DecodeNumpy.getDataType(typeStr.substring(1));
        long numBytes = DATA_TYPES_MAP.get(dtype).intValue();
        long count = shape.length == 0 ? 1L : Arrays.stream(shape).reduce(Math::multiplyExact).getAsLong();
        len = Math.toIntExact(count * numBytes);
        ByteBuffer data = ByteBuffer.allocate(len);
        data.order(byteOrder);
        DecodeNumpy.readData(dis, data, len);
        return DecodeNumpy.build(data, byteOrder, dtype, shape, fortranOrder.equals("True"));
    }

    public static String getDataType(String npDtype) throws IllegalArgumentException {
        if (npDtype.equals("i1") || npDtype.equals("b") || npDtype.equals("c")) {
            return "int8";
        }
        if (npDtype.equals("i2") || npDtype.equals("h")) {
            return "int16";
        }
        if (npDtype.equals("i4") || npDtype.equals("i")) {
            return "int32";
        }
        if (npDtype.equals("i8") || npDtype.equals("l") || npDtype.equals("q")) {
            return "int64";
        }
        if (npDtype.equals("b1")) {
            return "boolean";
        }
        if (npDtype.equals("u1") || npDtype.equals("B")) {
            return "uint8";
        }
        if (npDtype.equals("u2") || npDtype.equals("H")) {
            return "uint16";
        }
        if (npDtype.equals("u4") || npDtype.equals("I")) {
            return "uint32";
        }
        if (npDtype.equals("f2") || npDtype.equals("e")) {
            return "float16";
        }
        if (npDtype.equals("f") || npDtype.equals("f4")) {
            return "float32";
        }
        if (npDtype.equals("f8") || npDtype.equals("d")) {
            return "float64";
        }
        if (npDtype.equals("u8") || npDtype.equals("L") || npDtype.equals("Q")) {
            throw new IllegalArgumentException("Numpy dtype 'uint64' cannot  be supported in Java.");
        }
        if (npDtype.equals("c8")) {
            throw new IllegalArgumentException("Numpy dtype 'complex64' is not supported at the moment.");
        }
        throw new IllegalArgumentException("Numpy dtype '" + npDtype + "' is not supported at the moment.");
    }

    public static <T extends RealType<T> & NativeType<T>> String getDataType(T type) throws IllegalArgumentException {
        if (type instanceof ByteType) {
            return "i1";
        }
        if (type instanceof ShortType) {
            return "i2";
        }
        if (type instanceof IntType) {
            return "i4";
        }
        if (type instanceof LongType) {
            return "i8";
        }
        if (type instanceof UnsignedByteType) {
            return "u1";
        }
        if (type instanceof UnsignedShortType) {
            return "u2";
        }
        if (type instanceof UnsignedIntType) {
            return "u4";
        }
        if (type instanceof FloatType) {
            return "f4";
        }
        if (type instanceof DoubleType) {
            return "f8";
        }
        throw new IllegalArgumentException("Numpy dtype '" + type.getClass() + "' is not supported at the moment.");
    }

    private static void readData(DataInputStream dis, ByteBuffer data, int len) throws IOException {
        if (len > 0) {
            byte[] buf = new byte[0x100000];
            while (len > 0x100000) {
                dis.readFully(buf);
                data.put(buf);
                len -= 0x100000;
            }
            dis.readFully(buf, 0, len);
            data.put(buf, 0, len);
            data.rewind();
        }
    }

    private static <T extends NativeType<T>> RandomAccessibleInterval<T> build(ByteBuffer buf, ByteOrder byteOrder, String dtype, long[] shape, boolean fortranOrder) throws IllegalArgumentException {
        long[] transposedShape = new long[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            transposedShape[i] = shape[shape.length - i - 1];
        }
        if (dtype.equals("int8") && !fortranOrder) {
            ByteBufferAccess access = new ByteBufferAccess(buf, true);
            return Utils.transpose(ArrayImgs.bytes((ByteAccess)access, (long[])transposedShape));
        }
        if (dtype.equals("int8")) {
            ByteBufferAccess access = new ByteBufferAccess(buf, true);
            return ArrayImgs.bytes((ByteAccess)access, (long[])shape);
        }
        if (dtype.equals("uint8") && !fortranOrder) {
            ByteBufferAccess access = new ByteBufferAccess(buf, true);
            return Utils.transpose(ArrayImgs.unsignedBytes((ByteAccess)access, (long[])transposedShape));
        }
        if (dtype.equals("uint8")) {
            ByteBufferAccess access = new ByteBufferAccess(buf, true);
            return ArrayImgs.unsignedBytes((ByteAccess)access, (long[])shape);
        }
        if (dtype.equals("int16") && !fortranOrder) {
            ShortBufferAccess access = new ShortBufferAccess(buf, true);
            return Utils.transpose(ArrayImgs.shorts((ShortAccess)access, (long[])transposedShape));
        }
        if (dtype.equals("int16")) {
            ShortBufferAccess access = new ShortBufferAccess(buf, true);
            return ArrayImgs.shorts((ShortAccess)access, (long[])shape);
        }
        if (dtype.equals("uint16") && !fortranOrder) {
            ShortBufferAccess access = new ShortBufferAccess(buf, true);
            return Utils.transpose(ArrayImgs.unsignedShorts((ShortAccess)access, (long[])transposedShape));
        }
        if (dtype.equals("uint16")) {
            ShortBufferAccess access = new ShortBufferAccess(buf, true);
            return ArrayImgs.unsignedShorts((ShortAccess)access, (long[])shape);
        }
        if (dtype.equals("int32") && !fortranOrder) {
            IntBufferAccess access = new IntBufferAccess(buf, true);
            return Utils.transpose(ArrayImgs.ints((IntAccess)access, (long[])transposedShape));
        }
        if (dtype.equals("int32")) {
            IntBufferAccess access = new IntBufferAccess(buf, true);
            return ArrayImgs.ints((IntAccess)access, (long[])shape);
        }
        if (dtype.equals("uint32") && !fortranOrder) {
            IntBufferAccess access = new IntBufferAccess(buf, true);
            return Utils.transpose(ArrayImgs.unsignedInts((IntAccess)access, (long[])transposedShape));
        }
        if (dtype.equals("uint32")) {
            IntBufferAccess access = new IntBufferAccess(buf, true);
            return ArrayImgs.unsignedInts((IntAccess)access, (long[])shape);
        }
        if (dtype.equals("int64") && !fortranOrder) {
            LongBufferAccess access = new LongBufferAccess(buf, true);
            return Utils.transpose(ArrayImgs.longs((LongAccess)access, (long[])transposedShape));
        }
        if (dtype.equals("int64")) {
            LongBufferAccess access = new LongBufferAccess(buf, true);
            return ArrayImgs.longs((LongAccess)access, (long[])shape);
        }
        if (dtype.equals("float32") && !fortranOrder) {
            FloatBufferAccess access = new FloatBufferAccess(buf, true);
            return Utils.transpose(ArrayImgs.floats((FloatAccess)access, (long[])transposedShape));
        }
        if (dtype.equals("float32")) {
            FloatBufferAccess access = new FloatBufferAccess(buf, true);
            return ArrayImgs.floats((FloatAccess)access, (long[])shape);
        }
        if (dtype.equals("float64") && !fortranOrder) {
            DoubleBufferAccess access = new DoubleBufferAccess(buf, true);
            return Utils.transpose(ArrayImgs.doubles((DoubleAccess)access, (long[])transposedShape));
        }
        if (dtype.equals("float64")) {
            DoubleBufferAccess access = new DoubleBufferAccess(buf, true);
            return ArrayImgs.doubles((DoubleAccess)access, (long[])shape);
        }
        if (dtype.equals("bool") && !fortranOrder) {
            return Utils.transpose(DecodeNumpy.buildBoolean(buf, byteOrder, transposedShape));
        }
        if (dtype.equals("bool")) {
            return DecodeNumpy.buildBoolean(buf, byteOrder, shape);
        }
        throw new IllegalArgumentException("Unsupported data type of numpy array: " + dtype);
    }

    private static Img<ByteType> buildBoolean(ByteBuffer buf, ByteOrder byteOrder, long[] shape) {
        buf.order(byteOrder);
        ArrayImgFactory factory = new ArrayImgFactory((NativeType)new ByteType());
        ArrayImg outputImg = factory.create(shape);
        Cursor tensorCursor = outputImg.cursor();
        boolean[] flatArr = ByteArrayUtils.toBoolean(buf.array(), byteOrder);
        while (tensorCursor.hasNext()) {
            tensorCursor.fwd();
            long[] cursorPos = tensorCursor.positionAsLongArray();
            int flatPos = IndexingUtils.multidimensionalIntoFlatIndex(cursorPos, shape);
            ((ByteType)tensorCursor.get()).set((byte)(flatArr[flatPos] ? 1 : 0));
        }
        return outputImg;
    }

    public static <T extends RealType<T> & NativeType<T>> long calculateNpyStyleByteArrayLength(RandomAccessibleInterval<T> rai, boolean fortranOrder) {
        String strHeader = "{'descr': '<";
        strHeader = strHeader + DecodeNumpy.getDataType((RealType)rai.getAt(rai.minAsLongArray()));
        strHeader = strHeader + "', 'fortran_order': " + (fortranOrder ? "True" : "False") + ", 'shape': (";
        for (long ll : rai.dimensionsAsLongArray()) {
            strHeader = strHeader + ll + ", ";
        }
        strHeader = strHeader.substring(0, strHeader.length() - 2);
        strHeader = strHeader + "), }" + System.lineSeparator();
        byte[] bufInverse = strHeader.getBytes(StandardCharsets.UTF_8);
        byte[] len = new byte[]{(byte)strHeader.length(), (byte)((short)strHeader.length() >> 8)};
        long flatSize = 1L;
        for (long ss : rai.dimensionsAsLongArray()) {
            flatSize *= ss;
        }
        if (Util.getTypeFromInterval(rai) instanceof ByteType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize;
        }
        if (Util.getTypeFromInterval(rai) instanceof UnsignedByteType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize;
        }
        if (Util.getTypeFromInterval(rai) instanceof ShortType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 2L;
        }
        if (Util.getTypeFromInterval(rai) instanceof UnsignedShortType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 2L;
        }
        if (Util.getTypeFromInterval(rai) instanceof IntType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 4L;
        }
        if (Util.getTypeFromInterval(rai) instanceof UnsignedIntType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 4L;
        }
        if (Util.getTypeFromInterval(rai) instanceof LongType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 8L;
        }
        if (Util.getTypeFromInterval(rai) instanceof FloatType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 4L;
        }
        if (Util.getTypeFromInterval(rai) instanceof DoubleType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 8L;
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    public static <T extends RealType<T> & NativeType<T>> long calculateNpyStyleByteArrayLength(long[] shape, T datatype, boolean fortranOrder) {
        String strHeader = "{'descr': '<";
        strHeader = strHeader + DecodeNumpy.getDataType(datatype);
        strHeader = strHeader + "', 'fortran_order': " + (fortranOrder ? "True" : "False") + ", 'shape': (";
        for (long ll : shape) {
            strHeader = strHeader + ll + ", ";
        }
        strHeader = strHeader.substring(0, strHeader.length() - 2);
        strHeader = strHeader + "), }" + System.lineSeparator();
        byte[] bufInverse = strHeader.getBytes(StandardCharsets.UTF_8);
        byte[] len = new byte[]{(byte)strHeader.length(), (byte)((short)strHeader.length() >> 8)};
        long flatSize = 1L;
        for (long ss : shape) {
            flatSize *= ss;
        }
        if (datatype instanceof ByteType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize;
        }
        if (datatype instanceof UnsignedByteType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize;
        }
        if (datatype instanceof ShortType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 2L;
        }
        if (datatype instanceof UnsignedShortType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 2L;
        }
        if (datatype instanceof IntType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 4L;
        }
        if (datatype instanceof UnsignedIntType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 4L;
        }
        if (datatype instanceof LongType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 8L;
        }
        if (datatype instanceof FloatType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 4L;
        }
        if (datatype instanceof DoubleType) {
            return (long)(NUMPY_PREFIX.length + 2 + 2 + bufInverse.length) + flatSize * 8L;
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    public static <T extends RealType<T> & NativeType<T>> byte[] createNumpyStyleByteArray(RandomAccessibleInterval<T> rai) {
        int i;
        Buffer intBuffer;
        byte[] array;
        ByteBuffer byteBuffer;
        Object[] data;
        String strHeader = "{'descr': '<";
        strHeader = strHeader + DecodeNumpy.getDataType((RealType)rai.getAt(rai.minAsLongArray()));
        strHeader = strHeader + "', 'fortran_order': False, 'shape': (";
        for (long ll : rai.dimensionsAsLongArray()) {
            strHeader = strHeader + ll + ", ";
        }
        strHeader = strHeader.substring(0, strHeader.length() - 2);
        strHeader = strHeader + "), }" + System.lineSeparator();
        byte[] bufInverse = strHeader.getBytes(StandardCharsets.UTF_8);
        byte[] major = new byte[]{1};
        byte[] minor = new byte[]{0};
        byte[] len = new byte[]{(byte)strHeader.length(), (byte)((short)strHeader.length() >> 8)};
        if (Util.getTypeFromInterval(rai) instanceof ByteType) {
            data = (byte[])ImgLib2ToArray.build(rai);
            byteBuffer = ByteBuffer.allocate(data.length).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put((byte[])data);
            array = byteBuffer.array();
        } else if (Util.getTypeFromInterval(rai) instanceof UnsignedByteType) {
            data = (byte[])ImgLib2ToArray.build(rai);
            byteBuffer = ByteBuffer.allocate(data.length).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put((byte[])data);
            array = byteBuffer.array();
        } else if (Util.getTypeFromInterval(rai) instanceof ShortType) {
            data = (short[])ImgLib2ToArray.build(rai);
            byteBuffer = ByteBuffer.allocate(data.length * 2).order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asShortBuffer();
            ((ShortBuffer)intBuffer).put((short[])data);
            array = byteBuffer.array();
        } else if (Util.getTypeFromInterval(rai) instanceof UnsignedShortType) {
            data = (short[])ImgLib2ToArray.build(rai);
            byteBuffer = ByteBuffer.allocate(data.length * 2).order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asShortBuffer();
            ((ShortBuffer)intBuffer).put((short[])data);
            array = byteBuffer.array();
        } else if (Util.getTypeFromInterval(rai) instanceof IntType) {
            data = (int[])ImgLib2ToArray.build(rai);
            byteBuffer = ByteBuffer.allocate(data.length * 4).order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
            ((IntBuffer)intBuffer).put((int[])data);
            array = byteBuffer.array();
        } else if (Util.getTypeFromInterval(rai) instanceof UnsignedIntType) {
            data = (int[])ImgLib2ToArray.build(rai);
            byteBuffer = ByteBuffer.allocate(data.length * 4).order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
            ((IntBuffer)intBuffer).put((int[])data);
            array = byteBuffer.array();
        } else if (Util.getTypeFromInterval(rai) instanceof LongType) {
            data = (long[])ImgLib2ToArray.build(rai);
            byteBuffer = ByteBuffer.allocate(data.length * 8).order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asLongBuffer();
            ((LongBuffer)intBuffer).put((long[])data);
            array = byteBuffer.array();
        } else if (Util.getTypeFromInterval(rai) instanceof FloatType) {
            data = (float[])ImgLib2ToArray.build(rai);
            byteBuffer = ByteBuffer.allocate(data.length * 4).order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asFloatBuffer();
            ((FloatBuffer)intBuffer).put((float[])data);
            array = byteBuffer.array();
        } else if (Util.getTypeFromInterval(rai) instanceof DoubleType) {
            data = (double[])ImgLib2ToArray.build(rai);
            byteBuffer = ByteBuffer.allocate(data.length * 8).order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asDoubleBuffer();
            ((DoubleBuffer)intBuffer).put((double[])data);
            array = byteBuffer.array();
        } else {
            throw new IllegalArgumentException("Unsupported data type");
        }
        int totalLen = NUMPY_PREFIX.length + 2 + 2 + bufInverse.length + array.length;
        byte[] total = new byte[totalLen];
        int c = 0;
        for (i = 0; i < NUMPY_PREFIX.length; ++i) {
            total[c++] = NUMPY_PREFIX[i];
        }
        total[c++] = major[0];
        total[c++] = minor[0];
        total[c++] = len[0];
        total[c++] = len[1];
        for (i = 0; i < bufInverse.length; ++i) {
            total[c++] = bufInverse[i];
        }
        for (i = 0; i < array.length; ++i) {
            total[c++] = array[i];
        }
        return total;
    }

    public static <T extends RealType<T> & NativeType<T>> void saveNpy(String filePath, RandomAccessibleInterval<T> rai) throws FileNotFoundException, IOException {
        byte[] total = DecodeNumpy.createNumpyStyleByteArray(rai);
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            fos.write(total);
        }
    }

    static {
        DATA_TYPES_MAP.put("boolean", 1);
        DATA_TYPES_MAP.put("int8", 1);
        DATA_TYPES_MAP.put("uint8", 1);
        DATA_TYPES_MAP.put("int16", 2);
        DATA_TYPES_MAP.put("uint16", 2);
        DATA_TYPES_MAP.put("int32", 4);
        DATA_TYPES_MAP.put("uint32", 4);
        DATA_TYPES_MAP.put("int64", 8);
        DATA_TYPES_MAP.put("float16", 2);
        DATA_TYPES_MAP.put("float32", 4);
        DATA_TYPES_MAP.put("float64", 8);
        HEADER_PATTERN = Pattern.compile("\\{'descr': '(.+)', 'fortran_order': (True|False), 'shape': \\((.+?)\\)(?:\\s*,\\s*|\\s*)\\}");
    }
}

