/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.runmode;

import io.bioimage.modelrunner.download.MultiFileDownloader;

public class RunModeScripts {
    protected static final String AXES_KEY = "axes";
    protected static final String SHAPE_KEY = "shape";
    protected static final String DATA_KEY = "data";
    protected static final String NAME_KEY = "name";
    protected static final String DTYPE_KEY = "dtype";
    protected static final String NP_METHOD = "convertNpIntoDic";
    protected static final String XR_METHOD = "convertXrIntoDic";
    protected static final String LIST_METHOD = "convertListIntoSupportedList";
    protected static final String DICT_METHOD = "convertDicIntoDic";
    protected static final String APPOSE_DT_KEY = MultiFileDownloader.addTimeStampToFileName("appose_data_type_", true);
    protected static final String TENSOR_KEY = "tensor";
    protected static final String IS_FORTRAN_KEY = "is_fortran";
    protected static final String NP_ARR_KEY = "np_arr";
    protected static final String SHARED_MEM_PACKAGE_NAME = "shared_memory";
    protected static final String NP_PACKAGE_NAME = "np";
    protected static final String UNLINK_AND_CLOSE_SHM = "for sh_mem in shm_out_list:" + System.lineSeparator() + "\ttry:" + System.lineSeparator() + "\t\tsh_mem.close()" + System.lineSeparator() + "\t\tsh_mem.unlink()" + System.lineSeparator() + "\texcept FileNotFoundError:" + System.lineSeparator() + "\t\tpass" + System.lineSeparator();
    protected static final String TYPE_CONVERSION_METHODS_SCRIPT = "def convertNpIntoDic(np_arr):" + System.lineSeparator() + "  shm = shared_memory.SharedMemory(create=True, size=np_arr.nbytes)" + System.lineSeparator() + "  aux_np_arr = np.ndarray((np_arr.size), dtype=np_arr.dtype, buffer=shm.buf)" + System.lineSeparator() + "  aux_np_arr[:] = np_arr.flatten()" + System.lineSeparator() + "  shm_out_list.append(shm)" + System.lineSeparator() + "  return {\"" + "data" + "\": shm.name, \"" + "shape" + "\": np_arr.shape, \"" + APPOSE_DT_KEY + "\": \"" + "np_arr" + "\", \"" + "is_fortran" + "\": np.isfortran(np_arr), \"" + "dtype" + "\": str(np_arr.dtype)}" + System.lineSeparator() + "" + System.lineSeparator() + "def " + "convertXrIntoDic" + "(xr_arr):" + System.lineSeparator() + "  shm = shared_memory.SharedMemory(create=True, size=xr_arr.values.nbytes)" + System.lineSeparator() + "  aux_np_arr = np.ndarray((xr_arr.values.size), dtype=xr_arr.values.dtype, buffer=shm.buf)" + System.lineSeparator() + "  aux_np_arr[:] = xr_arr.values.flatten()" + System.lineSeparator() + "  shm_out_list.append(shm)" + System.lineSeparator() + "  return {\"" + "data" + "\": shm.name, \"" + "shape" + "\": xr_arr.shape, \"" + "axes" + "\": \"\".join(xr_arr.dims),\"" + "name" + "\": xr_arr.name, \"" + APPOSE_DT_KEY + "\": \"" + "tensor" + "\", \"" + "is_fortran" + "\": np.isfortran(xr_arr.values), \"" + "dtype" + "\": str(xr_arr.values.dtype)}" + System.lineSeparator() + "" + System.lineSeparator() + "def " + "convertXrIntoDic" + "_file(xr_arr):" + System.lineSeparator() + "  import os" + System.lineSeparator() + "  import uuid" + System.lineSeparator() + "  file_name = str(uuid.uuid4()) + \".npy\"" + System.lineSeparator() + "  np.save(os.path.join(os.getcwd(), file_name), xr_arr.values)" + System.lineSeparator() + "  return {\"" + "axes" + "\": \"\".join(xr_arr.dims),\"" + "name" + "\": xr_arr.name, \"" + APPOSE_DT_KEY + "\": \"tensor_file\", \"file_path\": os.path.join(os.getcwd(), file_name)}" + System.lineSeparator() + "" + System.lineSeparator() + "def " + "convertListIntoSupportedList" + "(list_ob):" + System.lineSeparator() + "  n_list = []" + System.lineSeparator() + "  for value in list_ob:" + System.lineSeparator() + "    if str(type(value)) == \"<class 'xarray.core.dataarray.DataArray'>\":" + System.lineSeparator() + "      n_list.append(" + "convertXrIntoDic" + "(value))" + System.lineSeparator() + "    elif str(type(value)) == \"<class 'numpy.ndarray'>\":" + System.lineSeparator() + "      n_list.append(" + "convertNpIntoDic" + "(value))" + System.lineSeparator() + "    elif isinstance(value, dict):" + System.lineSeparator() + "      n_list.append(" + "convertDicIntoDic" + "(value))" + System.lineSeparator() + "    elif isinstance(value, list):" + System.lineSeparator() + "      n_list.append(" + "convertListIntoSupportedList" + "(value))" + System.lineSeparator() + "    elif str(type(value)) == \"<class 'numpy.float32'>\" or str(type(value)) == \"<class 'numpy.float16'>\" or str(type(value)) == \"<class 'numpy.float64'>\":" + System.lineSeparator() + "      n_list.append(float(value))" + System.lineSeparator() + "    elif str(type(value)) == \"<class 'numpy.int8'>\" or str(type(value)) == \"<class 'numpy.uint8'>\" or str(type(value)) == \"<class 'numpy.int16'>\" or str(type(value)) == \"<class 'numpy.uint16'>\" or str(type(value)) == \"<class 'numpy.int32'>\" or str(type(value)) == \"<class 'numpy.uint32'>\" or str(type(value)) == \"<class 'numpy.int64'>\":" + System.lineSeparator() + "      n_list.append(int(value))" + System.lineSeparator() + "    elif str(type(value)) == \"<class 'numpy.str_'>\":" + System.lineSeparator() + "      n_list.append(str(value))" + System.lineSeparator() + "    elif str(type(value)) == \"<class 'numpy.bool_'>\":" + System.lineSeparator() + "      n_list.append(bool(value))" + System.lineSeparator() + "    else:" + System.lineSeparator() + "      n_list.append(value)" + System.lineSeparator() + "  return n_list" + System.lineSeparator() + "" + System.lineSeparator() + "def " + "convertDicIntoDic" + "(dic):" + System.lineSeparator() + "  n_dic = {}" + System.lineSeparator() + "  for key, value in dic.items():" + System.lineSeparator() + "    if str(type(value)) == \"<class 'xarray.core.dataarray.DataArray'>\":" + System.lineSeparator() + "      n_dic[key] = " + "convertXrIntoDic" + "(value)" + System.lineSeparator() + "    elif str(type(value)) == \"<class 'numpy.ndarray'>\":" + System.lineSeparator() + "      n_dic[key] = " + "convertNpIntoDic" + "(value)" + System.lineSeparator() + "    elif isinstance(value, dict):" + System.lineSeparator() + "      n_dic[key] = " + "convertDicIntoDic" + "(value)" + System.lineSeparator() + "    elif isinstance(value, list):" + System.lineSeparator() + "      n_dic[key] = " + "convertListIntoSupportedList" + "(value)" + System.lineSeparator() + "    elif str(type(value)) == \"<class 'numpy.float32'>\" or str(type(value)) == \"<class 'numpy.float16'>\" or str(type(value)) == \"<class 'numpy.float64'>\":" + System.lineSeparator() + "      n_dic[key] = float(value)" + System.lineSeparator() + "    elif str(type(value)) == \"<class 'numpy.int8'>\" or str(type(value)) == \"<class 'numpy.uint8'>\" or str(type(value)) == \"<class 'numpy.int16'>\" or str(type(value)) == \"<class 'numpy.uint16'>\" or str(type(value)) == \"<class 'numpy.int32'>\" or str(type(value)) == \"<class 'numpy.uint32'>\" or str(type(value)) == \"<class 'numpy.int64'>\":" + System.lineSeparator() + "      n_dic[key] = int(value)" + System.lineSeparator() + "    elif str(type(value)) == \"<class 'numpy.str_'>\":" + System.lineSeparator() + "      n_dic[key] = str(value)" + System.lineSeparator() + "    elif str(type(value)) == \"<class 'numpy.bool_'>\":" + System.lineSeparator() + "      n_dic[key] = bool(value)" + System.lineSeparator() + "    else:" + System.lineSeparator() + "      n_dic[key] = value" + System.lineSeparator() + "  return n_dic" + System.lineSeparator() + "globals()['" + "convertXrIntoDic" + "'] = " + "convertXrIntoDic" + System.lineSeparator() + "globals()['" + "convertNpIntoDic" + "'] = " + "convertNpIntoDic" + System.lineSeparator() + "globals()['" + "convertDicIntoDic" + "'] = " + "convertDicIntoDic" + System.lineSeparator() + "globals()['" + "convertListIntoSupportedList" + "'] = " + "convertListIntoSupportedList" + System.lineSeparator() + "globals()['" + "np" + "'] = " + "np" + System.lineSeparator() + "globals()['" + "shared_memory" + "'] = " + "shared_memory" + System.lineSeparator();
}

