/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.tensor;

import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.tensor.Utils;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;

public final class ListToImgLib2 {
    private ListToImgLib2() {
    }

    public static <T extends RealType<T> & NativeType<T>> Tensor<T> buildTensor(List<?> array, List<Integer> shape, String axes, String dtype, String name) throws IllegalArgumentException {
        return Tensor.build(name, axes, ListToImgLib2.build(array, shape, dtype));
    }

    public static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> build(List<?> array, List<Integer> shape, String dtype) throws IllegalArgumentException {
        Img data;
        if (shape.size() == 0 || array.size() == 0) {
            return null;
        }
        switch (dtype) {
            case "int8": {
                data = (Img)Cast.unchecked(ListToImgLib2.buildInt8(array, shape));
                break;
            }
            case "uint8": {
                data = (Img)Cast.unchecked(ListToImgLib2.buildUint8(array, shape));
                break;
            }
            case "int16": {
                data = (Img)Cast.unchecked(ListToImgLib2.buildInt16(array, shape));
                break;
            }
            case "uint16": {
                data = (Img)Cast.unchecked(ListToImgLib2.buildUint16(array, shape));
                break;
            }
            case "int32": {
                data = (Img)Cast.unchecked(ListToImgLib2.buildInt32(array, shape));
                break;
            }
            case "uint32": {
                data = (Img)Cast.unchecked(ListToImgLib2.buildUint32(array, shape));
                break;
            }
            case "int64": {
                data = (Img)Cast.unchecked(ListToImgLib2.buildInt64(array, shape));
                break;
            }
            case "float32": {
                data = (Img)Cast.unchecked(ListToImgLib2.buildFloat32(array, shape));
                break;
            }
            case "float64": {
                data = (Img)Cast.unchecked(ListToImgLib2.buildFloat64(array, shape));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tensor type: " + dtype);
            }
        }
        return data;
    }

    private static RandomAccessibleInterval<ByteType> buildInt8(List array, List<Integer> tensorShape) throws IllegalArgumentException {
        if (!(array.get(0) instanceof Byte) && !(array.get(0) instanceof Integer)) {
            throw new IllegalArgumentException("Unable to build ImgLib2 array of data type 'int8' using Java array of class: " + array.get(0).getClass());
        }
        if (array.get(0) instanceof Integer) {
            return ListToImgLib2.buildInt8FromInteger(array, tensorShape);
        }
        return ListToImgLib2.buildInt8FromByte(array, tensorShape);
    }

    private static RandomAccessibleInterval<ByteType> buildInt8FromByte(List<Byte> tensor, List<Integer> tensorShape) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(tensor.size());
        tensor.forEach(baos::write);
        long[] shape = new long[tensorShape.size()];
        ArrayImg rai = ArrayImgs.bytes((byte[])baos.toByteArray(), (long[])shape);
        return Utils.transpose(rai);
    }

    private static RandomAccessibleInterval<ByteType> buildInt8FromInteger(List<Integer> tensor, List<Integer> tensorShape) {
        byte[] bytes = new byte[tensor.size()];
        int c = 0;
        for (Integer n : tensor) {
            bytes[c++] = n.byteValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.bytes((byte[])bytes, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<UnsignedByteType> buildUint8(List array, List<Integer> tensorShape) throws IllegalArgumentException {
        if (!(array.get(0) instanceof Byte) && !(array.get(0) instanceof Integer)) {
            throw new IllegalArgumentException("Unable to build ImgLib2 array of data type 'int8' using Java array of class: " + array.get(0).getClass());
        }
        if (array.get(0) instanceof Byte) {
            return ListToImgLib2.buildUint8FromByte(array, tensorShape);
        }
        return ListToImgLib2.buildUint8FromInteger(array, tensorShape);
    }

    private static RandomAccessibleInterval<UnsignedByteType> buildUint8FromByte(List<Byte> tensor, List<Integer> tensorShape) {
        byte[] bytes = new byte[tensor.size()];
        int c = 0;
        for (Byte by : tensor) {
            bytes[c++] = by;
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.unsignedBytes((byte[])bytes, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<UnsignedByteType> buildUint8FromInteger(List<Integer> tensor, List<Integer> tensorShape) {
        byte[] bytes = new byte[tensor.size()];
        int c = 0;
        for (Integer n : tensor) {
            bytes[c++] = n.byteValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.unsignedBytes((byte[])bytes, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<ShortType> buildInt16(List array, List<Integer> tensorShape) throws IllegalArgumentException {
        if (!(array.get(0) instanceof Short) && !(array.get(0) instanceof Integer)) {
            throw new IllegalArgumentException("Unable to build ImgLib2 array of data type 'int16' using Java array of class: " + array.get(0).getClass());
        }
        if (array.get(0) instanceof Short) {
            return ListToImgLib2.buildInt16FromShort(array, tensorShape);
        }
        return ListToImgLib2.buildInt16FromInteger(array, tensorShape);
    }

    private static RandomAccessibleInterval<ShortType> buildInt16FromShort(List<Short> tensor, List<Integer> tensorShape) {
        short[] shorts = new short[tensor.size()];
        int c = 0;
        for (Short s : tensor) {
            shorts[c++] = s;
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.shorts((short[])shorts, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<ShortType> buildInt16FromInteger(List<Integer> tensor, List<Integer> tensorShape) {
        short[] shorts = new short[tensor.size()];
        int c = 0;
        for (Integer n : tensor) {
            shorts[c++] = n.shortValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.shorts((short[])shorts, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<UnsignedShortType> buildUint16(List array, List<Integer> tensorShape) throws IllegalArgumentException {
        if (!(array.get(0) instanceof Short) && !(array.get(0) instanceof Integer)) {
            throw new IllegalArgumentException("Unable to build ImgLib2 array of data type 'uint16' using Java array of class: " + array.get(0).getClass());
        }
        if (array.get(0) instanceof Short) {
            return ListToImgLib2.buildUint16FromShort(array, tensorShape);
        }
        return ListToImgLib2.buildUint16FromInteger(array, tensorShape);
    }

    private static RandomAccessibleInterval<UnsignedShortType> buildUint16FromShort(List<Short> tensor, List<Integer> tensorShape) {
        short[] shorts = new short[tensor.size()];
        int c = 0;
        for (Short s : tensor) {
            shorts[c++] = s;
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.unsignedShorts((short[])shorts, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<UnsignedShortType> buildUint16FromInteger(List<Integer> tensor, List<Integer> tensorShape) {
        short[] shorts = new short[tensor.size()];
        int c = 0;
        for (Integer n : tensor) {
            shorts[c++] = n.shortValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.unsignedShorts((short[])shorts, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<IntType> buildInt32(List array, List<Integer> tensorShape) throws IllegalArgumentException {
        if (!(array.get(0) instanceof Integer)) {
            throw new IllegalArgumentException("Unable to build ImgLib2 array of data type 'int32' using Java array of class: " + array.get(0).getClass());
        }
        return ListToImgLib2.buildInt32FromInteger(array, tensorShape);
    }

    private static RandomAccessibleInterval<IntType> buildInt32FromInteger(List<Integer> tensor, List<Integer> tensorShape) {
        int[] ints = new int[tensor.size()];
        int c = 0;
        for (Integer n : tensor) {
            ints[c++] = n;
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.ints((int[])ints, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<UnsignedIntType> buildUint32(List array, List<Integer> tensorShape) throws IllegalArgumentException {
        if (!(array.get(0) instanceof Long) && !(array.get(0) instanceof Integer)) {
            throw new IllegalArgumentException("Unable to build ImgLib2 array of data type 'uint32' using Java array of class: " + array.get(0).getClass());
        }
        if (array.get(0) instanceof Long) {
            return ListToImgLib2.buildUint32FromLong(array, tensorShape);
        }
        return ListToImgLib2.buildUint32FromInteger(array, tensorShape);
    }

    private static RandomAccessibleInterval<UnsignedIntType> buildUint32FromInteger(List<Integer> tensor, List<Integer> tensorShape) {
        int[] ints = new int[tensor.size()];
        int c = 0;
        for (Integer n : tensor) {
            ints[c++] = n;
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.unsignedInts((int[])ints, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<UnsignedIntType> buildUint32FromLong(List<Long> tensor, List<Integer> tensorShape) {
        int[] ints = new int[tensor.size()];
        int c = 0;
        for (Long l : tensor) {
            ints[c++] = l.intValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.unsignedInts((int[])ints, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<LongType> buildInt64(List array, List<Integer> tensorShape) throws IllegalArgumentException {
        if (!(array.get(0) instanceof Long) && !(array.get(0) instanceof Integer)) {
            throw new IllegalArgumentException("Unable to build ImgLib2 array of data type 'int64' using Java array of class: " + array.get(0).getClass());
        }
        if (array.get(0) instanceof Long) {
            return ListToImgLib2.buildInt64FromLong(array, tensorShape);
        }
        return ListToImgLib2.buildInt64FromInteger(array, tensorShape);
    }

    private static RandomAccessibleInterval<LongType> buildInt64FromLong(List<Long> tensor, List<Integer> tensorShape) {
        long[] longs = new long[tensor.size()];
        int c = 0;
        for (Long l : tensor) {
            longs[c++] = l;
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.longs((long[])longs, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<LongType> buildInt64FromInteger(List<Integer> tensor, List<Integer> tensorShape) {
        long[] longs = new long[tensor.size()];
        int c = 0;
        for (Integer n : tensor) {
            longs[c++] = n.longValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.longs((long[])longs, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<FloatType> buildFloat32(List array, List<Integer> tensorShape) throws IllegalArgumentException {
        if (!(array.get(0) instanceof Float) && !(array.get(0) instanceof BigDecimal)) {
            throw new IllegalArgumentException("Unable to build ImgLib2 array of data type 'float32' using Java array of class: " + array.get(0).getClass());
        }
        if (array.get(0) instanceof Float) {
            return ListToImgLib2.buildFloat32FromFloat(array, tensorShape);
        }
        return ListToImgLib2.buildFloat32FromBigDecimal(array, tensorShape);
    }

    private static RandomAccessibleInterval<FloatType> buildFloat32FromFloat(List<Float> tensor, List<Integer> tensorShape) {
        float[] floats = new float[tensor.size()];
        int c = 0;
        for (Float f : tensor) {
            floats[c++] = f.floatValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.floats((float[])floats, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<FloatType> buildFloat32FromBigDecimal(List<BigDecimal> tensor, List<Integer> tensorShape) {
        float[] floats = new float[tensor.size()];
        int c = 0;
        for (BigDecimal bigDecimal : tensor) {
            floats[c++] = bigDecimal.floatValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.floats((float[])floats, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<DoubleType> buildFloat64(List array, List<Integer> tensorShape) throws IllegalArgumentException {
        if (!(array.get(0) instanceof Float || array.get(0) instanceof Double || array.get(0) instanceof BigDecimal)) {
            throw new IllegalArgumentException("Unable to build ImgLib2 array of data type 'float64' using Java array of class: " + array.get(0).getClass());
        }
        if (array.get(0) instanceof Float) {
            return ListToImgLib2.buildFloat64FromFloat(array, tensorShape);
        }
        if (array.get(0) instanceof Double) {
            return ListToImgLib2.buildFloat64FromDouble(array, tensorShape);
        }
        return ListToImgLib2.buildFloat64FromBigDecimal(array, tensorShape);
    }

    private static RandomAccessibleInterval<DoubleType> buildFloat64FromDouble(List<Double> tensor, List<Integer> tensorShape) {
        double[] doubles = new double[tensor.size()];
        int c = 0;
        for (Double d : tensor) {
            doubles[c++] = d.byteValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.doubles((double[])doubles, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<DoubleType> buildFloat64FromFloat(List<Float> tensor, List<Integer> tensorShape) {
        double[] doubles = new double[tensor.size()];
        int c = 0;
        for (Float f : tensor) {
            doubles[c++] = f.doubleValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.doubles((double[])doubles, (long[])shape);
        return Utils.transpose(arrayImg);
    }

    private static RandomAccessibleInterval<DoubleType> buildFloat64FromBigDecimal(List<BigDecimal> tensor, List<Integer> tensorShape) {
        double[] doubles = new double[tensor.size()];
        int c = 0;
        for (BigDecimal bigDecimal : tensor) {
            doubles[c++] = bigDecimal.byteValue();
        }
        long[] shape = new long[tensorShape.size()];
        c = 0;
        for (Integer it : tensorShape) {
            shape[c++] = it.longValue();
        }
        ArrayImg arrayImg = ArrayImgs.doubles((double[])doubles, (long[])shape);
        return Utils.transpose(arrayImg);
    }
}

