/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.tensor;

import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.transform.integer.Mixed;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;

public final class Utils {
    public static <T extends NumericType<T> & RealType<T>> RandomAccessibleInterval<T> transpose(RandomAccessibleInterval<T> rai) {
        long[] max = rai.maxAsPoint().positionAsLongArray();
        long[] min = rai.minAsPoint().positionAsLongArray();
        long[] tensorShape = rai.dimensionsAsLongArray();
        MixedTransform t = new MixedTransform(tensorShape.length, tensorShape.length);
        int[] transposeAxesOrderChange = new int[tensorShape.length];
        for (int i = 0; i < tensorShape.length; ++i) {
            transposeAxesOrderChange[i] = tensorShape.length - 1 - i;
        }
        t.setComponentMapping(transposeAxesOrderChange);
        long[] minMax = new long[tensorShape.length * 2];
        for (int i = 0; i < tensorShape.length; ++i) {
            minMax[i] = min[tensorShape.length - i - 1];
            minMax[i + tensorShape.length] = max[tensorShape.length - i - 1];
        }
        return Views.interval((RandomAccessible)new MixedTransformView(rai, (Mixed)t), (Interval)Intervals.createMinMax((long[])minMax));
    }

    public static <T extends NumericType<T> & RealType<T>> RandomAccessibleInterval<T> rearangeAxes(RandomAccessibleInterval<T> rai, int[] orderChange) {
        int n = rai.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        int[] invOrderChange = new int[n];
        for (int i = 0; i < n; ++i) {
            min[i] = rai.min(orderChange[i]);
            max[i] = rai.max(orderChange[i]);
            invOrderChange[orderChange[i]] = i;
        }
        MixedTransform t = new MixedTransform(n, n);
        t.setComponentMapping(invOrderChange);
        return Views.interval((RandomAccessible)new MixedTransformView(rai, (Mixed)t), (long[])min, (long[])max);
    }
}

