/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.utils;

import io.bioimage.modelrunner.system.PlatformDetection;
import io.bioimage.modelrunner.utils.Constants;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;

public class CommonUtils {
    private static String USER_AGENT;
    public static Calendar cal;

    public static String getFileNameFromURLString(String str) throws MalformedURLException {
        if (str.startsWith("https://zenodo.org/") && str.endsWith("/content")) {
            str = str.substring(0, str.length() - "/content".length());
        }
        URL url = new URL(str);
        return new File(url.getPath()).getName();
    }

    public static <T extends RealType<T> & NativeType<T>> T getImgLib2DataType(String dataType) {
        RealType type;
        if (dataType.equals("int8")) {
            type = (RealType)Cast.unchecked((Object)new ByteType());
        } else if (dataType.equals("uint8")) {
            type = (RealType)Cast.unchecked((Object)new UnsignedByteType());
        } else if (dataType.equals("int16")) {
            type = (RealType)Cast.unchecked((Object)new ShortType());
        } else if (dataType.equals("uint16")) {
            type = (RealType)Cast.unchecked((Object)new UnsignedShortType());
        } else if (dataType.equals("int32")) {
            type = (RealType)Cast.unchecked((Object)new IntType());
        } else if (dataType.equals("uint32")) {
            type = (RealType)Cast.unchecked((Object)new UnsignedIntType());
        } else if (dataType.equals("int64")) {
            type = (RealType)Cast.unchecked((Object)new LongType());
        } else if (dataType.equals("float32")) {
            type = (RealType)Cast.unchecked((Object)new FloatType());
        } else if (dataType.equals("float64")) {
            type = (RealType)Cast.unchecked((Object)new DoubleType());
        } else {
            throw new IllegalArgumentException("Unsupported data type: " + dataType);
        }
        return (T)type;
    }

    public static <T extends RealType<T> & NativeType<T>> String getDataTypeFromRAI(RandomAccessibleInterval<T> rai) {
        if (rai.getAt(rai.minAsLongArray()) instanceof ByteType) {
            return "int8";
        }
        if (rai.getAt(rai.minAsLongArray()) instanceof UnsignedByteType) {
            return "uint8";
        }
        if (rai.getAt(rai.minAsLongArray()) instanceof ShortType) {
            return "int16";
        }
        if (rai.getAt(rai.minAsLongArray()) instanceof UnsignedShortType) {
            return "uint16";
        }
        if (rai.getAt(rai.minAsLongArray()) instanceof IntType) {
            return "int32";
        }
        if (rai.getAt(rai.minAsLongArray()) instanceof UnsignedIntType) {
            return "uint";
        }
        if (rai.getAt(rai.minAsLongArray()) instanceof LongType) {
            return "int64";
        }
        if (rai.getAt(rai.minAsLongArray()) instanceof FloatType) {
            return "float32";
        }
        if (rai.getAt(rai.minAsLongArray()) instanceof DoubleType) {
            return "float64";
        }
        throw new IllegalArgumentException("Data type not supported: " + ((RealType)rai.getAt(rai.minAsLongArray())).getClass());
    }

    public static <T extends RealType<T> & NativeType<T>> String getDataType(T type) {
        if (type instanceof ByteType) {
            return "int8";
        }
        if (type instanceof UnsignedByteType) {
            return "uint8";
        }
        if (type instanceof ShortType) {
            return "int16";
        }
        if (type instanceof UnsignedShortType) {
            return "uint16";
        }
        if (type instanceof IntType) {
            return "int32";
        }
        if (type instanceof UnsignedIntType) {
            return "uint32";
        }
        if (type instanceof LongType) {
            return "int64";
        }
        if (type instanceof FloatType) {
            return "float32";
        }
        if (type instanceof DoubleType) {
            return "float64";
        }
        throw new IllegalArgumentException("Data type not supported: " + type.getClass());
    }

    public static String getTime() {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        String dateString = sdf.format(cal.getTime());
        return dateString;
    }

    public static boolean int32Overflows(int[] arr, int bytesPerValue) {
        double div = Integer.MAX_VALUE / bytesPerValue;
        for (int a : arr) {
            div /= (double)a;
        }
        return div < 1.0;
    }

    public static boolean int32Overflows(long[] arr, int bytesPerValue) {
        double div = Integer.MAX_VALUE / bytesPerValue;
        for (long a : arr) {
            div /= (double)a;
        }
        return div < 1.0;
    }

    public static boolean int64Overflows(int[] arr, int bytesPerValue) {
        double div = Long.MAX_VALUE / (long)bytesPerValue;
        for (int a : arr) {
            div /= (double)a;
        }
        return div < 1.0;
    }

    public static boolean int64Overflows(long[] arr, int bytesPerValue) {
        double div = Long.MAX_VALUE / (long)bytesPerValue;
        for (long a : arr) {
            div /= (double)a;
        }
        return div < 1.0;
    }

    public static void main(String[] args) {
        System.out.println(CommonUtils.getTime());
    }

    public static String getJDLLUserAgent() {
        if (USER_AGENT != null) {
            return USER_AGENT;
        }
        String os = "Unknown";
        if (PlatformDetection.isWindows()) {
            os = "Windows";
        } else if (PlatformDetection.isLinux()) {
            os = "Linux";
        } else if (PlatformDetection.isMacOS()) {
            os = "MacOS";
        }
        USER_AGENT = "jdll/" + Constants.JDLL_VERSION + "(" + os + "; Java " + PlatformDetection.getJavaVersion();
        return USER_AGENT;
    }
}

