/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class JSONUtils {
    public static Map<String, Object> load(String jsonFile) throws FileNotFoundException, IOException {
        try (FileReader reader = new FileReader(jsonFile);){
            Map dataMap;
            Gson gson = new Gson();
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map map = dataMap = (Map)gson.fromJson((Reader)reader, mapType);
            return map;
        }
    }

    public static String[] castListToStringArray(List<?> list) {
        String[] array = new String[list.size()];
        int c = 0;
        for (Object in : list) {
            array[c++] = (String)in;
        }
        return array;
    }

    public static int[] castListToIntArray(List<?> list) {
        int[] array = new int[list.size()];
        int c = 0;
        for (Object in : list) {
            array[c++] = Integer.parseInt(in.toString());
        }
        return array;
    }

    public static double[] castListToDoubleArray(List<?> list) {
        try {
            double[] array = new double[list.size()];
            int c = 0;
            for (Object in : list) {
                array[c++] = Double.parseDouble(in.toString());
            }
            return array;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static float[] castListToFloatArray(List<?> list) {
        try {
            float[] array = new float[list.size()];
            int c = 0;
            for (Object in : list) {
                if (in instanceof String) {
                    array[c++] = Float.parseFloat((String)in);
                    continue;
                }
                if (in instanceof Integer) {
                    array[c++] = ((Integer)in).floatValue();
                    continue;
                }
                if (in instanceof Double) {
                    array[c++] = ((Double)in).floatValue();
                    continue;
                }
                if (in instanceof Float) {
                    array[c++] = ((Float)in).floatValue();
                    continue;
                }
                if (in instanceof Long) {
                    array[c++] = ((Long)in).floatValue();
                    continue;
                }
                if (in instanceof Number) {
                    array[c++] = ((Number)in).floatValue();
                    continue;
                }
                if (in instanceof Byte) {
                    array[c++] = ((Byte)in).floatValue();
                    continue;
                }
                throw new IllegalArgumentException("Unsupported type for list of Objects:" + in.getClass());
            }
            return array;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static void writeJSONFile(String filePath, Map<String, Object> data) throws IOException {
        Gson gson = new Gson();
        try (FileWriter writer = new FileWriter(filePath);){
            gson.toJson(data, (Appendable)writer);
        }
    }
}

