/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.versionmanagement;

import io.bioimage.modelrunner.download.FileDownloader;
import io.bioimage.modelrunner.versionmanagement.AvailableEngines;
import io.bioimage.modelrunner.versionmanagement.InstalledEngines;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DeepLearningVersion {
    private String framework;
    private String version;
    private String pythonVersion;
    private String os;
    private boolean cpu;
    private boolean gpu;
    private boolean rosetta;
    private List<String> jars;
    private String allEnginesDir;
    private String engineName;
    private int minJavaVersion = 8;
    public static String cpuKey = "cpu";
    public static String gpuKey = "gpu";

    public static DeepLearningVersion fromFile(File engineDir) throws IOException, IllegalStateException {
        DeepLearningVersion dlVersion = new DeepLearningVersion();
        dlVersion.engineName = engineDir.getName();
        dlVersion.allEnginesDir = engineDir.getParentFile().getAbsolutePath();
        String[] fields = dlVersion.engineName.split("-");
        dlVersion.setFramework(fields[0]);
        dlVersion.setPythonVersion(fields[1]);
        dlVersion.setVersion(fields[2]);
        dlVersion.setOs(fields[3] + "-" + fields[4]);
        if (fields.length == 5) {
            dlVersion.setCPU(false);
            dlVersion.setGPU(false);
        } else if (fields.length == 6 && fields[5].toLowerCase().equals(cpuKey)) {
            dlVersion.setCPU(true);
            dlVersion.setGPU(false);
        } else if (fields.length == 6 && fields[5].toLowerCase().equals(gpuKey)) {
            dlVersion.setCPU(false);
            dlVersion.setGPU(true);
        } else if (fields.length == 7 && fields[5].toLowerCase().equals(cpuKey) && fields[6].toLowerCase().equals(gpuKey)) {
            dlVersion.setCPU(true);
            dlVersion.setGPU(true);
        } else {
            throw new IOException("The name of the engine does not follow the engine name convention followed by JDLL: <name_of_the_engine>-<engine_python_version>-<engine_java_version>-<os>-<cpu_if_supported>-<gpu_if_supported>: " + engineDir.getName());
        }
        List<DeepLearningVersion> candidateVersions = dlVersion.getCandidates();
        if (candidateVersions.size() != 1) {
            throw new IllegalStateException("There should only one engine in the resources engine specs file 'https://raw.githubusercontent.com/bioimage-io/JDLL/main/src/main/resources/availableDLVersions.yml' that corresponds to the engine defined by: " + dlVersion.engineName);
        }
        dlVersion.rosetta = candidateVersions.get((int)0).rosetta;
        dlVersion.minJavaVersion = candidateVersions.get((int)0).minJavaVersion;
        dlVersion.setJars(candidateVersions.get(0).getJars());
        return dlVersion;
    }

    private List<DeepLearningVersion> getCandidates() {
        List<DeepLearningVersion> availableVersions = AvailableEngines.getAll();
        List<DeepLearningVersion> versionsOfInterest = availableVersions.stream().filter(v -> v.getFramework().toLowerCase().equals(this.getFramework().toLowerCase()) && v.getPythonVersion().toLowerCase().equals(this.getPythonVersion().toLowerCase()) && v.getVersion().toLowerCase().equals(this.getVersion().toLowerCase()) && v.getOs().toLowerCase().equals(this.getOs().toLowerCase()) && v.getCPU() == this.getCPU() && v.getGPU() == this.getGPU()).collect(Collectors.toList());
        return versionsOfInterest;
    }

    public List<String> checkMissingJars() {
        String[] jarsArr = new File(this.allEnginesDir, this.folderName()).list();
        List<String> folderJars = Arrays.asList(jarsArr);
        List<String> missingJars = this.getJarsFileNames().stream().filter(jar -> !folderJars.contains(jar) || new File(this.allEnginesDir + File.separator + this.folderName() + File.separator + jar).length() <= 0L).collect(Collectors.toList());
        return missingJars;
    }

    public boolean doesJarBelongToEngine(String jarDir) {
        File jarFile = new File(jarDir);
        if (!jarFile.isFile()) {
            return false;
        }
        String jarName = jarFile.getName();
        return this.jars.stream().anyMatch(i -> i.contains(jarName));
    }

    public String folderName() {
        if (this.engineName == null) {
            this.engineName = this.getFramework() + "-" + this.getPythonVersion() + "-" + this.getVersion() + "-" + this.getOs() + (this.getCPU() ? "-cpu" : "") + (this.getGPU() ? "-gpu" : "");
        }
        return this.engineName;
    }

    public boolean getGPU() {
        return this.gpu;
    }

    private void setGPU(boolean gpu) {
        this.gpu = gpu;
    }

    public String getFramework() {
        return this.framework;
    }

    private void setFramework(String framework) {
        this.framework = framework;
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion(String version) {
        this.version = version;
    }

    public String getPythonVersion() {
        return this.pythonVersion;
    }

    private void setPythonVersion(String pythonVersion) {
        this.pythonVersion = pythonVersion;
    }

    public String getOs() {
        return this.os;
    }

    public String getOsShort() {
        if (this.os.contains("windows")) {
            return "windows";
        }
        if (this.os.contains("linux") || this.os.contains("unix")) {
            return "linux";
        }
        if (this.os.contains("mac")) {
            return "macos";
        }
        return this.os;
    }

    private void setOs(String os) {
        this.os = os;
    }

    public boolean getCPU() {
        return this.cpu;
    }

    private void setCPU(boolean cpu) {
        this.cpu = cpu;
    }

    public boolean getRosetta() {
        return this.rosetta;
    }

    public int getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public List<String> getJars() {
        return this.jars;
    }

    public List<String> getJarsFileNames() {
        return this.jars.stream().map(jar -> {
            try {
                return FileDownloader.getFileNameFromURLString(jar);
            }
            catch (MalformedURLException e) {
                return jar;
            }
        }).collect(Collectors.toList());
    }

    private void setJars(List<String> jars) {
        this.jars = jars.stream().filter(jar -> jar != null).collect(Collectors.toList());
    }

    public boolean isJavaVersionBigger(DeepLearningVersion vv) {
        int result = DeepLearningVersion.stringVersionComparator(this.getVersion(), vv.getVersion());
        return result == -1;
    }

    public boolean isPythonVersionBigger(DeepLearningVersion vv) {
        int result = DeepLearningVersion.stringVersionComparator(this.getPythonVersion(), vv.getPythonVersion());
        return result == -1;
    }

    public static int stringVersionComparator(String v1, String v2) {
        String[] v2Arr;
        if (v1 == null && v2 == null) {
            throw new IllegalArgumentException("Both arguments cannot be null.");
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        String[] v1Arr = v1.split("\\.");
        int minNVersions = v1Arr.length > (v2Arr = v2.split("\\.")).length ? v2Arr.length : v1Arr.length;
        for (int i = 0; i < minNVersions; ++i) {
            if (Integer.parseInt(v1Arr[i]) > Integer.parseInt(v2Arr[i])) {
                return -1;
            }
            if (Integer.parseInt(v1Arr[i]) >= Integer.parseInt(v2Arr[i])) continue;
            return 1;
        }
        if (v1Arr.length > v2Arr.length) {
            return -1;
        }
        if (v1Arr.length < v2Arr.length) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.framework + " [version=" + this.version + ", pythonVersion=" + this.pythonVersion + ", os=" + this.os + ", cpu=" + this.cpu + ", gpu=" + this.gpu + ", jars=" + this.jars + ", rosetta=" + this.rosetta + ", minJavaVersion=" + this.minJavaVersion + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.framework == null ? 0 : this.framework.hashCode());
        result = 31 * result + (this.cpu ? 0 : "cpu".hashCode());
        result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.gpu ? 0 : "gpu".hashCode());
        result = 31 * result + (this.rosetta ? 0 : "rosetta".hashCode());
        result = 31 * result + this.minJavaVersion;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeepLearningVersion other = (DeepLearningVersion)obj;
        if (this.framework == null ? other.framework != null : !this.framework.equals(other.framework)) {
            return false;
        }
        if (this.cpu != other.cpu) {
            return false;
        }
        if (this.os == null ? other.os != null : !this.os.equals(other.os)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return this.gpu == other.gpu;
    }

    public void setEnginesDir() {
        this.allEnginesDir = InstalledEngines.getEnginesDir();
    }
}

