/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.versionmanagement;

import io.bioimage.modelrunner.engine.EngineInfo;
import io.bioimage.modelrunner.utils.IndexingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class VersionStringUtils {
    private static final int WRONG_VERSION = -10000000;

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("20.3");
        list.add("20.1");
        list.add("20.9");
        list.add("31");
        list.add("22");
        List<String> aa = VersionStringUtils.getCompatibleEngineVersionsInOrder("20.2", list, "tensorflow");
        System.out.print(aa);
    }

    public static List<String> getCompatibleEngineVersionsInOrder(String version, List<String> versionList, String engine) {
        ArrayList<String> vs = new ArrayList<String>();
        if (version == null || versionList == null || versionList.size() == 0) {
            String miss = VersionStringUtils.missingArgument(version, versionList, engine);
            if (miss != null) {
                vs.add(miss);
            }
            return vs;
        }
        int nPoints = VersionStringUtils.getNumberOfPoints(Arrays.asList(version));
        nPoints = nPoints > VersionStringUtils.getNumberOfPoints(versionList) ? nPoints : VersionStringUtils.getNumberOfPoints(versionList);
        versionList = VersionStringUtils.uniformVersionList(versionList, nPoints);
        version = VersionStringUtils.uniformVersionList(Arrays.asList(version), nPoints).get(0);
        List<Integer> intVersionList = VersionStringUtils.listOfStringVersionsIntoListOfIntVersions(versionList);
        if (intVersionList.size() == 0) {
            return vs;
        }
        int intVersion = VersionStringUtils.convertVersionIntoIntegerOrGetFromList(version, intVersionList);
        List versionDists = intVersionList.stream().map(v -> {
            v = v - intVersion;
            return v;
        }).collect(Collectors.toList());
        List<Integer> absDists = versionDists.stream().map(i -> Math.abs(i)).collect(Collectors.toList());
        Integer[] absArgSort = IndexingUtils.argsort(absDists);
        ArrayList<String> posList = new ArrayList<String>();
        ArrayList<String> negList = new ArrayList<String>();
        for (int i2 = 0; i2 < absDists.size(); ++i2) {
            if (!engine.toLowerCase().equals(EngineInfo.getOnnxKey()) && !version.split("\\.")[0].equals(versionList.get(absArgSort[i2]).split("\\.")[0])) continue;
            if ((Integer)versionDists.get(absArgSort[i2]) >= 0) {
                posList.add(versionList.get(absArgSort[i2]));
                continue;
            }
            if ((Integer)versionDists.get(absArgSort[i2]) >= 0) continue;
            negList.add(versionList.get(absArgSort[i2]));
        }
        posList.addAll(negList);
        return posList;
    }

    public static String getMostCompatibleEngineVersion(String version, List<String> versionList, String engine) {
        int closestSmallerInd;
        if (version == null || versionList == null || versionList.size() == 0) {
            return VersionStringUtils.missingArgument(version, versionList, engine);
        }
        int nPoints = VersionStringUtils.getNumberOfPoints(Arrays.asList(version));
        nPoints = nPoints > VersionStringUtils.getNumberOfPoints(versionList) ? nPoints : VersionStringUtils.getNumberOfPoints(versionList);
        versionList = VersionStringUtils.uniformVersionList(versionList, nPoints);
        version = VersionStringUtils.uniformVersionList(Arrays.asList(version), nPoints).get(0);
        List<Integer> intVersionList = VersionStringUtils.listOfStringVersionsIntoListOfIntVersions(versionList);
        if (intVersionList.size() == 0) {
            return null;
        }
        int intVersion = VersionStringUtils.convertVersionIntoIntegerOrGetFromList(version, intVersionList);
        List<Integer> versionDists = intVersionList.stream().map(v -> {
            v = v - intVersion;
            return v;
        }).collect(Collectors.toList());
        int closestBiggerInd = VersionStringUtils.indexOfBiggerClosestVersion(versionDists);
        if (closestBiggerInd != -1) {
            String possibleVersion = versionList.get(closestBiggerInd);
            if (!engine.toLowerCase().equals(EngineInfo.getOnnxKey()) && version.split("\\.")[0].equals(possibleVersion.split("\\.")[0])) {
                return possibleVersion;
            }
            if (engine.toLowerCase().equals(EngineInfo.getOnnxKey())) {
                return possibleVersion;
            }
        }
        if ((closestSmallerInd = VersionStringUtils.indexOfSmallerClosestVersion(versionDists)) != -1) {
            String possibleVersion = versionList.get(closestSmallerInd);
            if (!engine.toLowerCase().equals(EngineInfo.getOnnxKey()) && version.split("\\.")[0].equals(possibleVersion.split("\\.")[0])) {
                return possibleVersion;
            }
            if (engine.toLowerCase().equals(EngineInfo.getOnnxKey())) {
                return possibleVersion;
            }
        }
        return null;
    }

    private static String missingArgument(String version, List<String> versionList, String engine) {
        if (versionList == null || versionList.size() == 0) {
            return null;
        }
        if (engine == null) {
            throw new NullPointerException("In order to find the most compatible version for a framework, please introduce a non-null Deep Learning framework wanted.");
        }
        List<Integer> intVs = VersionStringUtils.listOfStringVersionsIntoListOfIntVersions(versionList);
        int v = 0;
        int ind = 0;
        for (int i = 0; i < intVs.size(); ++i) {
            if (intVs.get(i) <= v) continue;
            v = intVs.get(i);
            ind = i;
        }
        return versionList.get(ind);
    }

    private static List<Integer> listOfStringVersionsIntoListOfIntVersions(List<String> strs) {
        List<Integer> intVersionList = strs.stream().map(VersionStringUtils::convertVersionIntoInteger).collect(Collectors.toList());
        return intVersionList;
    }

    public static boolean areTheyTheSameVersion(String v1, String v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        int nPoints = VersionStringUtils.getNumberOfPoints(Arrays.asList(v1, v2));
        List<String> versionList = VersionStringUtils.uniformVersionList(Arrays.asList(v1, v2), nPoints);
        return versionList.get(0).equals(versionList.get(1));
    }

    public static boolean areTheyTheSameVersionUntilPoint(String v1, String v2, int point) {
        if (v1 == null || v2 == null) {
            return false;
        }
        v1 = VersionStringUtils.getUntilPoint(v1, point);
        v2 = VersionStringUtils.getUntilPoint(v2, point);
        int nPoints = VersionStringUtils.getNumberOfPoints(Arrays.asList(v1, v2));
        List<String> versionList = VersionStringUtils.uniformVersionList(Arrays.asList(v1, v2), nPoints);
        return versionList.get(0).equals(versionList.get(1));
    }

    private static String getUntilPoint(String v, int point) {
        int ind = 0;
        for (int i = 0; i < point; ++i) {
            if ((ind = v.indexOf(".", ind + 1)) != -1) continue;
            return v;
        }
        return v.substring(0, ind);
    }

    public static List<String> uniformVersionList(List<String> versionList, int nPoints) {
        for (int i = 0; i < versionList.size(); ++i) {
            if (versionList.get(i).endsWith(".")) {
                versionList.set(i, versionList.get(i) + "0");
            }
            while (VersionStringUtils.countNumberOfOccurences(versionList.get(i), ".") < nPoints) {
                versionList.set(i, versionList.get(i) + ".0");
            }
        }
        return versionList;
    }

    private static int getNumberOfPoints(List<String> versionList) {
        int points = 0;
        for (String vv : versionList) {
            int pp = VersionStringUtils.countNumberOfOccurences(vv, ".");
            if (pp <= points) continue;
            points = pp;
        }
        return points;
    }

    public static int countNumberOfOccurences(String str, String occurence) {
        return str.length() - str.replace(occurence, "").length();
    }

    private static int convertVersionIntoIntegerOrGetFromList(String version, List<Integer> intVersionList) {
        int versionInt = VersionStringUtils.convertVersionIntoInteger(version);
        if (versionInt == -10000000) {
            versionInt = VersionStringUtils.getHighestAvailable(intVersionList);
        }
        return versionInt;
    }

    private static int getHighestAvailable(List<Integer> versions) {
        ArrayList<Integer> versionsAux = new ArrayList<Integer>(versions);
        Collections.sort(versionsAux);
        int highestVersion = versionsAux.get(versionsAux.size() - 1);
        return highestVersion;
    }

    private static int indexOfBiggerClosestVersion(List<Integer> list) {
        int ind = -1;
        int biggerClosestDist = Integer.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) < 0 || list.get(i) >= biggerClosestDist) continue;
            ind = i;
            biggerClosestDist = list.get(i);
        }
        return ind;
    }

    private static int indexOfSmallerClosestVersion(List<Integer> list) {
        int ind = -1;
        int smallerClosestDist = Integer.MIN_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) > 0 || list.get(i) <= smallerClosestDist) continue;
            ind = i;
            smallerClosestDist = list.get(i);
        }
        return ind;
    }

    public static int convertVersionIntoInteger(String version) {
        if (version == null || version.toLowerCase().contains("unknown")) {
            return -10000000;
        }
        String[] separated = version.split("\\.");
        int scaleFactor = separated.length;
        int intV = 0;
        try {
            for (int i = 0; i < scaleFactor; ++i) {
                intV = (int)((double)intV + (double)Integer.parseInt(separated[i]) * Math.pow(10.0, (scaleFactor - 1 - i) * 4));
            }
        }
        catch (NumberFormatException ex) {
            return -10000000;
        }
        return intV;
    }
}

