/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.model;

import java.io.File;
import java.io.FileFilter;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.VarEditorModel;

public class FileTypeModel
implements VarEditorModel<File> {
    private final FileMode mode;
    private final FileFilter filter;
    private final String path;
    private final boolean allowHidden;

    public FileTypeModel(String initialPath, FileMode mode, FileFilter filter, boolean allowHidden) {
        this.path = initialPath;
        this.filter = filter;
        this.mode = mode;
        this.allowHidden = allowHidden;
    }

    @Override
    public boolean isValid(File value) {
        if (value == null) {
            return false;
        }
        if (this.filter != null && !this.filter.accept(value)) {
            return false;
        }
        if (value.isFile() && this.mode != FileMode.FILES) {
            return false;
        }
        if (value.isDirectory() && this.mode != FileMode.FOLDERS) {
            return false;
        }
        return !value.isHidden() || this.allowHidden;
    }

    @Override
    public File getDefaultValue() {
        return null;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public FileMode getMode() {
        return this.mode;
    }

    public String getPath() {
        return this.path;
    }

    public boolean allowHidden() {
        return this.allowHidden;
    }
}

