/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import icy.system.FileDrop;
import icy.system.thread.ThreadUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeListModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;

public class FilesChooser
extends SwingVarEditor<File[]> {
    private ActionListener actionListener;

    public FilesChooser(Var<File[]> variable) {
        super(variable);
    }

    @Override
    public JComponent createEditorComponent() {
        JButton jButton = new JButton();
        String path = null;
        FileMode fileMode = FileMode.ALL;
        boolean allowHidden = false;
        VarEditorModel model = this.variable.getDefaultEditorModel();
        if (model instanceof FileTypeListModel) {
            path = ((FileTypeListModel)model).getPath();
            fileMode = ((FileTypeListModel)model).getMode();
            allowHidden = ((FileTypeListModel)model).allowHidden();
        }
        final JFileChooser jFileChooser = new JFileChooser(path);
        switch (fileMode) {
            case FILES: {
                jFileChooser.setFileSelectionMode(0);
                jButton.setText("Select files...");
                break;
            }
            case FOLDERS: {
                jFileChooser.setFileSelectionMode(1);
                jButton.setText("Select folders...");
                break;
            }
            default: {
                jFileChooser.setFileSelectionMode(2);
                jButton.setText("Select files or folders...");
            }
        }
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileHidingEnabled(allowHidden);
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilesChooser.this.variable.getValue() != null) {
                    jFileChooser.setSelectedFiles((File[])FilesChooser.this.variable.getValue());
                }
                if (jFileChooser.showOpenDialog(null) != 0) {
                    return;
                }
                FilesChooser.this.variable.setValue(jFileChooser.getSelectedFiles());
                File[] files = jFileChooser.getSelectedFiles();
                FilesChooser.this.setButtonText(files.length + " file" + (files.length > 1 ? "s" : "") + " (click to change)");
            }
        };
        FileDrop.FileDropListener fileDropListener = this.getFileDropListener(fileMode);
        new FileDrop((Component)jButton, BorderFactory.createLineBorder(Color.blue.brighter(), 2), fileDropListener);
        return jButton;
    }

    private FileDrop.FileDropListener getFileDropListener(final FileMode fileMode) {
        return new FileDrop.FileDropListener(){

            @Override
            public void filesDropped(File[] files) {
                if (this.isActionListenerActive()) {
                    switch (fileMode) {
                        case FILES: {
                            File[] filteredFiles = this.getFiles(files);
                            if (filteredFiles.length <= 0) break;
                            FilesChooser.this.variable.setValue(filteredFiles);
                            FilesChooser.this.setButtonText(filteredFiles.length + " file" + (files.length > 1 ? "s" : "") + " (click to change)");
                            break;
                        }
                        case FOLDERS: {
                            File[] filteredFiles = this.getFolders(files);
                            if (filteredFiles.length <= 0) break;
                            FilesChooser.this.variable.setValue(filteredFiles);
                            FilesChooser.this.setButtonText(filteredFiles.length + " folder" + (files.length > 1 ? "s" : "") + " (click to change)");
                            break;
                        }
                        default: {
                            FilesChooser.this.variable.setValue(files);
                            FilesChooser.this.setButtonText(files.length + " file" + (files.length > 1 ? "s" : "") + " (click to change)");
                        }
                    }
                }
            }

            private boolean isActionListenerActive() {
                for (ActionListener l : FilesChooser.this.getEditorComponent().getActionListeners()) {
                    if (l != FilesChooser.this.actionListener) continue;
                    return true;
                }
                return false;
            }

            private File[] getFiles(File[] files) {
                ArrayList<File> fileList = new ArrayList<File>();
                for (File f : files) {
                    if (!f.isFile()) continue;
                    fileList.add(f);
                }
                return fileList.toArray(new File[fileList.size()]);
            }

            private File[] getFolders(File[] files) {
                ArrayList<File> folderList = new ArrayList<File>();
                for (File f : files) {
                    if (!f.isDirectory()) continue;
                    folderList.add(f);
                }
                return folderList.toArray(new File[folderList.size()]);
            }
        };
    }

    public void setButtonText(final String text) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                FilesChooser.this.getEditorComponent().setText(text);
            }
        });
    }

    @Override
    protected void updateInterfaceValue() {
        File[] newValue = (File[])this.variable.getValue();
        String list = "<html><pre><font size=3>";
        if (newValue != null) {
            for (File f : newValue) {
                list = list + f.getAbsolutePath();
                if (f.isDirectory()) {
                    list = list + "/";
                }
                list = list + "<br>";
            }
        }
        list = list + "</font></pre></html>";
        this.getEditorComponent().setToolTipText(list);
    }

    @Override
    public JButton getEditorComponent() {
        return (JButton)super.getEditorComponent();
    }

    @Override
    protected void activateListeners() {
        this.getEditorComponent().addActionListener(this.actionListener);
    }

    @Override
    protected void deactivateListeners() {
        this.getEditorComponent().removeActionListener(this.actionListener);
    }
}

