/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi2d;

import icy.canvas.IcyCanvas;
import icy.painter.Anchor2D;
import icy.painter.RectAnchor2D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DShape;

public abstract class ROI2DRectShape
extends ROI2DShape {
    public static final String ID_TOPLEFT = "top_left";
    public static final String ID_BOTTOMRIGHT = "bottom_right";
    protected final Anchor2D topLeft;
    protected final Anchor2D topRight;
    protected final Anchor2D bottomLeft;
    protected final Anchor2D bottomRight;
    protected boolean internalPositionSet;

    public ROI2DRectShape(RectangularShape shape, Point2D topLeft, Point2D bottomRight) {
        super(shape);
        this.topLeft = this.createAnchor(topLeft);
        this.topRight = this.createAnchor(new Point2D.Double(bottomRight.getX(), topLeft.getY()));
        this.bottomLeft = this.createAnchor(new Point2D.Double(topLeft.getX(), bottomRight.getY()));
        this.bottomRight = this.createAnchor(bottomRight);
        this.bottomRight.setSelected(true);
        this.internalPositionSet = false;
        this.addPoint(this.topLeft);
        this.addPoint(this.topRight);
        this.addPoint(this.bottomRight);
        this.addPoint(this.bottomLeft);
    }

    @Override
    protected Anchor2D createAnchor(Point2D pos) {
        return new ROI2DRectAnchor2D(pos, this.getColor(), this.getFocusedColor());
    }

    protected RectangularShape getRectangularShape() {
        return (RectangularShape)this.shape;
    }

    @Override
    public boolean canSetBounds() {
        return true;
    }

    @Override
    public void setBounds2D(Rectangle2D bounds) {
        this.beginUpdate();
        try {
            this.topLeft.setPosition(bounds.getMinX(), bounds.getMinY());
            this.bottomRight.setPosition(bounds.getMaxX(), bounds.getMaxY());
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    protected void updateShape() {
        this.getRectangularShape().setFrameFromDiagonal(this.topLeft.getPosition(), this.bottomRight.getPosition());
        super.updateShape();
    }

    @Override
    public boolean canAddPoint() {
        return false;
    }

    @Override
    public boolean canRemovePoint() {
        return false;
    }

    @Override
    protected boolean removePoint(IcyCanvas canvas, Anchor2D pt) {
        return false;
    }

    @Override
    public void controlPointPositionChanged(Anchor2D source) {
        if (this.internalPositionSet) {
            return;
        }
        this.internalPositionSet = true;
        try {
            if (source == this.topLeft) {
                this.bottomLeft.setX(this.topLeft.getX());
                this.topRight.setY(this.topLeft.getY());
            } else if (source == this.topRight) {
                this.bottomRight.setX(this.topRight.getX());
                this.topLeft.setY(this.topRight.getY());
            } else if (source == this.bottomLeft) {
                this.topLeft.setX(this.bottomLeft.getX());
                this.bottomRight.setY(this.bottomLeft.getY());
            } else if (source == this.bottomRight) {
                this.topRight.setX(this.bottomRight.getX());
                this.bottomLeft.setY(this.bottomRight.getY());
            }
        }
        finally {
            this.internalPositionSet = false;
        }
        super.controlPointPositionChanged(source);
    }

    @Override
    public void translate(double dx, double dy) {
        this.beginUpdate();
        try {
            this.topLeft.translate(dx, dy);
            this.bottomRight.translate(dx, dy);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                return false;
            }
            this.topLeft.loadPositionFromXML(XMLUtil.getElement(node, ID_TOPLEFT));
            this.bottomRight.loadPositionFromXML(XMLUtil.getElement(node, ID_BOTTOMRIGHT));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        this.topLeft.savePositionToXML(XMLUtil.setElement(node, ID_TOPLEFT));
        this.bottomRight.savePositionToXML(XMLUtil.setElement(node, ID_BOTTOMRIGHT));
        return true;
    }

    protected class ROI2DRectAnchor2D
    extends RectAnchor2D {
        public ROI2DRectAnchor2D(Point2D position, Color color, Color selectedColor) {
            super(position, color, selectedColor);
        }

        @Override
        protected Anchor2D getOppositePoint() {
            if (this == ROI2DRectShape.this.topLeft) {
                return ROI2DRectShape.this.bottomRight;
            }
            if (this == ROI2DRectShape.this.topRight) {
                return ROI2DRectShape.this.bottomLeft;
            }
            if (this == ROI2DRectShape.this.bottomLeft) {
                return ROI2DRectShape.this.topRight;
            }
            return ROI2DRectShape.this.topLeft;
        }
    }
}

