/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi5d;

import icy.roi.BooleanMask4D;
import icy.roi.BooleanMask5D;
import icy.roi.ROI;
import icy.roi.ROI4D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import java.awt.geom.Point2D;
import java.util.Map;
import plugins.kernel.roi.roi4d.ROI4DArea;
import plugins.kernel.roi.roi5d.ROI5DStack;

public class ROI5DArea
extends ROI5DStack<ROI4DArea> {
    public ROI5DArea() {
        super(ROI4DArea.class);
        this.setName("4D area");
    }

    public ROI5DArea(Point5D pt) {
        this();
        this.addBrush(pt.toPoint2D(), (int)pt.getZ(), (int)pt.getT(), (int)pt.getC());
    }

    public ROI5DArea(BooleanMask5D mask) {
        this();
        this.setAsBooleanMask(mask);
    }

    public ROI5DArea(ROI5DArea area) {
        this();
        for (Map.Entry entry : area.slices.entrySet()) {
            this.slices.put((Integer)entry.getKey(), new ROI4DArea((ROI4DArea)entry.getValue()));
        }
        this.roiChanged(true);
    }

    @Override
    public String getDefaultName() {
        return "Area5D";
    }

    public void addPoint(int x, int y, int z, int t, int c) {
        this.setPoint(x, y, z, t, c, true);
    }

    public void removePoint(int x, int y, int z, int t, int c) {
        this.setPoint(x, y, z, t, c, false);
    }

    public void setPoint(int x, int y, int z, int t, int c, boolean value) {
        ROI4DArea slice = (ROI4DArea)this.getSlice(c, value);
        if (slice != null) {
            slice.setPoint(x, y, z, t, value);
        }
    }

    public void addBrush(Point2D pos, int z, int t, int c) {
        ((ROI4DArea)this.getSlice(c, true)).addBrush(pos, z, t);
    }

    public void removeBrush(Point2D pos, int z, int t, int c) {
        ROI4DArea slice = (ROI4DArea)this.getSlice(c, false);
        if (slice != null) {
            slice.removeBrush(pos, z, t);
        }
    }

    public void setSlice(int c, ROI4D roiSlice, boolean merge) throws UnsupportedOperationException, InterruptedException {
        ROI newSlice;
        if (roiSlice == null) {
            throw new IllegalArgumentException("Cannot add an empty slice in a 5D ROI");
        }
        ROI4DArea currentSlice = (ROI4DArea)this.getSlice(c);
        if (currentSlice != null && merge) {
            roiSlice.setC(c);
            newSlice = currentSlice.getUnion(roiSlice);
        } else {
            newSlice = roiSlice;
        }
        if (newSlice instanceof ROI4DArea) {
            this.setSlice(c, (ROI4DArea)newSlice);
        } else if (newSlice instanceof ROI4D) {
            this.setSlice(c, new ROI4DArea(((ROI4D)newSlice).getBooleanMask(true)));
        } else {
            throw new IllegalArgumentException("Can't add the result of the merge operation on 4D slice " + c + ": " + newSlice.getClassName());
        }
    }

    @Override
    public boolean isEmpty() {
        for (ROI4DArea area : this.slices.values()) {
            if (area.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setAsBooleanMask(BooleanMask5D mask) {
        if (mask == null || mask.isEmpty()) {
            this.clear();
        } else {
            Rectangle5D.Integer bounds5d = mask.bounds;
            int startC = bounds5d.c;
            int sizeC = bounds5d.sizeC;
            BooleanMask4D[] masks4d = new BooleanMask4D[sizeC];
            int c = 0;
            while (c < sizeC) {
                masks4d[c] = mask.getMask4D(startC + c);
                ++c;
            }
            this.setAsBooleanMask(bounds5d, masks4d);
        }
    }

    public void setAsBooleanMask(Rectangle5D.Integer rect, BooleanMask4D[] mask) {
        if (rect.isInfiniteC()) {
            throw new IllegalArgumentException("Cannot set infinite C dimension on the 5D Area ROI.");
        }
        this.beginUpdate();
        try {
            this.clear();
            int c = 0;
            while (c < rect.sizeC) {
                this.setSlice(c + rect.c, new ROI4DArea(mask[c]));
                ++c;
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void optimizeBounds() {
        Rectangle5D.Integer bounds = this.getBounds();
        this.beginUpdate();
        try {
            int c = bounds.c;
            while (c < bounds.c + bounds.sizeC) {
                ROI4DArea roi = (ROI4DArea)this.getSlice(c);
                if (roi != null) {
                    if (roi.isEmpty()) {
                        this.removeSlice(c);
                    } else {
                        roi.optimizeBounds();
                    }
                }
                ++c;
            }
        }
        finally {
            this.endUpdate();
        }
    }
}

