/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.deepicy.engines;

import icy.file.Loader;
import icy.main.Icy;
import icy.sequence.Sequence;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.gui.adapter.RunnerAdapter;
import io.bioimage.modelrunner.numpy.DecodeNumpy;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.bioimageanalysis.icy.deepicy.tensor.SequenceRaiManager;

public class Runner
extends RunnerAdapter {
    private Runner(ModelDescriptor descriptor) throws IOException, LoadEngineException {
        super(descriptor, Runner.class.getClassLoader());
    }

    private Runner(ModelDescriptor descriptor, String enginesPath) throws IOException, LoadEngineException {
        super(descriptor, enginesPath, Runner.class.getClassLoader());
    }

    public static Runner create(ModelDescriptor descriptor) throws IOException, LoadEngineException {
        return new Runner(descriptor);
    }

    public static Runner create(ModelDescriptor descriptor, String enginesPath) throws IOException, LoadEngineException {
        return new Runner(descriptor, enginesPath);
    }

    protected <T extends RealType<T> & NativeType<T>> LinkedHashMap<TensorSpec, RandomAccessibleInterval<T>> displayTestInputs(LinkedHashMap<TensorSpec, String> testInputs) {
        LinkedHashMap<TensorSpec, RandomAccessibleInterval<T>> inputRais = new LinkedHashMap<TensorSpec, RandomAccessibleInterval<T>>();
        for (Map.Entry<TensorSpec, String> input : testInputs.entrySet()) {
            RandomAccessibleInterval rai;
            if (input.getValue().endsWith(".npy")) {
                try {
                    rai = DecodeNumpy.loadNpy((String)input.getValue());
                    Sequence image = SequenceRaiManager.convert(rai, input.getKey().getAxesOrder());
                    SwingUtilities.invokeLater(() -> Icy.getMainInterface().addSequence(image));
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected error reading .npy file.");
                }
            } else {
                Sequence imp = Loader.loadSequence((String)input.getValue(), (int)0, (boolean)true);
                rai = SequenceRaiManager.convert(imp, input.getKey().getAxesOrder());
                SwingUtilities.invokeLater(() -> Icy.getMainInterface().addSequence(imp));
            }
            inputRais.put(input.getKey(), rai);
        }
        return inputRais;
    }

    protected LinkedHashMap<TensorSpec, String> getTestInputs() {
        LinkedHashMap<TensorSpec, String> testInputs = new LinkedHashMap<TensorSpec, String>();
        for (TensorSpec tt : this.descriptor.getInputTensors()) {
            String sampleFile = tt.getTestTensorName();
            if (sampleFile == null || this.model == null) {
                sampleFile = tt.getSampleTensorName();
            }
            if (sampleFile == null) {
                throw new RuntimeException("Sample/Test files for input tensor '" + tt.getName() + "' are missing, please download them.");
            }
            File ff = new File(sampleFile);
            if (!ff.isFile()) {
                ff = new File(this.descriptor.getModelPath() + File.separator + sampleFile);
            }
            if (!ff.isFile()) {
                throw new RuntimeException("Sample/Test files for input tensor '" + tt.getName() + "' are missing, please download them.");
            }
            testInputs.put(tt, ff.getAbsolutePath());
        }
        return testInputs;
    }
}

