/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.file.FileImporter;
import icy.file.FileUtil;
import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.gui.dialog.LoaderOptionPanel;
import icy.main.Icy;
import icy.preferences.ApplicationPreferences;
import icy.preferences.GeneralPreferences;
import icy.preferences.XMLPreferences;
import icy.type.collection.CollectionUtil;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class LoaderDialog
extends JFileChooser
implements PropertyChangeListener {
    private static final long serialVersionUID = 5162434537949723956L;
    public static AllImagesFileFilter allImagesFileFilter = new AllImagesFileFilter();
    public static AllFileFilter allFileFilter = new AllFileFilter();
    private static final String PREF_ID = "frame/imageLoader";
    private static final String ID_WIDTH = "width";
    private static final String ID_HEIGTH = "heigth";
    private static final String ID_LOADTYPE = "loadtype";
    private static final String ID_EXTENSION = "extension";
    protected final LoaderOptionPanel optionPanel;
    protected final List<SequenceFileImporter> sequenceImporters;
    protected final List<FileImporter> fileImporters;

    public LoaderDialog(String defaultPath, Rectangle region, int series, boolean autoLoad) {
        List<FileFilter> filters;
        XMLPreferences preferences = ApplicationPreferences.getPreferences().node(PREF_ID);
        this.sequenceImporters = Loader.getSequenceFileImporters();
        this.fileImporters = Loader.getFileImporters();
        this.optionPanel = new LoaderOptionPanel(LoaderOptionPanel.LoaderLoadingType.values()[preferences.getInt(ID_LOADTYPE, LoaderOptionPanel.LoaderLoadingType.GROUP.ordinal())]);
        this.setPreferredSize(new Dimension(preferences.getInt(ID_WIDTH, 600), preferences.getInt(ID_HEIGTH, 400)));
        this.setMultiSelectionEnabled(true);
        this.setFileSelectionMode(2);
        this.setAcceptAllFileFilterUsed(false);
        this.resetChoosableFileFilters();
        for (SequenceFileImporter sequenceFileImporter : this.sequenceImporters) {
            filters = sequenceFileImporter.getFileFilters();
            if (filters == null) continue;
            for (FileFilter filter : filters) {
                this.addChoosableFileFilter(filter);
            }
        }
        for (FileImporter fileImporter : this.fileImporters) {
            filters = fileImporter.getFileFilters();
            if (filters == null) continue;
            for (FileFilter filter : filters) {
                this.addChoosableFileFilter(filter);
            }
        }
        this.addChoosableFileFilter(allFileFilter);
        if (defaultPath != null) {
            this.setFileFilter(allFileFilter);
            File file = new File(defaultPath);
            if (file.isDirectory()) {
                this.setCurrentDirectory(file);
            } else {
                this.setSelectedFile(file);
            }
        } else {
            this.setFileFilter(this.getFileFilter(preferences.get(ID_EXTENSION, allImagesFileFilter.getDescription())));
            this.setCurrentDirectory(new File(GeneralPreferences.getLoaderFolder()));
        }
        this.updateGUI();
        if (defaultPath != null) {
            this.optionPanel.updatePreview(new String[]{defaultPath}, series);
            if (region != null) {
                this.optionPanel.setXYRegion(region);
            }
        }
        this.addPropertyChangeListener(this);
        int n = this.showOpenDialog((Component)((Object)Icy.getMainInterface().getMainFrame()));
        if (n == 0) {
            GeneralPreferences.setLoaderFolder(this.getCurrentDirectory().getAbsolutePath());
            preferences.putInt(ID_LOADTYPE, this.optionPanel.getLoadingType().ordinal());
            preferences.put(ID_EXTENSION, this.getFileFilter().getDescription());
            if (autoLoad) {
                List<String> paths = CollectionUtil.asList(FileUtil.toPaths(this.getSelectedFiles()));
                String firstPath = paths.get(0);
                Object importer = this.getSelectedImporter();
                boolean notAnImage = false;
                if (importer == null) {
                    if (paths.size() > 0) {
                        notAnImage = true;
                        int i = 0;
                        while (i < paths.size()) {
                            if (Loader.isSupportedImageFile(paths.get(i))) {
                                notAnImage = false;
                                break;
                            }
                            i += paths.size() / 4;
                        }
                    } else {
                        boolean bl = notAnImage = !Loader.isSupportedImageFile(firstPath);
                    }
                }
                if (paths.size() > 1 || FileUtil.isDirectory(firstPath)) {
                    if (importer instanceof FileImporter || notAnImage) {
                        Loader.load((FileImporter)importer, paths, true);
                    } else if (this.isSeparateSequenceSelected()) {
                        Loader.load((SequenceFileImporter)importer, paths, true, false, true);
                    } else {
                        Loader.load((SequenceFileImporter)importer, paths, this.isAutoOrderSelected(), this.optionPanel.getResolutionLevel(), this.optionPanel.getXYRegion(), this.optionPanel.getFullZRange() ? -1 : this.optionPanel.getZMin(), this.optionPanel.getFullZRange() ? -1 : this.optionPanel.getZMax(), this.optionPanel.getFullTRange() ? -1 : this.optionPanel.getTMin(), this.optionPanel.getFullTRange() ? -1 : this.optionPanel.getTMax(), this.optionPanel.getChannel(), false, true, true);
                    }
                } else if (importer instanceof FileImporter || notAnImage) {
                    Loader.load((FileImporter)importer, paths, true);
                } else {
                    Loader.load((SequenceFileImporter)importer, firstPath, this.optionPanel.getSeries(), this.optionPanel.getResolutionLevel(), this.optionPanel.getXYRegion(), this.optionPanel.getFullZRange() ? -1 : this.optionPanel.getZMin(), this.optionPanel.getFullZRange() ? -1 : this.optionPanel.getZMax(), this.optionPanel.getFullTRange() ? -1 : this.optionPanel.getTMin(), this.optionPanel.getFullTRange() ? -1 : this.optionPanel.getTMax(), this.optionPanel.getChannel(), this.isSeparateSequenceSelected(), true, true);
                }
            }
        }
        preferences.putInt(ID_WIDTH, this.getWidth());
        preferences.putInt(ID_HEIGTH, this.getHeight());
    }

    public LoaderDialog(String defaultPath, Rectangle region, boolean autoLoad) {
        this(defaultPath, region, -1, autoLoad);
    }

    public LoaderDialog(boolean autoLoad) {
        this(null, null, autoLoad);
    }

    public LoaderDialog() {
        this(null, null, true);
    }

    protected FileFilter getFileFilter(String description) {
        FileFilter[] filters;
        FileFilter[] fileFilterArray = filters = this.getChoosableFileFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter filter = fileFilterArray[n2];
            if (StringUtil.equals(filter.getDescription(), description)) {
                return filter;
            }
            ++n2;
        }
        if (filters.length > 0) {
            return filters[0];
        }
        return null;
    }

    protected int getFileFilterIndex() {
        FileFilter[] filters = this.getChoosableFileFilters();
        FileFilter filter = this.getFileFilter();
        int i = 0;
        while (i < filters.length) {
            if (filter == filters[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean isImageFilter() {
        return this.getSelectedImporter() instanceof SequenceFileImporter;
    }

    protected boolean isAllFileFilter() {
        return this.getFileFilter() == allFileFilter;
    }

    protected Object getImporter(int filterIndex) {
        int count;
        List<FileFilter> filters;
        int ind = 0;
        for (SequenceFileImporter sequenceFileImporter : this.sequenceImporters) {
            filters = sequenceFileImporter.getFileFilters();
            int n = count = filters != null ? filters.size() : 0;
            if (filterIndex < ind + count) {
                return sequenceFileImporter;
            }
            ind += count;
        }
        for (FileImporter fileImporter : this.fileImporters) {
            filters = fileImporter.getFileFilters();
            int n = count = filters != null ? filters.size() : 0;
            if (filterIndex < ind + count) {
                return fileImporter;
            }
            ind += count;
        }
        return null;
    }

    public Object getSelectedImporter() {
        return this.getImporter(this.getFileFilterIndex());
    }

    public boolean isSeparateSequenceSelected() {
        return this.optionPanel.isSeparateSequenceSelected();
    }

    public boolean isAutoOrderSelected() {
        return this.optionPanel.getLoadingType() == LoaderOptionPanel.LoaderLoadingType.GROUP;
    }

    public int getResolutionLevel() {
        return this.optionPanel.getResolutionLevel();
    }

    public Rectangle getXYRegion() {
        return this.optionPanel.getXYRegion();
    }

    public int getZMin() {
        return this.optionPanel.getZMin();
    }

    public int getZMax() {
        return this.optionPanel.getZMax();
    }

    public int getTMin() {
        return this.optionPanel.getTMin();
    }

    public int getTMax() {
        return this.optionPanel.getTMax();
    }

    public int getChannel() {
        return this.optionPanel.getChannel();
    }

    public int getSeries() {
        return this.optionPanel.getSeries();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("fileFilterChanged")) {
            this.updateGUI();
        } else if (prop.equals("SelectedFilesChangedProperty")) {
            File[] files = this.getSelectedFiles();
            if (files.length < 2) {
                File f = this.getSelectedFile();
                if (f == null || f.isDirectory() || !f.exists()) {
                    this.optionPanel.updatePreview(new String[0]);
                } else {
                    this.optionPanel.updatePreview(new String[]{f.getAbsolutePath()});
                }
            } else {
                this.optionPanel.updatePreview(FileUtil.toPaths(files));
            }
        } else if (prop.equals("JFileChooserDialogIsClosingProperty")) {
            this.optionPanel.closingFromEDT();
        }
    }

    protected void updateGUI() {
        if (this.isImageFilter() || this.isAllFileFilter()) {
            this.setDialogTitle("Load image file(s)");
            this.setAccessory(this.optionPanel);
            this.revalidate();
        } else {
            this.setDialogTitle("Load file(s)");
            this.setAccessory(null);
            this.revalidate();
        }
    }

    public static class AllFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.exists();
        }

        @Override
        public String getDescription() {
            return "All files";
        }
    }

    public static class AllImagesFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return !Loader.canDiscardImageFile(file.getName());
        }

        @Override
        public String getDescription() {
            return "All images file";
        }
    }
}

