/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.gui.Gui;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class DefaultIcon {
    protected static String DIJ_ICON_PATH;
    private static final Map<Dimension, CompletableFuture<ImageIcon>> PENDING_ICONS;
    private static Map<Dimension, ImageIcon> ICONS_CACHE;
    private static final ExecutorService scaleExecutor;
    private static BufferedImage MASTER_IMAGE;

    protected static void setIconPath(String iconPath) {
        DIJ_ICON_PATH = iconPath;
        DefaultIcon.initializeMasterImage();
    }

    protected static void initializeMasterImage() {
        try {
            if (DIJ_ICON_PATH == null) {
                throw new IOException();
            }
            URL defaultIconUrl = DefaultIcon.class.getClassLoader().getResource(DIJ_ICON_PATH);
            if (defaultIconUrl == null) {
                throw new IOException();
            }
            MASTER_IMAGE = ImageIO.read(defaultIconUrl);
        }
        catch (IOException e) {
            BufferedImage bi = new BufferedImage(50, 50, 2);
            Graphics2D g = bi.createGraphics();
            g.setColor(Color.GRAY);
            g.drawString("Loading...", 5, 25);
            g.dispose();
            MASTER_IMAGE = bi;
        }
    }

    public static ImageIcon getDefaultIcon(int width, int height) {
        try {
            if (DIJ_ICON_PATH == null) {
                return null;
            }
            URL defaultIconUrl = Gui.class.getClassLoader().getResource(DIJ_ICON_PATH);
            if (defaultIconUrl == null) {
                return null;
            }
            BufferedImage defaultImage = ImageIO.read(defaultIconUrl);
            Image scaledDefaultImage = defaultImage.getScaledInstance(width, height, 2);
            return new ImageIcon(scaledDefaultImage);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ImageIcon getLoadingIcon(int width, int height) {
        Dimension size = new Dimension(width, height);
        ImageIcon cached = ICONS_CACHE.get(size);
        if (cached != null) {
            return cached;
        }
        CompletableFuture<ImageIcon> pending = PENDING_ICONS.get(size);
        if (pending == null && !scaleExecutor.isShutdown()) {
            pending = CompletableFuture.supplyAsync(() -> {
                Image scaledImage = MASTER_IMAGE.getScaledInstance(width, height, 4);
                ImageIcon icon = new ImageIcon(scaledImage);
                ICONS_CACHE.put(size, icon);
                PENDING_ICONS.remove(size);
                return icon;
            }, scaleExecutor);
            PENDING_ICONS.put(size, pending);
        }
        return DefaultIcon.createTransparentIcon(width, height);
    }

    private static ImageIcon createTransparentIcon(int width, int height) {
        return new ImageIcon(new BufferedImage(width, height, 2));
    }

    private static ImageIcon createPlaceholderIcon(int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.drawRect(0, 0, width - 1, height - 1);
        g2d.dispose();
        return new ImageIcon(bi);
    }

    public static void getLoadingIconWithCallback(int width, int height, Consumer<ImageIcon> callback) {
        ImageIcon immediate = DefaultIcon.getLoadingIcon(width, height);
        Dimension size = new Dimension(width, height);
        CompletableFuture<ImageIcon> pending = PENDING_ICONS.get(size);
        if (pending != null && !scaleExecutor.isShutdown()) {
            pending.thenAcceptAsync(icon -> SwingUtilities.invokeLater(() -> callback.accept((ImageIcon)icon)), (Executor)scaleExecutor);
        }
        callback.accept(immediate);
    }

    public static void closeThreads() {
        if (scaleExecutor != null) {
            scaleExecutor.shutdown();
        }
    }

    static {
        PENDING_ICONS = new ConcurrentHashMap<Dimension, CompletableFuture<ImageIcon>>();
        ICONS_CACHE = new ConcurrentHashMap<Dimension, ImageIcon>();
        scaleExecutor = Executors.newFixedThreadPool(2);
        DefaultIcon.initializeMasterImage();
    }
}

