/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.gui.DefaultIcon;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class Header
extends JPanel {
    private final String title;
    private final String subtitle;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JPanel progressPanelCard;
    private CardLayout cardLayout;
    private final long parentHeight;
    private final long parentWidth;
    private static final double TITLE_VRATIO = 0.1;
    private static final double TITLE_HRATIO = 1.0;
    private static final double LOGO_VRATIO = 1.0;
    private static final double LOGO_HRATIO = 0.14285714285714285;
    private static final double PROGRESS_BAR_WIDTH_RATIO = 0.25;
    private static final long serialVersionUID = -7691139174208436363L;

    protected Header(String title, String subtitle, int parentWidth, int parentHeight) {
        super(new GridBagLayout());
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
        this.title = title;
        this.subtitle = subtitle;
        this.setBackground(Color.GRAY);
        this.setBorder(new LineBorder(Color.BLACK, 2, true));
        this.setPreferredSize(new Dimension(parentWidth, (int)((double)parentHeight * 0.1)));
        int logoHeight = (int)((double)parentHeight * 0.1 * 1.0);
        int logoWidth = (int)((double)parentHeight * 1.0 * 0.14285714285714285);
        ImageIcon logoIcon = DefaultIcon.getDefaultIcon(logoWidth, logoHeight);
        JLabel logoLabel = new JLabel(logoIcon);
        JLabel titleLabel = new JLabel(this.title);
        titleLabel.setFont(new Font("SansSerif", 1, 36));
        titleLabel.setForeground(Color.WHITE);
        titleLabel.setAlignmentX(0.5f);
        JLabel subtitleLabel = new JLabel(this.subtitle);
        subtitleLabel.setFont(new Font("SansSerif", 0, 18));
        subtitleLabel.setForeground(Color.WHITE);
        subtitleLabel.setAlignmentX(0.5f);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.setOpaque(false);
        textPanel.add(titleLabel);
        textPanel.add(subtitleLabel);
        JPanel wrapperPanel = new JPanel(new GridBagLayout());
        wrapperPanel.setOpaque(false);
        GridBagConstraints logoGbc = new GridBagConstraints();
        logoGbc.gridx = 0;
        logoGbc.gridy = 0;
        logoGbc.anchor = 17;
        logoGbc.insets = new Insets(0, 0, 0, this.getWidth() / 80);
        wrapperPanel.add((Component)logoLabel, logoGbc);
        GridBagConstraints textGbc = new GridBagConstraints();
        textGbc.gridx = 1;
        textGbc.gridy = 0;
        textGbc.anchor = 17;
        wrapperPanel.add((Component)textPanel, textGbc);
        JPanel progressPanel = this.createProgressBar();
        this.progressPanelCard = new JPanel();
        this.cardLayout = new CardLayout();
        this.progressPanelCard.setLayout(this.cardLayout);
        this.progressPanelCard.add((Component)progressPanel, "visible");
        this.progressPanelCard.add((Component)new JPanel(){
            {
                this.setOpaque(false);
            }
        }, "invisible");
        this.cardLayout.show(this.progressPanelCard, "invisible");
        progressPanel.setPreferredSize(new Dimension((int)((double)this.parentWidth * 0.25), (int)this.parentHeight));
        this.progressPanelCard.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.25;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        this.add((Component)new JPanel(){
            {
                this.setOpaque(false);
            }
        }, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        this.add((Component)wrapperPanel, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.25;
        gbc.fill = 2;
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 20, 5, 20);
        this.add((Component)this.progressPanelCard, gbc);
    }

    private JPanel createProgressBar() {
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(false);
        this.progressBar.setBackground(Color.LIGHT_GRAY);
        this.progressBar.setForeground(new Color(46, 204, 113));
        this.progressBar.setPreferredSize(new Dimension((int)((double)this.parentWidth * 0.25), 25));
        this.progressLabel = new JLabel("Processing...");
        this.progressLabel.setBackground(Color.gray);
        this.progressLabel.setOpaque(true);
        this.progressLabel.setMinimumSize(new Dimension(100, this.progressLabel.getPreferredSize().height));
        this.progressLabel.setPreferredSize(new Dimension(100, this.progressLabel.getPreferredSize().height));
        this.progressLabel.setMaximumSize(new Dimension(100, this.progressLabel.getPreferredSize().height));
        this.progressLabel.setHorizontalAlignment(0);
        JPanel progressPanel = new JPanel(new GridBagLayout());
        progressPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        progressPanel.add((Component)this.progressLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        progressPanel.add((Component)this.progressBar, gbc);
        return progressPanel;
    }

    protected void setGUIStartInstallation() {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("0%");
            this.progressLabel.setText("Preparing installation...");
            this.cardLayout.show(this.progressPanelCard, "visible");
        });
    }

    public Consumer<String> createStringConsumer() {
        Consumer<String> consumer = ss -> SwingUtilities.invokeLater(() -> this.progressLabel.setText("Installing " + new File((String)ss).getName()));
        return consumer;
    }

    public Consumer<Double> createProgressConsumer() {
        Consumer<Double> consumer = dd -> SwingUtilities.invokeLater(() -> {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
            }
            double perc = Math.floor(dd * 1000.0) / 10.0;
            this.progressBar.setString(perc + "%");
            this.progressBar.setValue((int)perc);
            if (perc == 100.0) {
                this.cardLayout.show(this.progressPanelCard, "invisible");
            }
        });
        return consumer;
    }
}

