/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.measure;

import icy.math.UnitUtil;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.util.StringUtil;
import plugins.kernel.roi.descriptor.measure.ROIInteriorDescriptor;

public class ROIAreaDescriptor
extends ROIDescriptor {
    public static final String ID = "Area";

    public ROIAreaDescriptor() {
        super(ID, ID, Double.class);
    }

    @Override
    public String getDescription() {
        return ID;
    }

    @Override
    public String getUnit(Sequence sequence) {
        if (sequence != null) {
            return String.valueOf(sequence.getBestPixelSizeUnit(2, 2).toString()) + "m2";
        }
        return String.valueOf(UnitUtil.UnitPrefix.MICRO.toString()) + "m2";
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        SequenceEvent.SequenceEventSourceType sourceType = change.getSourceType();
        if (sourceType == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
            return true;
        }
        if (sourceType == SequenceEvent.SequenceEventSourceType.SEQUENCE_META) {
            String metaName = (String)change.getSource();
            return StringUtil.isEmpty(metaName) || StringUtil.equals(metaName, "pixelSizeX") || StringUtil.equals(metaName, "pixelSizeY") || StringUtil.equals(metaName, "pixelSizeZ");
        }
        return false;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIAreaDescriptor.computeArea(roi, sequence);
    }

    public static double computeArea(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIAreaDescriptor.computeArea(ROIInteriorDescriptor.computeInterior(roi), roi, sequence);
    }

    public static double computeArea(double interiorPoints, ROI roi, Sequence sequence) throws UnsupportedOperationException {
        if (!(roi instanceof ROI2D)) {
            throw new UnsupportedOperationException("Can't process Area calculation for on " + roi.getDimension() + "D ROI: '" + roi.getName() + "'");
        }
        if (sequence == null) {
            throw new UnsupportedOperationException("Can't process Area calculation with null Sequence parameter !");
        }
        return ROIInteriorDescriptor.computeInterior(interiorPoints, roi, sequence, 2);
    }
}

