/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.apposed.appose;

import io.bioimage.modelrunner.apposed.appose.Mamba;
import io.bioimage.modelrunner.download.FileDownloader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public final class MambaInstallerUtils {
    private MambaInstallerUtils() {
    }

    public static void unBZip2(File source, File destination) throws FileNotFoundException, IOException, InterruptedException {
        try (BZip2CompressorInputStream input = new BZip2CompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(source)));
             FileOutputStream output = new FileOutputStream(destination);){
            MambaInstallerUtils.copy((InputStream)input, output);
        }
    }

    private static long copy(InputStream input, OutputStream output) throws IOException, InterruptedException {
        int bufferSize = 4096;
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Decompressing stopped.");
            }
            if (output != null) {
                output.write(buffer, 0, n);
            }
            count += (long)n;
        }
        return count;
    }

    public static void unTar(File inputFile, File outputDir) throws FileNotFoundException, IOException, ArchiveException {
        try (FileInputStream is = new FileInputStream(inputFile);
             TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);){
            TarArchiveEntry entry = null;
            while ((entry = debInputStream.getNextEntry()) != null) {
                File outputFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                }
                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create directory " + outputFile.getParentFile().getAbsolutePath());
                }
                try (FileOutputStream outputFileStream = new FileOutputStream(outputFile);){
                    IOUtils.copy((InputStream)debInputStream, (OutputStream)outputFileStream);
                }
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, ArchiveException, URISyntaxException, InterruptedException {
        String url = Mamba.MICROMAMBA_URL;
        File tempFile = File.createTempFile("miniconda", ".tar.bz2");
        tempFile.deleteOnExit();
        URL website = FileDownloader.redirectedURL(new URL(url));
        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            long transferred = fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            System.out.print(tempFile.length());
        }
        String tarPath = "C:\\Users\\angel\\OneDrive\\Documentos\\pasteur\\git\\micromamba-1.5.1-1.tar";
        String mambaPath = "C:\\Users\\angel\\OneDrive\\Documentos\\pasteur\\git\\mamba";
        MambaInstallerUtils.unBZip2(new File("C:\\Users\\angel\\OneDrive\\Documentos\\pasteur\\git\\micromamba-1.5.1-1.tar.bz2"), new File(tarPath));
        MambaInstallerUtils.unTar(new File(tarPath), new File(mambaPath));
    }
}

